/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.tenant.OlapTenant;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="selector")
public class OlapEngineMdxEvalProfileSelector {
    @XmlAttribute(name="profile", required=true)
    private String profileName;
    @XmlAttribute(name="for", required=true)
    private String expression;
    @XmlTransient
    private Kind exprKind;
    @XmlTransient
    private Pattern exprPattern;

    public OlapEngineMdxEvalProfileSelector() {
    }

    public OlapEngineMdxEvalProfileSelector(String profileName, String expression) {
        this.profileName = profileName;
        this.expression = expression;
    }

    public void validate() throws OlapConfigurationException {
        if (CdStringUtils.isNullOrBlank((String)this.profileName)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"mdxEvalConfiguration.selector.profile"});
        }
        if (CdStringUtils.isNullOrBlank((String)this.expression)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"mdxEvalConfiguration.selector.for"});
        }
        if (this.expression.startsWith("user:")) {
            this.exprKind = Kind.USER;
        } else if (this.expression.startsWith("tenant:")) {
            this.exprKind = Kind.TENANT;
        } else if (this.expression.startsWith("role:")) {
            this.exprKind = Kind.ROLE;
        } else {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"mdxEvalConfiguration (icCube.xml) : unexpected selector expression (" + this.expression + ")"});
        }
        try {
            int pos = this.expression.indexOf(":");
            String expr = this.expression.substring(pos + 1);
            this.exprPattern = Pattern.compile(expr);
        }
        catch (RuntimeException ex) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"mdxEvalConfiguration (icCube.xml) : unexpected selector expression (" + this.expression + ")", ex});
        }
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isForUsers() {
        return this.exprKind == Kind.USER;
    }

    public boolean isForTenants() {
        return this.exprKind == Kind.TENANT;
    }

    public boolean isForRoles() {
        return this.exprKind == Kind.ROLE;
    }

    public boolean isAccepting(OlapPrincipal principal) {
        if (this.exprPattern == null) {
            throw new RuntimeException("internal error: missing MDX evaluation profile selector regular expression");
        }
        switch (this.exprKind.ordinal()) {
            case 0: {
                return this.isAccepting(principal.getName());
            }
            case 1: {
                OlapTenant tenant = principal.getTenant();
                return tenant != null && this.isAccepting(tenant.getName());
            }
            case 2: {
                return this.isAccepting(principal.getRoleNameForMdxExecutionProfile());
            }
        }
        throw new RuntimeException("internal error: unexpected MDX evaluation profile selector kind");
    }

    private boolean isAccepting(String input) {
        Matcher matcher = this.exprPattern.matcher(input);
        boolean accepting = matcher.matches();
        return accepting;
    }

    static enum Kind {
        USER,
        TENANT,
        ROLE;

    }
}

