/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfile;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfileForkMode;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfileMonitoringMode;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfileSelector;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.pub.principal.OlapPrincipal;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="mdxEvalConfiguration")
public class OlapEngineMdxEvalConfiguration {
    @XmlTransient
    private final List<OlapEngineMdxEvalProfileSelector> userSelectors = new ArrayList<OlapEngineMdxEvalProfileSelector>();
    @XmlTransient
    private final List<OlapEngineMdxEvalProfileSelector> tenantSelectors = new ArrayList<OlapEngineMdxEvalProfileSelector>();
    @XmlTransient
    private final List<OlapEngineMdxEvalProfileSelector> roleSelectors = new ArrayList<OlapEngineMdxEvalProfileSelector>();
    @XmlAttribute(name="monitoringMode", required=false)
    private OlapEngineMdxEvalProfileMonitoringMode monitoringMode;
    @XmlElement(name="activeMdxRequestCount", required=true)
    private int activeMdxRequestCount;
    @XmlElement(name="profile", required=true)
    private List<OlapEngineMdxEvalProfile> profiles;
    @XmlElement(name="selector", required=false)
    private List<OlapEngineMdxEvalProfileSelector> selectors;
    @XmlTransient
    private OlapEngineMdxEvalProfile defaultProfile;

    public static OlapEngineMdxEvalConfiguration setupFromProperties(OlapProperties properties) {
        OlapEngineMdxEvalConfiguration configuration = new OlapEngineMdxEvalConfiguration();
        configuration.activeMdxRequestCount = properties.getActiveMdxRequestCount();
        configuration.defaultProfile = new OlapEngineMdxEvalProfile("migrated-from-properties", OlapEngineMdxEvalProfileForkMode.SERVER, true, properties.getActiveMdxRequestCount(), properties.getSelectCellMaxCount(), -1, properties.getSingleMdxEvalThreadCount(), properties.getSingleMdxEvalQueueSize(), properties.getSingleMdxExtraEvalThreadCount(), properties.getSingleMdxExtraEvalQueueSize());
        configuration.profiles = new ArrayList<OlapEngineMdxEvalProfile>();
        configuration.profiles.add(configuration.defaultProfile);
        configuration.selectors = new ArrayList<OlapEngineMdxEvalProfileSelector>();
        return configuration;
    }

    public void validate() throws OlapConfigurationException {
        if (this.profiles == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"mdxEvalConfiguration.profile"});
        }
        for (OlapEngineMdxEvalProfile profile : this.profiles) {
            profile.validate();
        }
        this.defaultProfile = null;
        for (OlapEngineMdxEvalProfile profile : this.profiles) {
            if (!profile.isDefault()) continue;
            if (this.defaultProfile != null) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"mdxEvalConfiguration (icCube.xml) : duplicated default profile (" + this.defaultProfile.getName() + ") (" + profile.getName() + ")."});
            }
            this.defaultProfile = profile;
        }
        if (this.defaultProfile == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"mdxEvalConfiguration (icCube.xml) : no _ default _ profile has been defined."});
        }
        HashSet<String> uniqueProfileNames = new HashSet<String>();
        for (OlapEngineMdxEvalProfile profile : this.profiles) {
            if (uniqueProfileNames.contains(profile.getName())) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"mdxEvalConfiguration (icCube.xml) : duplicated profile names (" + profile.getName() + ")"});
            }
            uniqueProfileNames.add(profile.getName());
        }
        if (this.selectors != null) {
            for (OlapEngineMdxEvalProfileSelector selector : this.selectors) {
                selector.validate();
            }
            for (OlapEngineMdxEvalProfileSelector selector : this.selectors) {
                if (uniqueProfileNames.contains(selector.getProfileName())) continue;
                throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"mdxEvalConfiguration (icCube.xml) : the profile (" + selector.getProfileName() + ") referenced by a selector does not exist."});
            }
            for (OlapEngineMdxEvalProfileSelector selector : this.selectors) {
                if (selector.isForUsers()) {
                    this.userSelectors.add(selector);
                    continue;
                }
                if (selector.isForTenants()) {
                    this.tenantSelectors.add(selector);
                    continue;
                }
                if (selector.isForRoles()) {
                    this.roleSelectors.add(selector);
                    continue;
                }
                throw new RuntimeException("internal error: unexpected MDX evaluation profile selector");
            }
        }
    }

    public OlapEngineMdxEvalProfileMonitoringMode getMonitoringMode() {
        if (this.monitoringMode == null) {
            return OlapEngineMdxEvalProfileMonitoringMode.NONE;
        }
        return this.monitoringMode;
    }

    public int getActiveMdxRequestCount() {
        return this.activeMdxRequestCount;
    }

    public List<OlapEngineMdxEvalProfile> getProfiles() {
        return this.profiles;
    }

    public OlapEngineMdxEvalProfile getProfile(@Nullable OlapPrincipal principal) {
        if (principal != null && this.selectors != null && !this.selectors.isEmpty()) {
            OlapEngineMdxEvalProfile profile = this.getProfile(this.userSelectors, principal);
            if (profile != null) {
                return profile;
            }
            profile = this.getProfile(this.tenantSelectors, principal);
            if (profile != null) {
                return profile;
            }
            profile = this.getProfile(this.roleSelectors, principal);
            if (profile != null) {
                return profile;
            }
        }
        if (this.defaultProfile == null) {
            throw new RuntimeException("internal error: missing default MDX evaluation profile");
        }
        return this.defaultProfile;
    }

    @Nullable
    private OlapEngineMdxEvalProfile getProfile(List<OlapEngineMdxEvalProfileSelector> selectors, OlapPrincipal principal) {
        for (OlapEngineMdxEvalProfileSelector selector : selectors) {
            if (!selector.isAccepting(principal)) continue;
            String profileName = selector.getProfileName();
            return this.getProfile(profileName);
        }
        return null;
    }

    private OlapEngineMdxEvalProfile getProfile(String profileName) {
        for (OlapEngineMdxEvalProfile profile : this.profiles) {
            if (!profileName.equals(profile.getName())) continue;
            return profile;
        }
        throw new RuntimeException("internal error: missing MDX profile (" + profileName + ")");
    }

    public OlapEngineMdxEvalProfile addProfile(OlapEngineMdxEvalProfile profile) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<OlapEngineMdxEvalProfile>();
        }
        this.profiles.add(profile);
        return profile;
    }

    public OlapEngineMdxEvalProfileSelector addSelector(OlapEngineMdxEvalProfileSelector selector) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<OlapEngineMdxEvalProfileSelector>();
        }
        this.selectors.add(selector);
        return selector;
    }

    public List<OlapEngineMdxEvalProfileSelector> getSelectors() {
        return this.selectors;
    }
}

