/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component;

import crazydev.common.utils.CdByteSize;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="backupConfiguration")
public class OlapEngineBackupConfiguration {
    @XmlAttribute(name="active", required=true)
    private boolean active;
    @XmlElement(name="maxFileSize", required=true)
    private String maxFileSize;
    @XmlElement(name="outBufferSize", required=true)
    private String outBufferSize;
    @XmlElement(name="inBufferSize", required=true)
    private String inBufferSize;
    @XmlElement(name="compression", required=true)
    private String compression;
    @XmlElement(name="loadPartitionHistory", required=false)
    @Nullable
    private String loadPartitionHistory;
    @XmlElement(name="backupHistory", required=false)
    @Nullable
    private String backupHistory;
    @XmlTransient
    private Long maxFileSizeB;
    @XmlTransient
    private Integer outBufferSizeB;
    @XmlTransient
    private Integer inBufferSizeB;
    @XmlTransient
    private Boolean compressing;
    @XmlTransient
    private Integer compressionBlockSizeB;
    @XmlTransient
    private boolean withPartitionHistory;
    @XmlTransient
    private boolean withBackupHistory;

    public OlapEngineBackupConfiguration() {
    }

    public OlapEngineBackupConfiguration(boolean active, String maxFileSize, String outputBufferSize, String inputBufferSize, String compression, @Nullable String loadPartitionHistory, @Nullable String backupHistory) {
        this.active = active;
        this.maxFileSize = maxFileSize;
        this.outBufferSize = outputBufferSize;
        this.inBufferSize = inputBufferSize;
        this.compression = compression;
        this.loadPartitionHistory = loadPartitionHistory;
        this.backupHistory = backupHistory;
    }

    public static OlapEngineBackupConfiguration none() {
        try {
            OlapEngineBackupConfiguration configuration = new OlapEngineBackupConfiguration(false, "-1", "-1", "-1", "NONE", null, null);
            configuration.validate();
            return configuration;
        }
        catch (OlapConfigurationException ex) {
            throw new RuntimeException("internal error: could not create configuration", (Throwable)((Object)ex));
        }
    }

    public static OlapEngineBackupConfiguration lz4() {
        try {
            OlapEngineBackupConfiguration configuration = new OlapEngineBackupConfiguration(true, "-1", "-1", "-1", "LZ4", null, null);
            configuration.validate();
            return configuration;
        }
        catch (OlapConfigurationException ex) {
            throw new RuntimeException("internal error: could not create configuration", (Throwable)((Object)ex));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate() throws OlapConfigurationException {
        if (this.maxFileSize == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"maxFileSize"});
        }
        if (this.maxFileSize.trim().equals("-1")) {
            this.maxFileSizeB = -1L;
        } else {
            try {
                this.maxFileSizeB = CdByteSize.parse((String)this.maxFileSize).getSize();
            }
            catch (RuntimeException ex) {
                throw new OlapConfigurationException((Throwable)ex, OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"maxFileSize error: " + ex.getMessage()});
            }
        }
        if (this.outBufferSize == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"outBufferSize"});
        }
        if (this.outBufferSize.trim().equals("-1")) {
            this.outBufferSizeB = 8192;
        } else {
            try {
                this.outBufferSizeB = (int)CdByteSize.parse((String)this.outBufferSize).getSize();
            }
            catch (RuntimeException ex) {
                throw new OlapConfigurationException((Throwable)ex, OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"outBufferSize error: " + ex.getMessage()});
            }
        }
        if (this.inBufferSize == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"inBufferSize"});
        }
        if (this.inBufferSize.trim().equals("-1")) {
            this.inBufferSizeB = 8192;
        } else {
            try {
                this.inBufferSizeB = (int)CdByteSize.parse((String)this.inBufferSize).getSize();
            }
            catch (RuntimeException ex) {
                throw new OlapConfigurationException((Throwable)ex, OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"inBufferSize error: " + ex.getMessage()});
            }
        }
        if (this.compression == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"compression"});
        }
        String compression_ = this.compression.trim().toUpperCase();
        if (compression_.startsWith("NONE")) {
            this.compressing = false;
        } else {
            if (!compression_.startsWith("LZ4")) throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"invalid compression value [" + this.compression + "]"});
            this.compressing = true;
            if (compression_.equals("LZ4")) {
                this.compressionBlockSizeB = 0x100000;
            } else {
                String blockSize = compression_.substring(4);
                try {
                    this.compressionBlockSizeB = (int)CdByteSize.parse((String)blockSize).getSize();
                }
                catch (RuntimeException ex) {
                    throw new OlapConfigurationException((Throwable)ex, OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"compression error: " + ex.getMessage()});
                }
            }
        }
        if (this.loadPartitionHistory != null) {
            String loadPartitionHistory_ = this.loadPartitionHistory.trim().toUpperCase();
            if (loadPartitionHistory_.startsWith("KEEP")) {
                this.withPartitionHistory = true;
            } else {
                if (!loadPartitionHistory_.startsWith("DISCARD")) throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"invalid loadPartitionHistory value [" + this.loadPartitionHistory + "]"});
                this.withPartitionHistory = false;
            }
        } else {
            this.withPartitionHistory = true;
        }
        if (this.backupHistory != null) {
            String backupHistory_ = this.backupHistory.trim().toUpperCase();
            if (backupHistory_.startsWith("KEEP")) {
                this.withBackupHistory = true;
                return;
            } else {
                if (!backupHistory_.startsWith("DISCARD")) throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"invalid backupHistory value [" + backupHistory_ + "]"});
                this.withBackupHistory = false;
            }
            return;
        } else {
            this.withBackupHistory = true;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public long getMaxFileSizeB() {
        if (this.maxFileSizeB == null) {
            throw new RuntimeException("internal error: missing validated maxFileSize");
        }
        return this.maxFileSizeB;
    }

    public String getOutBufferSize() {
        return this.outBufferSize;
    }

    public int getOutBufferSizeB() {
        if (this.outBufferSizeB == null) {
            throw new RuntimeException("internal error: missing validated outBufferSize");
        }
        return this.outBufferSizeB;
    }

    public String getInBufferSize() {
        return this.inBufferSize;
    }

    public int getInBufferSizeB() {
        if (this.inBufferSizeB == null) {
            throw new RuntimeException("internal error: missing validated outBufferSize");
        }
        return this.inBufferSizeB;
    }

    public String getCompression() {
        return this.compression;
    }

    public boolean isCompressing() {
        if (this.compressing == null) {
            throw new RuntimeException("internal error: missing validated compression");
        }
        return this.compressing;
    }

    public int getCompressionBlockSizeB() {
        if (this.compressionBlockSizeB == null) {
            throw new RuntimeException("internal error: missing validated compression");
        }
        return this.compressionBlockSizeB;
    }

    public void setLoadPartitionHistory(String loadPartitionHistory) {
        this.loadPartitionHistory = loadPartitionHistory;
    }

    public void setBackupHistory(String backupHistory) {
        this.backupHistory = backupHistory;
    }

    public boolean isWithPartitionHistory() {
        return this.withPartitionHistory;
    }

    public boolean isServerWithBackupHistory() {
        return this.withBackupHistory;
    }
}

