/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration;

import crazydev.iccube.configuration.OlapConfigurationException;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="webApp")
public class OlapWebAppConfiguration {
    public static final String SESSION_COOKIE_HTTP_ONLY = "org.eclipse.jetty.session.SessionCookie.httpOnly";
    public static final String SESSION_COOKIE_SAME_SITE = "org.eclipse.jetty.session.SessionCookie.sameSite";
    public static final String SESSION_COOKIE_SECURE = "org.eclipse.jetty.session.SessionCookie.secure";
    @XmlElementRef(type=ContextParam.class)
    private List<ContextParam> contextParams;
    @XmlElement(name="sessionLess", required=false)
    private boolean sessionLess;

    public void validate() throws OlapConfigurationException {
    }

    public List<ContextParam> getContextParams() {
        return this.contextParams == null ? Collections.emptyList() : this.contextParams;
    }

    public boolean isSessionCookieHttpOnly() {
        if (this.contextParams != null) {
            for (ContextParam contextParam : this.contextParams) {
                if (!contextParam.name.equals(SESSION_COOKIE_HTTP_ONLY)) continue;
                return "true".equalsIgnoreCase(contextParam.value);
            }
        }
        return true;
    }

    @Nullable
    public String getSessionCookieSameSite() {
        if (this.contextParams != null) {
            for (ContextParam contextParam : this.contextParams) {
                if (!contextParam.name.equals(SESSION_COOKIE_SAME_SITE)) continue;
                return contextParam.value.toUpperCase();
            }
        }
        return null;
    }

    public boolean isSessionCookieSecure() {
        if (this.contextParams != null) {
            for (ContextParam contextParam : this.contextParams) {
                if (!contextParam.name.equals(SESSION_COOKIE_SECURE)) continue;
                return "true".equalsIgnoreCase(contextParam.value);
            }
        }
        return false;
    }

    public boolean isSessionLess() {
        return this.sessionLess;
    }

    @XmlRootElement(name="context-param")
    public static class ContextParam {
        @XmlElement(name="param-name", required=true)
        private String name;
        @XmlElement(name="param-value", required=true)
        private String value;

        public ContextParam() {
        }

        public ContextParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

