/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.common.executor;

import crazydev.common.exception.CdRuntimeException;
import crazydev.iccube.common.IOlapContext;
import crazydev.iccube.common.executor.IOlapThreadPoolExecutorServiceListener;
import crazydev.iccube.common.executor.IOlapThreadPoolExecutorTask;
import crazydev.iccube.common.executor.IOlapThreadPoolExecutorTaskFactory;
import crazydev.iccube.common.executor.OlapThreadFactory;
import crazydev.iccube.common.executor.OlapThreadPoolContextFutureTask;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorOrderedFutureTaskQueue;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorServiceQueue;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public abstract class OlapThreadPoolExecutorService<CTXT extends IOlapContext>
extends ThreadPoolExecutor {
    private final String type;

    public OlapThreadPoolExecutorService(String type, int threadCount) {
        super(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new OlapThreadPoolExecutorServiceQueue<OlapThreadPoolContextFutureTask>(new OlapThreadPoolExecutorOrderedFutureTaskQueue()), new OlapThreadFactory(type));
        this.type = type;
    }

    public boolean isMdx() {
        return false;
    }

    public int getQueuedTaskCount() {
        return this.getQueue().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTasks(CTXT context, int queueSize, IOlapThreadPoolExecutorTaskFactory tasks, IOlapThreadPoolExecutorServiceListener listener) {
        OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy = tasks.getSchedulingPolicy();
        ExecutingContext executingContext = this.createExecutingContext(schedulingPolicy, context, queueSize);
        if (executingContext == null) {
            return;
        }
        listener.onProcessTasksStarted();
        try {
            try {
                Object task;
                tasks.init();
                int taskCount = 0;
                do {
                    try {
                        task = tasks.next();
                    }
                    catch (RuntimeException ex) {
                        listener.onNextTaskException(ex);
                        executingContext.onNextTaskException(ex);
                        break;
                    }
                    if (task == null) break;
                    ++taskCount;
                } while (this.submitTask(executingContext, (IOlapThreadPoolExecutorTask)task));
                listener.onWaitingForTaskProcessingCompletion(taskCount);
                this.waitForAllTasks(executingContext);
                listener.onWaitingForTaskProcessingCompleted();
            }
            finally {
                tasks.done();
                listener.onProcessTasksCompleted();
            }
        }
        finally {
            this.deleteExecutingContext(executingContext);
        }
    }

    @Nullable
    private ExecutingContext createExecutingContext(OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy, CTXT context, int queueSize) {
        if (queueSize <= 0) {
            throw new IllegalArgumentException();
        }
        return this.doCreateExecutingContext(this.type, schedulingPolicy, context, queueSize);
    }

    protected abstract ExecutingContext doCreateExecutingContext(String var1, OlapThreadPoolExecutorTaskSchedulingPolicy var2, CTXT var3, int var4);

    private void deleteExecutingContext(ExecutingContext executingContext) {
        if (executingContext != null) {
            executingContext.done.set(true);
        }
    }

    private boolean submitTask(ExecutingContext executingContext, IOlapThreadPoolExecutorTask task) {
        if (!executingContext.willExecuteTask()) {
            return false;
        }
        try {
            executingContext.queueSizeSemaphore.acquire();
        }
        catch (InterruptedException ex) {
            return false;
        }
        try {
            OlapThreadPoolContextFutureTask future = new OlapThreadPoolContextFutureTask(executingContext, task);
            this.execute(future);
            executingContext.registerSubmittedFuture(future);
            return true;
        }
        catch (RuntimeException ex) {
            executingContext.queueSizeSemaphore.release();
            executingContext.reportRuntimeExceptionOnSubmit(ex);
            return false;
        }
    }

    @Override
    public void execute(Runnable command) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Task " + command.toString() + " rejected from " + this.toString());
        }
        OlapThreadPoolContextFutureTask task = (OlapThreadPoolContextFutureTask)command;
        if (!this.getQueue().offer(task)) {
            throw new RejectedExecutionException("Task " + command.toString() + " rejected from " + this.toString());
        }
        if (this.isShutdown() && this.remove(task)) {
            task.cancel(false);
        } else {
            this.prestartAllCoreThreads();
        }
    }

    public void waitForAllTasks(ExecutingContext executingContext) throws CdRuntimeException {
        executingContext.waitForAllTasksAndReportExecutionException();
    }

    @Override
    protected void beforeExecute(Thread worker, Runnable command) {
        super.beforeExecute(worker, command);
        OlapThreadPoolContextFutureTask future = (OlapThreadPoolContextFutureTask)command;
        future.executingContext.registerRunningFuture(future);
    }

    @Override
    protected void afterExecute(Runnable command, Throwable error) {
        super.afterExecute(command, error);
        OlapThreadPoolContextFutureTask future = (OlapThreadPoolContextFutureTask)command;
        OlapThreadPoolExecutorServiceQueue queue = (OlapThreadPoolExecutorServiceQueue)this.getQueue();
        queue.onAfterExecute(future);
        future.executingContext.queueSizeSemaphore.release();
        future.executingContext.unregisterRunningFuture(future);
        future.executingContext.unregisterSubmittedFuture(future, error);
    }

    public static abstract class ExecutingContext<CTXT extends IOlapContext> {
        private final String type;
        private final OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy;
        private final CTXT executionContext;
        private final AtomicBoolean done = new AtomicBoolean();
        private final Semaphore queueSizeSemaphore;
        private final Object completedFutureLOCK = new Object();
        private final List<OlapThreadPoolContextFutureTask> runningFutures = new ArrayList<OlapThreadPoolContextFutureTask>();
        private final AtomicReference<CdRuntimeException> exception = new AtomicReference();
        private int submittedFutureCount;
        private int completedFutureCount;

        public ExecutingContext(String type, OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy, CTXT executionContext, int queueSize) {
            this.type = type;
            this.schedulingPolicy = schedulingPolicy;
            this.executionContext = executionContext;
            this.queueSizeSemaphore = new Semaphore(queueSize);
        }

        String getType() {
            return this.type;
        }

        OlapThreadPoolExecutorTaskSchedulingPolicy getSchedulingPolicy() {
            return this.schedulingPolicy;
        }

        boolean willExecuteTask() {
            return !this.executionContext.isCancelling() && this.exception.get() == null;
        }

        boolean isDone() {
            return this.done.get();
        }

        private void registerSubmittedFuture(OlapThreadPoolContextFutureTask future) {
            ++this.submittedFutureCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterSubmittedFuture(OlapThreadPoolContextFutureTask future, Throwable error) {
            if (!future.isDone()) {
                throw new RuntimeException("internal error: inconsistent " + this.type + " execution (1)");
            }
            if (error != null) {
                throw new RuntimeException("internal error: inconsistent " + this.type + " execution (2)");
            }
            try {
                future.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException ex) {
                OlapLoggers.TASK_EVALUATION.error((Object)"Task error (+)", (Throwable)ex);
                this.reportExecutionExceptionOnExecute(ex);
            }
            catch (RuntimeException ex) {
                OlapLoggers.TASK_EVALUATION.error((Object)"Task error (!)", (Throwable)ex);
                this.reportRuntimeExceptionOnExecute(this.executionContext, ex);
            }
            Object object = this.completedFutureLOCK;
            synchronized (object) {
                ++this.completedFutureCount;
                this.completedFutureLOCK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerRunningFuture(OlapThreadPoolContextFutureTask future) {
            List<OlapThreadPoolContextFutureTask> list = this.runningFutures;
            synchronized (list) {
                this.runningFutures.add(future);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterRunningFuture(OlapThreadPoolContextFutureTask future) {
            List<OlapThreadPoolContextFutureTask> list = this.runningFutures;
            synchronized (list) {
                this.runningFutures.remove(future);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForAllTasksAndReportExecutionException() throws CdRuntimeException {
            this.waitForAllTasks();
            List<OlapThreadPoolContextFutureTask> list = this.runningFutures;
            synchronized (list) {
                if (!this.runningFutures.isEmpty()) {
                    throw new RuntimeException("internal error: inconsistent " + this.type + " execution (3)");
                }
            }
            CdRuntimeException actualException = this.exception.get();
            if (actualException != null) {
                throw actualException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForAllTasks() {
            int target = this.submittedFutureCount;
            Object object = this.completedFutureLOCK;
            synchronized (object) {
                while (this.completedFutureCount != target) {
                    if (!this.willExecuteTask()) {
                        this.cancelRunningFutures();
                    }
                    try {
                        this.completedFutureLOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelRunningFutures() {
            List<OlapThreadPoolContextFutureTask> list = this.runningFutures;
            synchronized (list) {
                if (this.willExecuteTask()) {
                    throw new RuntimeException("internal error: inconsistent " + this.type + " execution (4)");
                }
                for (OlapThreadPoolContextFutureTask future : this.runningFutures) {
                    future.cancel(true);
                }
            }
        }

        public void onNextTaskException(RuntimeException ex) {
            this.reportRuntimeExceptionOnGenerate(ex);
        }

        private void reportRuntimeExceptionOnGenerate(RuntimeException ex) {
            if (ex instanceof CdRuntimeException) {
                this.reportResolvedCdRuntimeException(this.executionContext, (CdRuntimeException)((Object)ex));
            } else {
                this.reportResolvedRuntimeException(this.executionContext, ex);
            }
        }

        private void reportRuntimeExceptionOnSubmit(RuntimeException ex) {
            if (ex instanceof CdRuntimeException) {
                this.reportResolvedCdRuntimeException(this.executionContext, (CdRuntimeException)((Object)ex));
            } else {
                this.reportResolvedRuntimeException(this.executionContext, ex);
            }
        }

        private void reportExecutionExceptionOnExecute(ExecutionException ex) {
            Throwable cause = ex.getCause();
            while (cause instanceof ExecutionException) {
                cause = cause.getCause();
            }
            if (cause instanceof CdRuntimeException) {
                this.reportResolvedCdRuntimeException(this.executionContext, (CdRuntimeException)cause);
            } else if (cause instanceof RuntimeException) {
                this.reportResolvedRuntimeException(this.executionContext, (RuntimeException)cause);
            } else {
                this.reportResolvedException(this.executionContext, cause);
            }
        }

        private void reportRuntimeExceptionOnExecute(CTXT executionContext, RuntimeException ex) {
            if (ex instanceof CdRuntimeException) {
                this.reportResolvedCdRuntimeException(executionContext, (CdRuntimeException)((Object)ex));
            } else {
                this.reportResolvedRuntimeException(executionContext, ex);
            }
        }

        protected boolean reportException(CdRuntimeException error) {
            return this.exception.compareAndSet(null, error);
        }

        protected abstract void reportResolvedException(CTXT var1, Throwable var2);

        protected abstract void reportResolvedRuntimeException(CTXT var1, RuntimeException var2);

        protected abstract void reportResolvedCdRuntimeException(CTXT var1, CdRuntimeException var2);
    }
}

