/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.common;

import crazydev.iccube.common.OlapListener;
import java.lang.reflect.Array;
import org.jetbrains.annotations.Nullable;

public class OlapListenerList {
    private static final Object[] NULL_ARRAY = new Object[0];
    protected Object[] listenerList = NULL_ARRAY;

    public void initFrom(@Nullable OlapListenerList listeners) {
        if (listeners != null && listeners.listenerList.length > 0) {
            this.listenerList = new Object[listeners.listenerList.length];
            System.arraycopy(listeners.listenerList, 0, this.listenerList, 0, this.listenerList.length);
        }
    }

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    public int getListenerCount(Class<?> t) {
        Object[] lList = this.listenerList;
        return this.getListenerCount(lList, t);
    }

    private int getListenerCount(Object[] list, Class t) {
        int count = 0;
        for (int i = 0; i < list.length; i += 2) {
            if (t != (Class)list[i]) continue;
            ++count;
        }
        return count;
    }

    public <T extends OlapListener> T[] getListeners(Class<T> t) {
        Object[] lList = this.listenerList;
        int n = this.getListenerCount(lList, t);
        OlapListener[] result = (OlapListener[])Array.newInstance(t, n);
        int j = 0;
        for (int i = lList.length - 2; i >= 0; i -= 2) {
            if (lList[i] != t) continue;
            result[j++] = (OlapListener)lList[i + 1];
        }
        return result;
    }

    public synchronized <T extends OlapListener> void add(Class<T> t, T l) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + String.valueOf(l) + " is not of type " + String.valueOf(t));
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new Object[]{t, l};
        } else {
            int i = this.listenerList.length;
            Object[] tmp = new Object[i + 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, i);
            tmp[i] = t;
            tmp[i + 1] = l;
            this.listenerList = tmp;
        }
    }

    public synchronized <T extends OlapListener> void remove(Class<T> t, T l) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + String.valueOf(l) + " is not of type " + String.valueOf(t));
        }
        int index = -1;
        for (int i = this.listenerList.length - 2; i >= 0; i -= 2) {
            if (this.listenerList[i] != t || !this.listenerList[i + 1].equals(l)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            Object[] tmp = new Object[this.listenerList.length - 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, index);
            if (index < tmp.length) {
                System.arraycopy(this.listenerList, index + 2, tmp, index, tmp.length - index);
            }
            this.listenerList = tmp.length == 0 ? NULL_ARRAY : tmp;
        }
    }
}

