/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.fastcj;

import crazydev.common.utils.CdArrayUtils;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.ICjIteratorTupleCompleter;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import it.unimi.dsi.fastutil.ints.IntArrayList;

public class CjIteratorTupleForwardCompleter
implements ICjIteratorTupleCompleter {
    public final int i;
    public final int j;
    private final IntArrayList list;
    private final OlapLevel baseLevel;

    public CjIteratorTupleForwardCompleter(IntArrayList list, int i, int j, OlapLevel baseLevel) {
        this.list = list;
        this.i = i;
        this.j = j;
        this.baseLevel = baseLevel;
    }

    @Override
    public boolean complete(OlapMember[] currCombination) {
        OlapMember attrMember = currCombination[this.i];
        int baseIdx = this.list.getInt(attrMember.getDataHandlerIdx());
        OlapMember jMember = this.baseLevel.getDataHandler().getMember(baseIdx - 1);
        if (jMember == null) {
            return false;
        }
        currCombination[this.j] = jMember;
        return true;
    }

    @Override
    public String log() {
        return this.j + " (" + this.i + ")";
    }

    public static CjIteratorTupleForwardCompleter build(int i, int j, CjFastListBaseIterator attriI, CjFastListBaseIterator baseIterJ) {
        int k;
        OlapHierarchy hierI = attriI.getOlapHierarchy();
        IntArrayList list = new IntArrayList();
        for (k = 0; k < baseIterJ.tupleList.size(); ++k) {
            OlapMember baseMember = (OlapMember)baseIterJ.tupleList.get(k);
            OlapMember attributeMember = baseMember.getAttributeMember(hierI);
            if (attributeMember == null) {
                return null;
            }
            int aIdx = attributeMember.getDataHandlerIdx();
            if (aIdx + 1 >= list.size()) {
                CdArrayUtils.resize((IntArrayList)list, (int)(aIdx + 1));
            }
            if (list.getInt(aIdx) != 0) {
                return null;
            }
            list.set(aIdx, baseMember.getDataHandlerIdx() + 1);
        }
        for (k = 0; k < attriI.tupleList.size(); ++k) {
            OlapMember attrMember = (OlapMember)attriI.tupleList.get(k);
            if (list.getInt(attrMember.getDataHandlerIdx()) != 0) continue;
            return null;
        }
        list.trim();
        return new CjIteratorTupleForwardCompleter(list, i, j, baseIterJ.getOlapLevel());
    }
}

