/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.fastcj;

import crazydev.iccube.collection.olapiterator.fastcj.CjBitmapHelper;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastTwoAutoExistBuilder;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastTwoFilter;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.Nullable;

class CjFastTwoReducer {
    final CjFastListBaseIterator from;
    final CjFastListIterator to;
    final MutableLong counter;
    private final OlapFastCrossjoinContext context;
    private final CjFastTwoFilter filter;

    CjFastTwoReducer(OlapFastCrossjoinContext context, CjFastListBaseIterator from, CjFastListIterator to, CjFastTwoFilter filter) {
        this.context = context;
        this.from = from;
        this.to = to;
        this.filter = filter;
        this.counter = new MutableLong(0L);
    }

    CjFastTwoReducer newClone(List<CjFastListBaseIterator> newIterators) {
        CjFastListBaseIterator nFrom = newIterators.get(this.from.index());
        CjFastListIterator nTo = (CjFastListIterator)newIterators.get(this.to.index());
        return new CjFastTwoReducer(this.context, nFrom, nTo, this.filter);
    }

    @Nullable
    static CjFastTwoReducer create(OlapFastCrossjoinContext context, CjFastListBaseIterator from, CjFastListIterator to) {
        CjFastTwoFilter calc;
        if (from.getDimensionality().intersects(to.getDimensionality()) && (calc = CjFastTwoAutoExistBuilder.create(context, from, to)) != null) {
            return new CjFastTwoReducer(context, from, to, calc);
        }
        return null;
    }

    boolean onNewCurrentTuple(OlapTuple fromCurrentTuple, int currentTupleIndex) {
        CjBitmapHelper.CjTupleListReducer newNextBitmap;
        int fromIndex = this.from.index();
        CjBitmapHelper.CjTupleListReducer nextBitmap = this.to.getReducingBitmap(fromIndex);
        boolean notFiltering = this.to.isNotFiltering(nextBitmap);
        if (this.filter.isBitmapBased()) {
            CjBitmapHelper.CjBitmap bitmap2 = this.filter.getBitmap(fromCurrentTuple, currentTupleIndex);
            newNextBitmap = notFiltering && bitmap2 != null ? bitmap2 : CjBitmapHelper.and(nextBitmap, bitmap2);
        } else {
            CjBitmapHelper.CjBitmap newNextCjBitmap = CjBitmapHelper.createBitmap();
            List toTupleList = this.to.tupleList;
            nextBitmap.forEach(toIndex -> {
                this.counter.increment();
                if (this.filter.isNoEmpty(fromCurrentTuple, (OlapTuple)toTupleList.get(toIndex), currentTupleIndex, toIndex)) {
                    newNextCjBitmap.setBit(toIndex);
                }
            });
            newNextBitmap = newNextCjBitmap;
        }
        if (newNextBitmap == null || newNextBitmap.isEmpty()) {
            return false;
        }
        this.to.reducingBitmaps.set(fromIndex + 1, (Object)newNextBitmap);
        return true;
    }

    public boolean performInit() {
        this.filter.performInit();
        return true;
    }

    public String logName() {
        return this.filter.logName();
    }
}

