/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.fastcj;

import crazydev.iccube.collection.olapiterator.fastcj.CjFastActualBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.ICjIteratorTupleCompleter;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.util.OlapExistHelper;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

class CjFastActualSingleItemIterator
implements CjFastActualBaseIterator {
    private final OlapTuple theTuple;
    private final boolean isKO;
    private boolean isFinished;

    CjFastActualSingleItemIterator(List<CjFastListBaseIterator> oneIter, OlapTupleDimensionality tupleDimensionality, List<ICjIteratorTupleCompleter> completers) {
        int numberOfMembers = 0;
        for (CjFastListBaseIterator iterator : oneIter) {
            numberOfMembers += iterator.getTupleNumberOfMembers();
        }
        OlapMember[] currCombination = new OlapMember[numberOfMembers];
        for (CjFastListBaseIterator iterator : oneIter) {
            OlapTuple theTuple = iterator.getOneTuple();
            theTuple.addMembersInArray(currCombination, iterator.currenTuplePos);
        }
        completers.forEach(c -> c.complete(currCombination));
        this.theTuple = OlapTupleFactory.instance(tupleDimensionality, currCombination);
        this.isKO = !OlapExistHelper.exists(this.theTuple);
    }

    @Override
    public void reset() {
        this.isFinished = false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @Nullable
    public OlapTuple next() {
        if (this.isFinished || this.isKO) {
            return null;
        }
        this.isFinished = true;
        return this.theTuple;
    }

    @Override
    public void logInfo(Logger logger, String infoSize) {
    }
}

