/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.fastcj;

import crazydev.common.collection.CdPair;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastActualBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastActualIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CjFastActualParallelIteratorNG
implements CjFastActualBaseIterator {
    public static final AtomicInteger TEST_RESET_COUNT = new AtomicInteger();
    @Nullable
    public static Integer TEST_CJ_N_THREADS = null;
    @Nullable
    public static Integer TEST_CJ_MAX_PRECALCULATED = null;
    @Nullable
    public static Integer TEST_CJ_MAX_PRECALCULATED_TUPLES = null;
    private final int threadCount;
    private final int maxPreCalculated;
    private final int maxPreCalculatedTuples;
    private final ExecutorService pool;
    private final OlapFastCrossjoinContext context;
    private final CjFastActualIterator theOne;
    private final int itemLimit;
    private final ConcurrentLinkedDeque<CjFastActualIterator> cachedIters;
    private final Int2ObjectOpenHashMap<Future<CdPair<CjFastActualIterator, List<OlapTuple>>>> prefetchedIters = new Int2ObjectOpenHashMap();
    private int firstIterTupleIdx;
    private int currentMiniTuplesPos;
    private CjFastActualIterator currentIter;
    private List<OlapTuple> currentMiniTuples;
    private boolean stop;
    private int combinationCount = 0;
    private int statsFromIteration;
    private int statsFromPrefetched;
    private int statsCountPrefetched;
    private int statsCountPrefetchedAll;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CjFastActualParallelIteratorNG(OlapFastCrossjoinContext context, CjFastActualIterator theOne, int itemLimit) {
        this.context = context;
        this.theOne = theOne;
        this.itemLimit = itemLimit;
        this.threadCount = TEST_CJ_N_THREADS == null ? context.getNeCjThreadCount() : TEST_CJ_N_THREADS.intValue();
        this.maxPreCalculated = TEST_CJ_MAX_PRECALCULATED == null ? context.getNeCjMaxPreCalculated() : TEST_CJ_MAX_PRECALCULATED.intValue();
        this.maxPreCalculatedTuples = TEST_CJ_MAX_PRECALCULATED_TUPLES == null ? context.getNeCjMaxPreCalculatedTuples() : TEST_CJ_MAX_PRECALCULATED_TUPLES.intValue();
        this.pool = Executors.newFixedThreadPool(this.threadCount);
        try {
            ((ThreadPoolExecutor)this.pool).prestartAllCoreThreads();
        }
        finally {
            context.registerHousekeeper(() -> {
                OlapLoggers.MDX_EVALUATION.debug((Object)"[fast-crossjoin] parallel iterator housekeeping");
                this.pool.shutdownNow();
            });
        }
        this.cachedIters = new ConcurrentLinkedDeque();
    }

    @Override
    public void reset() {
        TEST_RESET_COUNT.incrementAndGet();
        this.theOne.reset();
        this.firstIterTupleIdx = 0;
        this.currentMiniTuplesPos = 0;
        this.currentIter = null;
        this.currentMiniTuples = null;
        this.combinationCount = 0;
        this.stop = false;
        this.statsFromIteration = 0;
        this.statsFromPrefetched = 0;
        this.statsCountPrefetched = 0;
        this.statsCountPrefetchedAll = 0;
        this.prefetchedIters.clear();
        this.cachedIters.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.theOne.isEmpty();
    }

    @Override
    @Nullable
    public OlapTuple next() {
        if (this.itemLimit != -1 && this.combinationCount >= this.itemLimit) {
            this.stop = true;
            return null;
        }
        OlapTuple next = this.doNext();
        if (next != null) {
            ++this.combinationCount;
        }
        return next;
    }

    @Nullable
    public OlapTuple doNext() {
        OlapTuple next;
        if (!this.theOne.hasFirstItemAtPosition(this.firstIterTupleIdx)) {
            return null;
        }
        if (this.firstIterTupleIdx == 0 && this.currentIter == null) {
            this.toNextIteratorAndPrefetch();
            if (this.stop) {
                return null;
            }
            OlapTuple next2 = this.currentIter.next();
            if (next2 != null) {
                ++this.statsFromIteration;
                return next2;
            }
            return this.moveToNextIterator();
        }
        if (this.currentMiniTuples != null) {
            if (this.currentMiniTuplesPos < this.currentMiniTuples.size()) {
                ++this.statsCountPrefetched;
                return this.currentMiniTuples.get(this.currentMiniTuplesPos++);
            }
            this.currentMiniTuples = null;
        }
        ++this.statsFromIteration;
        OlapTuple olapTuple = next = this.currentIter == null ? null : this.currentIter.next();
        if (next == null) {
            return this.moveToNextIterator();
        }
        return next;
    }

    private OlapTuple moveToNextIterator() {
        ++this.firstIterTupleIdx;
        if (!this.theOne.hasFirstItemAtPosition(this.firstIterTupleIdx)) {
            return null;
        }
        this.toNextIteratorAndPrefetch();
        if (this.stop) {
            return null;
        }
        return this.doNext();
    }

    private void toNextIteratorAndPrefetch() {
        int numberTasks = this.maxPreCalculated - this.prefetchedIters.size();
        if (numberTasks > 0) {
            int firstEmpty = this.firstIterTupleIdx;
            while (this.prefetchedIters.containsKey(++firstEmpty)) {
            }
            for (int i = firstEmpty; i < firstEmpty + numberTasks && this.theOne.hasFirstItemAtPosition(i); ++i) {
                CjFastActualIterator iterator = this.getOrCreate(i);
                this.prefetchedIters.put(i, this.pool.submit(() -> this.doPrefetchedFirstN(iterator)));
            }
        }
        this.releaseIter(this.currentIter);
        Future future = (Future)this.prefetchedIters.get(this.firstIterTupleIdx);
        if (future != null) {
            this.prefetchedIters.remove(this.firstIterTupleIdx);
            try {
                CdPair cache = (CdPair)future.get();
                this.currentIter = (CjFastActualIterator)cache.fst;
                this.currentMiniTuples = (List)cache.snd;
            }
            catch (ExecutionException ex) {
                OlapLoggers.MDX_EVALUATION.error((Object)"[mdx] parallel non-empty crossjoin error", (Throwable)ex);
                Throwable actual = ex.getCause();
                if (actual instanceof OlapException) {
                    OlapException olapError = (OlapException)((Object)actual);
                    throw olapError;
                }
                if (actual != null) {
                    throw new OlapEvaluationException(actual, this.context.getErrorContext(), OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{actual.getMessage()});
                }
                throw new OlapEvaluationException(ex, this.context.getErrorContext(), OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{ex.getMessage()});
            }
            catch (InterruptedException ex) {
                OlapLoggers.MDX_EVALUATION.info((Object)"[mdx] parallel non-empty crossjoin interrupted");
                this.currentIter = null;
                this.currentMiniTuples = null;
                this.stop = true;
            }
        } else {
            this.currentIter = this.getOrCreate(this.firstIterTupleIdx);
            this.currentMiniTuples = null;
        }
        this.currentMiniTuplesPos = 0;
    }

    private void releaseIter(CjFastActualIterator iter) {
        if (iter != null) {
            this.cachedIters.push(iter);
        }
    }

    private CjFastActualIterator getOrCreate(int tupleIdx) {
        CjFastActualIterator iter = this.cachedIters.poll();
        if (iter == null) {
            iter = this.theOne.newCopy();
        }
        iter.setIterateOnly(tupleIdx);
        iter.reset();
        return iter;
    }

    @Nullable
    private CdPair<CjFastActualIterator, List<OlapTuple>> doPrefetchedFirstN(CjFastActualIterator iterator) {
        OlapTuple tuple;
        ++this.statsCountPrefetched;
        int count = 0;
        ArrayList<OlapTuple> miniTuples = new ArrayList<OlapTuple>();
        while ((tuple = iterator.next()) != null) {
            miniTuples.add(tuple);
            if ((count & 0x3F) == 63 && this.context.isCancelling()) {
                return null;
            }
            if (this.stop) {
                return null;
            }
            if (++count <= this.maxPreCalculatedTuples) continue;
            return new CdPair((Object)iterator, miniTuples);
        }
        this.releaseIter(iterator);
        ++this.statsCountPrefetchedAll;
        return new CdPair(null, miniTuples);
    }

    @Override
    public void logInfo(Logger logger, String infoSize) {
        logger.info((Object)("[fast-crossjoin] (parallel)          configuration : " + CdStringUtils.formatForLogs((double)this.threadCount) + "/" + CdStringUtils.formatForLogs((double)this.maxPreCalculated) + "/" + CdStringUtils.formatForLogs((double)this.maxPreCalculatedTuples)));
        logger.info((Object)("[fast-crossjoin] (parallel)           combinations : " + CdStringUtils.formatForLogs((double)this.combinationCount)));
        logger.info((Object)("[fast-crossjoin] (parallel)         from iteration : " + CdStringUtils.formatForLogs((double)this.statsFromIteration)));
        logger.info((Object)("[fast-crossjoin] (parallel)        from prefetched : " + CdStringUtils.formatForLogs((double)this.statsFromPrefetched)));
        logger.info((Object)("[fast-crossjoin] (parallel)       count prefetched : " + CdStringUtils.formatForLogs((double)this.statsCountPrefetched)));
        logger.info((Object)("[fast-crossjoin] (parallel) count prefetched (all) : " + CdStringUtils.formatForLogs((double)this.statsCountPrefetchedAll)));
    }
}

