/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.cache;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.collection.olapiterator.cache.IOlapIteratorCache;
import crazydev.iccube.collection.olapiterator.cache.OlapIteratorCacheMaxSizeException;
import crazydev.iccube.collection.olapiterator.cache.OlapIteratorReadWriteCache;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import org.jetbrains.annotations.Nullable;

public class OlapCachingIterator<T>
extends OlapBaseIterator<T> {
    public static volatile int MAX_BUFFER_SIZE = 50000;
    @Nullable
    private final OlapTupleDimensionality tupleDimensionality;
    private final long fastEstimatedSize;
    private final boolean mightHaveCalcMember;
    @Nullable
    private IOlapIteratorCache<T> sharedIteratorCache;
    private int sharedIteratorCacheNextItemPos;
    @Nullable
    private OlapIterator<T> underlying;

    public OlapCachingIterator(OlapIterator<T> underlying) {
        this(underlying, MAX_BUFFER_SIZE);
    }

    protected OlapCachingIterator(OlapIterator<T> underlying, int maxCacheSize) {
        this.tupleDimensionality = underlying.getTupleDimensionality();
        this.fastEstimatedSize = underlying.fastEstimatedSize();
        this.mightHaveCalcMember = underlying.mightHaveCalcMember();
        this.sharedIteratorCache = new OlapIteratorReadWriteCache<T>(underlying, maxCacheSize);
    }

    protected OlapCachingIterator(OlapCachingIterator<T> other) {
        if (other.sharedIteratorCache != null) {
            this.sharedIteratorCache = other.sharedIteratorCache.asReadOnly();
            this.sharedIteratorCacheNextItemPos = 0;
            if (other.underlying != null) {
                throw new CdProgrammingException("internal error : inconsistent (other) iterator state");
            }
            this.underlying = null;
        } else {
            this.sharedIteratorCache = null;
            this.sharedIteratorCacheNextItemPos = -1;
            if (other.underlying == null) {
                throw new CdProgrammingException("internal error : inconsistent (other) iterator state");
            }
            this.underlying = other.underlying.newInstance();
        }
        this.tupleDimensionality = other.getTupleDimensionality();
        this.fastEstimatedSize = other.fastEstimatedSize();
        this.mightHaveCalcMember = other.mightHaveCalcMember();
    }

    public static <T> OlapCachingIterator<T> newInstanceNoLimit(OlapIterator<T> underlying) {
        return new OlapCachingIterator<T>(underlying, -1);
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleDimensionality;
    }

    @Override
    public long fastEstimatedSize() {
        return this.fastEstimatedSize;
    }

    @Override
    public boolean mightHaveCalcMember() {
        return this.mightHaveCalcMember;
    }

    public boolean hasSameUnderlyingCache(OlapCachingIterator<T> other) {
        return this.sharedIteratorCache == other.sharedIteratorCache;
    }

    @Override
    public boolean isMembersCrossjoin() {
        if (this.sharedIteratorCache != null) {
            return this.sharedIteratorCache.isCrossjoin();
        }
        if (this.underlying != null) {
            return this.underlying.isMembersCrossjoin();
        }
        throw new CdProgrammingException("internal error : inconsistent iterator state");
    }

    @Override
    public boolean isCacheUseless() {
        return true;
    }

    public boolean isCaching() {
        return this.sharedIteratorCache != null;
    }

    @Override
    public void reset() {
        if (this.sharedIteratorCache != null) {
            this.sharedIteratorCache = this.sharedIteratorCache.asReadOnly();
            this.sharedIteratorCacheNextItemPos = 0;
        } else if (this.underlying != null) {
            this.underlying.reset();
        } else {
            throw new CdProgrammingException("internal error : inconsistent iterator state");
        }
    }

    @Override
    protected T safeNext() {
        if (this.sharedIteratorCache != null) {
            return this.safeNextFromCache();
        }
        return this.safeNextFromUnderlying();
    }

    @Nullable
    private T safeNextFromCache() {
        try {
            T item = this.sharedIteratorCache.nextCachedItem(this.sharedIteratorCacheNextItemPos);
            if (item != null) {
                ++this.sharedIteratorCacheNextItemPos;
            }
            return item;
        }
        catch (OlapIteratorCacheMaxSizeException ex) {
            this.switchToNonCachingMode(this.sharedIteratorCacheNextItemPos);
            return this.safeNextFromUnderlying();
        }
    }

    private void switchToNonCachingMode(int pos) {
        IOlapIteratorCache<T> mySharedIteratorCache = this.sharedIteratorCache;
        if (mySharedIteratorCache == null) {
            throw new CdProgrammingException("internal error : missing shared iterator");
        }
        OlapIterator<T> myUnderlying = mySharedIteratorCache.newUnderlyingInstance();
        myUnderlying.reset();
        while (--pos > -1) {
            myUnderlying.next();
        }
        this.underlying = myUnderlying;
        this.sharedIteratorCache = null;
        this.sharedIteratorCacheNextItemPos = -1;
    }

    @Nullable
    private T safeNextFromUnderlying() {
        OlapIterator<T> myUnderlying = this.underlying;
        if (myUnderlying == null) {
            throw new CdProgrammingException("internal error : missing underlying iterator");
        }
        return myUnderlying.next();
    }

    protected void forcePutInCache() {
        if (this.sharedIteratorCache == null || this.sharedIteratorCache.isReadOnly()) {
            return;
        }
        this.reset();
        while (this.next() != null && this.sharedIteratorCache != null) {
        }
        if (this.sharedIteratorCache != null) {
            this.sharedIteratorCache = this.sharedIteratorCache.asReadOnly();
        }
    }

    @Override
    public OlapCachingIterator<T> newInstance() {
        return new OlapCachingIterator<T>(this);
    }
}

