/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorListIterator;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class OlapTupleSetListIterator<T extends OlapTuple>
extends OlapIteratorListIterator<T> {
    private final OlapTupleDimensionality tupleDimensionality;
    private final List<OlapTupleSet<T>> sets;

    OlapTupleSetListIterator(List<OlapTupleSet<T>> sets) {
        super(sets.size());
        OlapTupleSet<T> set;
        OlapIterator first;
        this.sets = sets;
        OlapTupleDimensionality tupleDimensionality = null;
        Iterator<OlapTupleSet<T>> iterator = sets.iterator();
        while (iterator.hasNext() && (tupleDimensionality = (first = (set = iterator.next()).getIterator(false)).getTupleDimensionality()) == null) {
        }
        this.tupleDimensionality = tupleDimensionality;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleDimensionality;
    }

    @Override
    public long fastEstimatedSize() {
        long size = 0L;
        for (OlapTupleSet<T> set : this.sets) {
            long setSize = set.fastEstimatedSize();
            if (setSize == -1L) {
                return -1L;
            }
            size += setSize;
        }
        return size;
    }

    @Override
    public boolean mightHaveCalcMember() {
        for (OlapTupleSet<T> set : this.sets) {
            if (!set.mightHaveCalcMember()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected OlapIterator<T> getIterator(int pos) {
        return this.sets.get(pos).getIterator(false);
    }

    @Override
    public int _sizeSlow() {
        int size = 0;
        for (int idx = 0; idx < this.sets.size(); ++idx) {
            OlapTupleSet<T> set = this.sets.get(idx);
            size += set._sizeSlow();
        }
        return size;
    }

    @Override
    public OlapTupleSetListIterator<T> newInstance() {
        return new OlapTupleSetListIterator<T>(this.sets);
    }
}

