/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorListIterator;
import crazydev.iccube.olap.entity.common.OlapMemberChildren;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import org.jetbrains.annotations.Nullable;

class OlapMultiChildrenRIterator
extends OlapIteratorListIterator<OlapMember> {
    private final OlapMemberChildren roots;

    OlapMultiChildrenRIterator(OlapMemberChildren roots) {
        super(roots.size());
        this.roots = roots;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.roots.getTupleDimensionality();
    }

    @Override
    public long fastEstimatedSize() {
        long count = 0L;
        for (int i = 0; i < this.roots.size(); ++i) {
            OlapMember member = this.roots.get(i);
            count += member.getDescendantsCount();
        }
        return count;
    }

    @Override
    public boolean isMembersCrossjoin() {
        return true;
    }

    @Override
    public boolean mightHaveCalcMember() {
        for (OlapMember root : this.roots.iterable()) {
            if (!root.isCalculated()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected OlapIterator<OlapMember> getIterator(int pos) {
        return this.roots.get(pos).getChildrenR(null, null, true);
    }

    public OlapMultiChildrenRIterator newInstance() {
        return new OlapMultiChildrenRIterator(this.roots);
    }
}

