/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class OlapFilterIterator<T>
extends OlapBaseIterator<T> {
    final OlapIterator<T> iterator;
    final IOlapIteratorFilter<? super T> filter;

    public OlapFilterIterator(OlapIterator<T> iterator, IOlapIteratorFilter<? super T> filter) {
        this.iterator = iterator;
        this.filter = filter;
    }

    @Override
    @Nullable
    public OlapIterator<T> fastCrossjoinForNonEmptyProcessing(OlapFastCrossjoinContext crossjoinContext) {
        OlapIterator<T> optimized = this.iterator.fastCrossjoinForNonEmptyProcessing(crossjoinContext);
        if (optimized == null) {
            return null;
        }
        return new OlapFilterIterator<T>(optimized, this.filter);
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.iterator.getTupleDimensionality();
    }

    @Override
    @Nullable
    public List<OlapMember> tryExtractMeasures(OlapHierarchy measureHierarchy) {
        return this.iterator.tryExtractMeasures(measureHierarchy);
    }

    @Override
    public long fastEstimatedSize() {
        return this.iterator.fastEstimatedSize();
    }

    @Override
    public boolean mightHaveCalcMember() {
        return this.iterator.mightHaveCalcMember();
    }

    @Override
    public boolean isMembersCrossjoin() {
        return this.iterator.isMembersCrossjoin() || super.isMembersCrossjoin();
    }

    @Override
    public OlapBaseIterator<T> decorateMemberCrossjoin(Function<OlapIterator<OlapMember>, OlapIterator<OlapMember>> t) {
        OlapBaseIterator<T> underlying = this.iterator.decorateMemberCrossjoin(t);
        return underlying == null ? null : new OlapFilterIterator<T>(underlying, this.filter);
    }

    @Override
    public void reset() {
        this.filter.reset();
        this.iterator.reset();
    }

    @Override
    protected T safeNext() {
        T item;
        while ((item = this.iterator.next()) != null && !this.filter.accept(item)) {
        }
        return item;
    }

    @Override
    public OlapIterator<T> newInstance() {
        return new OlapFilterIterator<T>(this.iterator.newInstance(), this.filter.newInstance());
    }

    public OlapIterator getUnderlyingIterator() {
        return this.iterator;
    }

    public OlapFilterIterator<T> withUnderlying(OlapIterator<T> iter) {
        return new OlapFilterIterator<T>(iter, this.filter);
    }

    public IOlapIteratorFilter<? super T> getFilter() {
        return this.filter;
    }

    @Override
    public void hackForNonEmptyX() {
        this.iterator.hackForNonEmptyX();
    }
}

