/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.OlapIterable;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapIteratorHelper;
import crazydev.iccube.collection.olapiterator.IOlapCombinationIterator;
import java.lang.reflect.Array;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapCombinationIterator<T>
implements IOlapCombinationIterator<T> {
    private final Class<T> clazz;
    private final OlapIterator<T>[] iterators;
    @Nullable
    private final List<Integer> iteratorsPOS;
    private final T[] combination;
    @Nullable
    private final int[] Si;
    private boolean first;

    public OlapCombinationIterator(Class<T> clazz, OlapIterable<T>[] iterables) {
        this(clazz, iterables, null);
    }

    public OlapCombinationIterator(Class<T> clazz, OlapIterable<T>[] iterables, @Nullable int[] Si) {
        this.iterators = new OlapIterator[iterables.length];
        for (int idx = 0; idx < this.iterators.length; ++idx) {
            this.iterators[idx] = iterables[idx].getIterator(idx > 0);
        }
        this.iteratorsPOS = null;
        this.clazz = clazz;
        this.combination = (Object[])Array.newInstance(clazz, this.iterators.length);
        this.Si = Si;
    }

    public OlapCombinationIterator(Class<T> clazz, List<OlapIterator<T>> iterators, @Nullable List<Integer> iteratorsPOS) {
        this.iterators = new OlapIterator[iterators.size()];
        for (int idx = 0; idx < this.iterators.length; ++idx) {
            this.iterators[idx] = iterators.get(idx);
        }
        this.iteratorsPOS = iteratorsPOS;
        this.clazz = clazz;
        this.combination = (Object[])Array.newInstance(clazz, this.iterators.length);
        this.Si = new int[iterators.size()];
    }

    @Override
    public int axisCount() {
        return this.iterators.length;
    }

    @Override
    public List<T> extractAxis(int axis) {
        if (axis < this.iterators.length) {
            return OlapIteratorHelper.extractTuples(this.iterators[axis]);
        }
        throw new RuntimeException("internal error: inconsistent usage of cell iterator (" + axis + ")");
    }

    @Override
    public boolean isCombination() {
        return true;
    }

    @Override
    public void reset() {
        for (int idx = 0; idx < this.iterators.length - 1; ++idx) {
            OlapIterator<T> iterator = this.iterators[idx];
            iterator.reset();
            T c = iterator.next();
            this.combination[this.iteratorPOS((int)idx)] = c;
            if (this.Si == null) continue;
            this.Si[this.iteratorPOS((int)idx)] = c == null ? -1 : 0;
        }
        this.iterators[this.iterators.length - 1].reset();
        this.combination[this.iteratorPOS((int)(this.iterators.length - 1))] = null;
        if (this.Si != null) {
            this.Si[this.iteratorPOS((int)(this.iterators.length - 1))] = -1;
        }
        this.first = true;
    }

    @Override
    @Nullable
    public T[] next() {
        int current = this.iterators.length - 1;
        while (current >= 0) {
            OlapIterator<T> iterator = this.iterators[current];
            T t = iterator.next();
            if (t != null) {
                this.combination[this.iteratorPOS((int)current)] = t;
                if (this.Si == null) break;
                int n = this.iteratorPOS(current);
                this.Si[n] = this.Si[n] + 1;
                break;
            }
            if (current == 0) {
                --current;
                continue;
            }
            iterator.reset();
            T c = iterator.next();
            this.combination[this.iteratorPOS((int)current)] = c;
            if (this.Si != null) {
                int n = this.Si[this.iteratorPOS((int)current)] = c == null ? -1 : 0;
            }
            if (this.first && c == null) break;
            --current;
        }
        this.first = false;
        return current < 0 ? null : this.combination;
    }

    @Override
    public int[] Si() {
        return this.Si;
    }

    private int iteratorPOS(int pos) {
        if (this.iteratorsPOS == null) {
            return pos;
        }
        return this.iteratorsPOS.get(pos);
    }
}

