/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection;

import crazydev.iccube.collection.OlapSortedNumericTuples;
import crazydev.iccube.collection.OlapVTuple;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.Comparator;

public abstract class OlapSumBoundedSortedVTuples
extends OlapSortedNumericTuples {
    private final double maxSum;
    private double sum;

    public OlapSumBoundedSortedVTuples(OlapErrorLocation locationRange, String functionName, int internalTupleListCount, Comparator<OlapVTuple<OlapNumericEntity>> comparator, double maxSum, boolean excludeEmpty) {
        super(locationRange, functionName, internalTupleListCount, comparator, excludeEmpty);
        this.maxSum = maxSum;
    }

    @Override
    public void add(OlapTuple tuple, OlapNumericEntity value, int pos) {
        double newSum = this.sum + value.value();
        if (newSum <= this.maxSum) {
            OlapVTuple<OlapNumericEntity> valuedTuple = new OlapVTuple<OlapNumericEntity>(tuple, value, pos);
            this.valuedTuples.add(valuedTuple);
            this.sum = newSum;
            this.assertHardLimit();
            return;
        }
        this.addX(tuple, value, pos);
    }

    private void addX(OlapTuple tuple, OlapNumericEntity value, int pos) {
        OlapVTuple<OlapNumericEntity> valuedTuple = new OlapVTuple<OlapNumericEntity>(tuple, value, pos);
        this.valuedTuples.add(valuedTuple);
        this.sum += value.value();
        while (!this.valuedTuples.isEmpty()) {
            double newSum;
            OlapVTuple last = (OlapVTuple)this.valuedTuples.last();
            if (((OlapNumericEntity)last.value).value() == 0.0 || !((newSum = this.sum - ((OlapNumericEntity)last.value).value()) >= this.maxSum) || this.valuedTuples.size() <= 1) break;
            this.valuedTuples.removeLastItem();
            this.sum = newSum;
        }
        this.assertHardLimit();
    }

    @Override
    public OlapTupleSet<OlapTuple> asSet() {
        return super.asSet();
    }
}

