/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection;

import crazydev.common.collection.CdPaginatedList;
import crazydev.iccube.collection.IOlapIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapSetFormulaEvaluationContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.List;

public abstract class OlapIteratorHelper {
    public static <T> List<T> extractTuples(IOlapIterator<T> iterator) {
        T tuple;
        CdPaginatedList tuples = new CdPaginatedList();
        iterator.reset();
        while ((tuple = iterator.next()) != null) {
            tuples.add(tuple);
        }
        return tuples;
    }

    public static <T> List<T> extractTuplesForTests(IOlapIterator<T> iterator) {
        T tuple;
        CdPaginatedList tuples = new CdPaginatedList();
        iterator.reset();
        while ((tuple = iterator.next()) != null) {
            tuples.add(tuple);
        }
        return tuples;
    }

    public static <T> List<T> extractTuplesForMeasures(IOlapIterator<T> iterator) {
        T tuple;
        int limit = 10000000;
        CdPaginatedList tuples = new CdPaginatedList();
        int count = 0;
        iterator.reset();
        while ((tuple = iterator.next()) != null) {
            if (++count > 10000000) {
                String error = "unexpected usage of extractTuplesForMeasures() : limit reached [10000000]";
                OlapLoggers.MDX_EVALUATION.error((Object)"unexpected usage of extractTuplesForMeasures() : limit reached [10000000]");
                throw new RuntimeException("unexpected usage of extractTuplesForMeasures() : limit reached [10000000]");
            }
            tuples.add(tuple);
        }
        return tuples;
    }

    public static <T> List<T> extractTuplesForSetMaterialization(OlapSetFormulaEvaluationContext context, IOlapIterator<T> iterator, String setName, int limit) {
        T tuple;
        CdPaginatedList tuples = new CdPaginatedList();
        int count = 0;
        iterator.reset();
        while ((tuple = iterator.next()) != null) {
            if (++count > limit) {
                OlapLoggers.MDX_EVALUATION.error((Object)("[mdx] set( " + setName + " ) materialization limit reached [" + limit + "]"));
                throw new OlapEvaluationException(context, OlapErrorCode.SET_MATERIALIZATION_LIMIT, new Serializable[]{setName, Integer.valueOf(limit)});
            }
            tuples.add(tuple);
        }
        return tuples;
    }

    public static <T> List<T> extractTuplesForAxisTidyMaterialization(OlapSelectStatementExecutionContext context, IOlapIterator<T> iterator, int axis, boolean withNonEmpty, int limit) {
        T tuple;
        CdPaginatedList tuples = new CdPaginatedList();
        int count = 0;
        iterator.reset();
        while ((tuple = iterator.next()) != null) {
            if (++count > limit) {
                OlapLoggers.MDX_EVALUATION.error((Object)("[mdx] axis(" + axis + "): " + (withNonEmpty ? " NON EMPTY " : "") + "materialization limit reached [" + limit + "]"));
                if (!withNonEmpty) {
                    throw new OlapEvaluationException(context, OlapErrorCode.TIDY_AXIS_MATERIALIZATION_LIMIT, Integer.valueOf(axis), Integer.valueOf(limit));
                }
                throw new OlapEvaluationException(context, OlapErrorCode.TIDY_AXIS_MATERIALIZATION_LIMIT_NE, Integer.valueOf(axis), Integer.valueOf(limit));
            }
            tuples.add(tuple);
        }
        return tuples;
    }
}

