/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection;

import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;

public class OlapDistinctHierarchySet {
    private final OlapBitSet hierarchies;
    private int size;

    public OlapDistinctHierarchySet() {
        this.hierarchies = new OlapBitSet();
        this.size = 0;
    }

    public OlapDistinctHierarchySet(OlapDistinctHierarchySet other) {
        this.hierarchies = new OlapBitSet(other.hierarchies);
        this.size = other.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void add(OlapHierarchy item) {
        this.hierarchies.set(item.getTupleDimensionalityIndex());
        ++this.size;
    }

    public void addAll(OlapDistinctHierarchySet other) {
        int idx = other.hierarchies.nextSetBit(0);
        while (idx >= 0) {
            this.hierarchies.set(idx);
            ++this.size;
            idx = other.hierarchies.nextSetBit(idx + 1);
        }
    }

    public boolean contains(OlapHierarchy item) {
        return this.hierarchies.get(item.getTupleDimensionalityIndex());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapDistinctHierarchySet that = (OlapDistinctHierarchySet)o;
        return this.hierarchies.equals(that.hierarchies);
    }

    public int hashCode() {
        return this.hierarchies.hashCode();
    }

    public String toString() {
        return this.hierarchies.toString();
    }
}

