/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.shared.schema.S_FactSubCube;
import crazydev.iccube.cluster.shared.schema.S_MemberDef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.tor.OlapBitmapTor;
import java.util.List;

public class S_VisualTotalsDef {
    private S_FactSubCube subCube;
    private S_TupleDimensionalityDef dimensionality;

    public S_VisualTotalsDef(OlapTupleDimensionality dimensionality, List<List<OlapMember>> visualTotals) {
        this.dimensionality = new S_TupleDimensionalityDef(dimensionality);
        this.subCube = new S_FactSubCube(S_FactSubCube.Operation.AND);
        this.fillSubCube(visualTotals);
    }

    private void fillSubCube(List<List<OlapMember>> visualTotals) {
        for (List<OlapMember> tuples : visualTotals) {
            S_FactSubCube susuCube = new S_FactSubCube(S_FactSubCube.Operation.OR);
            for (OlapMember member : tuples) {
                susuCube.addMember(new S_MemberDef(member));
            }
            this.subCube.addSubCube(susuCube);
        }
    }

    public void addToTor(N_MdxRequestContext context, IFactsBitmapAndTor andtor, N_FactPage factPage) {
        OlapBitmapTor tor = this.subCube.createBitmapTor(context, factPage, null);
        if (tor.isEmpty()) {
            return;
        }
        OlapFactsBitmap bitmap = tor.solve();
        andtor.add(bitmap);
    }

    public S_TupleDimensionalityDef getDimensionality() {
        return this.dimensionality;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S_VisualTotalsDef that = (S_VisualTotalsDef)o;
        if (!this.dimensionality.equals(that.dimensionality)) {
            return false;
        }
        return this.subCube.equals(that.subCube);
    }

    public int hashCode() {
        int result = this.subCube.hashCode();
        result = 31 * result + this.dimensionality.hashCode();
        return result;
    }
}

