/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactory;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorNode;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFCaseNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class S_NonEmptyBehaviorOperator {
    private S_NonEmptyBehaviorOperator() {
    }

    public static S_NonEmptyBehavior tuple(S_NonEmptyBehaviorFactoryContext context, OlapTuple tuple) throws OlapNonEmptyBehaviorException {
        if (tuple.isKO()) {
            OlapLoggers.MDX_EVALUATION.warn((Object)("[mdx] inconsistent non-empty-behavior: invalid tuple [" + String.valueOf(tuple) + "]"));
            throw new OlapNonEmptyBehaviorException("inconsistent non-empty-behavior: invalid tuple [" + String.valueOf(tuple) + "]");
        }
        int count = tuple.getMemberCount();
        if (count == 0) {
            return S_NonEmptyBehavior.transparent();
        }
        ArrayList<S_NonEmptyBehavior> behaviors = new ArrayList<S_NonEmptyBehavior>();
        for (int ii = 0; ii < count; ++ii) {
            OlapMember member = tuple.getMember(ii);
            S_NonEmptyBehavior behavior = S_NonEmptyBehaviorFactory.createForMember(context, member);
            behaviors.add(behavior);
        }
        S_NonEmptyBehavior res = S_NonEmptyBehaviorOperator.merge(behaviors);
        return res;
    }

    public static S_NonEmptyBehavior members(S_NonEmptyBehaviorFactoryContext context, List<OlapMember> members) throws OlapNonEmptyBehaviorException {
        ArrayList<S_NonEmptyBehavior> behaviors = new ArrayList<S_NonEmptyBehavior>();
        int count = members.size();
        if (count == 0) {
            return S_NonEmptyBehavior.transparent();
        }
        for (int ii = 0; ii < count; ++ii) {
            OlapMember member = members.get(ii);
            S_NonEmptyBehavior behavior = S_NonEmptyBehaviorFactory.createForMember(context, member);
            behaviors.add(behavior);
        }
        S_NonEmptyBehavior res = S_NonEmptyBehaviorOperator.merge(behaviors);
        return res;
    }

    public static S_NonEmptyBehavior plus(S_NonEmptyBehaviorFactoryContext context, GFNode left, GFNode right) throws OlapNonEmptyBehaviorException {
        S_NonEmptyBehavior left_ = left.nonEmptyBehavior(context);
        S_NonEmptyBehavior right_ = right.nonEmptyBehavior(context);
        S_NonEmptyBehavior res = S_NonEmptyBehaviorOperator.merge(Arrays.asList(left_, right_));
        return res;
    }

    public static S_NonEmptyBehavior minus(S_NonEmptyBehaviorFactoryContext context, GFNode left, GFNode right) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehaviorOperator.plus(context, left, right);
    }

    public static S_NonEmptyBehavior multiply(S_NonEmptyBehaviorFactoryContext context, GFNode left, GFNode right) throws OlapNonEmptyBehaviorException {
        S_NonEmptyBehavior left_ = left.nonEmptyBehavior(context);
        S_NonEmptyBehavior right_ = right.nonEmptyBehavior(context);
        if (left_.isZero() || right_.isZero()) {
            return S_NonEmptyBehavior.zero();
        }
        if (left_.isOne()) {
            return right_;
        }
        if (right_.isOne()) {
            return left_;
        }
        return S_NonEmptyBehaviorOperator.merge(Arrays.asList(left_, right_));
    }

    public static S_NonEmptyBehavior divide(S_NonEmptyBehaviorFactoryContext context, GFNode left, GFNode right) throws OlapNonEmptyBehaviorException {
        S_NonEmptyBehavior left_ = left.nonEmptyBehavior(context);
        return left_;
    }

    public static S_NonEmptyBehavior divide(S_NonEmptyBehaviorFactoryContext context, GFNode left, GFNode right, @Nullable GFNode alternate) throws OlapNonEmptyBehaviorException {
        if (alternate == null) {
            return S_NonEmptyBehaviorOperator.divide(context, left, right);
        }
        ArrayList<S_NonEmptyBehavior> behaviors = new ArrayList<S_NonEmptyBehavior>();
        behaviors.add(left.nonEmptyBehavior(context));
        behaviors.add(alternate.nonEmptyBehavior(context));
        return S_NonEmptyBehaviorOperator.merge(behaviors);
    }

    public static S_NonEmptyBehavior coalesceEmpty(S_NonEmptyBehaviorFactoryContext context, GFNode[] args) throws OlapNonEmptyBehaviorException {
        ArrayList<S_NonEmptyBehavior> behaviors = new ArrayList<S_NonEmptyBehavior>();
        for (int ii = 0; ii < args.length; ++ii) {
            GFNode arg = args[ii];
            if (arg == null) continue;
            S_NonEmptyBehavior behavior = arg.nonEmptyBehavior(context);
            behaviors.add(behavior);
        }
        return S_NonEmptyBehaviorOperator.merge(behaviors);
    }

    public static S_NonEmptyBehavior addN(S_NonEmptyBehaviorFactoryContext context, GFNode[] args) throws OlapNonEmptyBehaviorException {
        ArrayList<S_NonEmptyBehavior> behaviors = new ArrayList<S_NonEmptyBehavior>();
        for (int ii = 0; ii < args.length; ++ii) {
            GFNode arg = args[ii];
            S_NonEmptyBehavior behavior = arg.nonEmptyBehavior(context);
            if (behavior.isZero()) {
                return S_NonEmptyBehavior.zero();
            }
            behaviors.add(behavior);
        }
        return S_NonEmptyBehaviorOperator.merge(behaviors);
    }

    public static S_NonEmptyBehavior minusN(S_NonEmptyBehaviorFactoryContext context, GFNode[] args) throws OlapNonEmptyBehaviorException {
        ArrayList<S_NonEmptyBehavior> behaviors = new ArrayList<S_NonEmptyBehavior>();
        for (int ii = 0; ii < args.length; ++ii) {
            GFNode arg = args[ii];
            S_NonEmptyBehavior behavior = arg.nonEmptyBehavior(context);
            behaviors.add(behavior);
        }
        return S_NonEmptyBehaviorOperator.merge(behaviors);
    }

    public static S_NonEmptyBehavior divN(S_NonEmptyBehaviorFactoryContext context, GFNode[] args) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehaviorOperator.minusN(context, args);
    }

    public static S_NonEmptyBehavior percN(S_NonEmptyBehaviorFactoryContext context, GFNode[] args) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehaviorOperator.divN(context, args);
    }

    public static S_NonEmptyBehavior range(S_NonEmptyBehaviorFactoryContext context, GFNode left, GFNode right) throws OlapNonEmptyBehaviorException {
        S_NonEmptyBehavior left_ = left.nonEmptyBehavior(context);
        S_NonEmptyBehavior right_ = right.nonEmptyBehavior(context);
        if (left_.isZero() && right_.isZero()) {
            return S_NonEmptyBehavior.zero();
        }
        if (left_.isOne() || right_.isOne()) {
            return S_NonEmptyBehavior.one();
        }
        OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] non-empty-behavior calculation error for range operator");
        throw new OlapNonEmptyBehaviorException("non-empty-behavior calculation error for range operator");
    }

    public static S_NonEmptyBehavior iif(S_NonEmptyBehaviorFactoryContext context, GFNode condition, GFNode then, GFNode otherwise) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehaviorOperator.plus(context, then, otherwise);
    }

    public static S_NonEmptyBehavior searchCase(S_NonEmptyBehaviorFactoryContext context, GFCaseNode.WhenThen[] whenThens, @Nullable GFNode caseElse) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehaviorOperator.conditionalCase(context, whenThens, caseElse);
    }

    public static S_NonEmptyBehavior switchCase(S_NonEmptyBehaviorFactoryContext context, GFNode caseInput, GFCaseNode.WhenThen[] whenThens, @Nullable GFNode caseElse) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehaviorOperator.conditionalCase(context, whenThens, caseElse);
    }

    private static S_NonEmptyBehavior conditionalCase(S_NonEmptyBehaviorFactoryContext context, GFCaseNode.WhenThen[] whenThens, @Nullable GFNode caseElse) throws OlapNonEmptyBehaviorException {
        ArrayList<S_NonEmptyBehavior> behaviors = new ArrayList<S_NonEmptyBehavior>();
        for (int ii = 0; ii < whenThens.length; ++ii) {
            S_NonEmptyBehavior behavior = whenThens[ii].then.nonEmptyBehavior(context);
            behaviors.add(behavior);
        }
        if (caseElse != null) {
            S_NonEmptyBehavior behavior = caseElse.nonEmptyBehavior(context);
            behaviors.add(behavior);
        }
        return S_NonEmptyBehaviorOperator.merge(behaviors);
    }

    public static S_NonEmptyBehavior merge(List<S_NonEmptyBehavior> behaviors) {
        int transparentCount = 0;
        int zeroCount = 0;
        for (int ii = 0; ii < behaviors.size(); ++ii) {
            S_NonEmptyBehavior behavior = behaviors.get(ii);
            if (behavior.isOne()) {
                return S_NonEmptyBehavior.one();
            }
            if (behavior.isZero()) {
                ++zeroCount;
            }
            if (!behavior.isTransparent()) continue;
            ++transparentCount;
        }
        if (zeroCount == behaviors.size()) {
            return S_NonEmptyBehavior.zero();
        }
        if (transparentCount == behaviors.size()) {
            return S_NonEmptyBehavior.transparent();
        }
        ArrayList<S_NonEmptyBehaviorNode> measureGroups = new ArrayList<S_NonEmptyBehaviorNode>();
        for (S_NonEmptyBehavior behavior : behaviors) {
            if (behavior.isZero() || behavior.isTransparent()) continue;
            measureGroups.addAll(behavior.getNodes());
        }
        return S_NonEmptyBehaviorFactory.createForMeasureGroupRefs(measureGroups);
    }

    public static S_NonEmptyBehavior merge(S_NonEmptyBehavior ne1, S_NonEmptyBehavior ne2) {
        if (ne1 == null) {
            return ne2;
        }
        if (ne2 == null) {
            return ne1;
        }
        return S_NonEmptyBehaviorOperator.merge(Arrays.asList(ne1, ne2));
    }
}

