/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.common.utils.CdMutableBoolean;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorSetupMode;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionality;
import crazydev.iccube.collection.OlapStack;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class S_NonEmptyBehaviorFactoryContext {
    private final OlapStack<OlapCalculatedMember> walkedCalcMembers = new OlapStack();
    private final OlapTupleDimensionality wholeDimensionality;
    private final OlapMdxStatementExecutionContext sContext;

    public S_NonEmptyBehaviorFactoryContext(OlapMdxStatementExecutionContext sContext, OlapTupleDimensionality crossjoinDimensionality, @Nullable S_TupleDimensionality subSelectDimensionality, @Nullable OlapTupleDimensionality slicerDimensionality, @Nullable OlapTupleDimensionality defaultsNonAllDimensionality) {
        this.sContext = sContext;
        OlapTupleDimensionality dim = crossjoinDimensionality;
        dim = subSelectDimensionality != null ? dim.union(subSelectDimensionality) : dim;
        dim = slicerDimensionality != null ? dim.union(slicerDimensionality) : dim;
        this.wholeDimensionality = dim = defaultsNonAllDimensionality != null ? dim.union(defaultsNonAllDimensionality) : dim;
    }

    public OlapEngineRequestContext getRequestContext() {
        return this.sContext.getRequestContext();
    }

    public OlapMdxStatementExecutionContext getStatementContext() {
        if (this.sContext instanceof OlapSelectStatementExecutionContext) {
            return ((OlapSelectStatementExecutionContext)this.sContext).copyForNonEmptyBehaviorSetup();
        }
        throw new RuntimeException("internal error: unexpected statement context : " + this.sContext.getUsage());
    }

    public boolean isAuto() {
        OlapProperties props = this.sContext.getRequestProperties();
        S_NonEmptyBehaviorSetupMode mode = props.getNonEmptyBehaviorSetupMode();
        return mode == S_NonEmptyBehaviorSetupMode.AUTO;
    }

    public OlapTupleDimensionality getWholeDimensionality() {
        return this.wholeDimensionality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<OlapCalculatedMember> pushCalcMember(OlapCalculatedMember member) {
        CdMutableBoolean hasCycle = new CdMutableBoolean();
        ArrayList<OlapCalculatedMember> cycle = new ArrayList<OlapCalculatedMember>();
        OlapStack<OlapCalculatedMember> olapStack = this.walkedCalcMembers;
        synchronized (olapStack) {
            this.walkedCalcMembers.push(member);
            this.walkedCalcMembers.process(frame -> {
                if (cycle.contains(frame)) {
                    cycle.add((OlapCalculatedMember)frame);
                    hasCycle.value = true;
                    return false;
                }
                cycle.add((OlapCalculatedMember)frame);
                return true;
            });
        }
        if (hasCycle.value) {
            return cycle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popCalcMember() {
        OlapStack<OlapCalculatedMember> olapStack = this.walkedCalcMembers;
        synchronized (olapStack) {
            this.walkedCalcMembers.pop();
        }
    }
}

