/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorNode;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorOperator;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFNonEmptyBehaviorEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class S_NonEmptyBehaviorFactory {
    public static S_NonEmptyBehavior createForCellProperties(List<S_NonEmptyBehaviorNode> nodes) {
        return S_NonEmptyBehaviorFactory.createForMeasureGroupRefs(nodes);
    }

    public static S_NonEmptyBehavior createForMeasureGroupRefs(List<S_NonEmptyBehaviorNode> nodes) {
        if (nodes.isEmpty()) {
            throw new RuntimeException("internal error: inconsistent non-empty-behavior (missing measure groups)");
        }
        HashMap<OlapFactMeasureGroupBaseManager, Set> factsMerged = new HashMap<OlapFactMeasureGroupBaseManager, Set>();
        for (S_NonEmptyBehaviorNode node : nodes) {
            OlapFactMeasureGroupBaseManager facts = node.getMeasureGroupRef();
            List<OlapMeasureMember> measures = node.getMeasures();
            Set factsMeasures = factsMerged.computeIfAbsent(facts, olapFactMeasureGroupBaseManager -> new HashSet());
            if (measures == null) continue;
            factsMeasures.addAll(measures);
        }
        ArrayList<S_NonEmptyBehaviorNode> mergedNodes = new ArrayList<S_NonEmptyBehaviorNode>();
        for (Map.Entry entry : factsMerged.entrySet()) {
            OlapFactMeasureGroupBaseManager facts = (OlapFactMeasureGroupBaseManager)entry.getKey();
            Set measures = (Set)entry.getValue();
            if (!measures.isEmpty()) {
                mergedNodes.add(new S_NonEmptyBehaviorNode(facts, new ArrayList<OlapMeasureMember>(measures)));
                continue;
            }
            mergedNodes.add(new S_NonEmptyBehaviorNode(facts));
        }
        return new S_NonEmptyBehavior(mergedNodes);
    }

    public static S_NonEmptyBehavior createForMembers(S_NonEmptyBehaviorFactoryContext context, List<OlapMember> members) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehaviorOperator.members(context, members);
    }

    public static S_NonEmptyBehavior createForMember(S_NonEmptyBehaviorFactoryContext context, OlapMember member) throws OlapNonEmptyBehaviorException {
        if (member instanceof OlapCalculatedMember) {
            return S_NonEmptyBehaviorFactory.createForCalculatedMeasure(context, (OlapCalculatedMember)member);
        }
        if (member instanceof OlapMeasureMember) {
            return S_NonEmptyBehaviorFactory.createForMeasure((OlapMeasureMember)member);
        }
        OlapTupleDimensionality wholeDimensionality = context.getWholeDimensionality();
        if (wholeDimensionality.isIn(member.getHierarchy())) {
            return S_NonEmptyBehavior.one();
        }
        return S_NonEmptyBehavior.transparent();
    }

    public static S_NonEmptyBehavior createForMeasure(OlapMeasureMember member) throws OlapNonEmptyBehaviorException {
        OlapFactMeasureGroupBaseManager measureGroupRef = member.getMeasureGroupForNonEmptyBehavior();
        if (measureGroupRef == null) {
            OlapLoggers.MDX_EVALUATION.warn((Object)("[mdx] missing measure group for measure [" + member.getNameX() + "]"));
            throw new OlapNonEmptyBehaviorException("missing measure group for measure [" + member.getNameX() + "]");
        }
        return new S_NonEmptyBehavior(new S_NonEmptyBehaviorNode(measureGroupRef, member));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static S_NonEmptyBehavior createForCalculatedMeasure(S_NonEmptyBehaviorFactoryContext context, OlapCalculatedMember member) throws OlapNonEmptyBehaviorException {
        S_NonEmptyBehavior nonEmptyBehavior;
        S_NonEmptyBehavior nonEmptyBehaviorD = member.getDefinedNonEmptyBehavior();
        if (nonEmptyBehaviorD != null) {
            nonEmptyBehavior = nonEmptyBehaviorD;
        } else {
            if (!context.isAuto()) {
                OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] non empty behavior calculation not specified for calc. member (icCube.nonEmptyBehaviorSetupMode=MANUAL) : ONE");
                return S_NonEmptyBehavior.one();
            }
            List<OlapCalculatedMember> cycle = context.pushCalcMember(member);
            if (cycle != null) {
                OlapLoggers.MDX_EVALUATION.warn((Object)("[mdx] non empty behavior calculation error (cycle) for the calc. member : " + member.getUniqueName(OlapNameContext.DEFAULT_VALUES) + " cycle : " + S_NonEmptyBehaviorFactory.createCycleError(cycle)));
                throw new OlapNonEmptyBehaviorException("non empty behavior calculation error (cycle) for calc. member");
            }
            try {
                nonEmptyBehavior = member.isDefinedAtSelectStatementLevel() ? S_NonEmptyBehaviorFactory.createForCalculatedMeasureSelectLevel(context, member) : S_NonEmptyBehaviorFactory.createForCalculatedMeasureSchemaLevel(context, member);
                if (nonEmptyBehavior.isTransparent()) {
                    OlapLoggers.MDX_EVALUATION.warn((Object)("[mdx] $transparent$ non empty behavior not supported for calc. member : " + member.getUniqueName(OlapNameContext.DEFAULT_VALUES)));
                    throw new OlapNonEmptyBehaviorException("$transparent$ non empty behavior not supported for calc. member");
                }
            }
            finally {
                context.popCalcMember();
            }
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] NON EMPTY BEHAVIOR setup for calc. member : " + member.getUniqueName(OlapNameContext.DEFAULT_VALUES) + " : " + String.valueOf(nonEmptyBehavior.asMdxResult())));
        return nonEmptyBehavior;
    }

    private static S_NonEmptyBehavior createForCalculatedMeasureSchemaLevel(S_NonEmptyBehaviorFactoryContext context, OlapCalculatedMember member) throws OlapNonEmptyBehaviorException {
        if (member.isDefinedAtSelectStatementLevel()) {
            throw new RuntimeException("internal error: SELECT calc. member : " + member.getUniqueName(OlapNameContext.DEFAULT_VALUES));
        }
        OlapEngineRequestContext requestContext = context.getRequestContext();
        OlapMdxStatementExecutionContext statementContext = context.getStatementContext();
        if (!(statementContext instanceof OlapSelectStatementExecutionContext)) {
            OlapLoggers.MDX_EVALUATION.warn((Object)("[mdx] non empty behavior not supported for calc. member : " + member.getUniqueName(OlapNameContext.DEFAULT_VALUES) + " unexpected statement context: " + statementContext.getUsage()));
            throw new OlapNonEmptyBehaviorException("non empty behavior not supported for calc. member");
        }
        OlapSelectStatementExecutionContext selectContext = (OlapSelectStatementExecutionContext)statementContext;
        OlapSchema schema = selectContext.getSchema();
        OlapCube cube = selectContext.getCube();
        OlapNonEmptyBehaviorStatementExecutionContext sContext = new OlapNonEmptyBehaviorStatementExecutionContext(requestContext, requestContext.getOlapEngineProperties(), schema, cube);
        return S_NonEmptyBehaviorFactory.doCreateNonEmptyBehavior(context, sContext, member);
    }

    private static S_NonEmptyBehavior createForCalculatedMeasureSelectLevel(S_NonEmptyBehaviorFactoryContext context, OlapCalculatedMember member) throws OlapNonEmptyBehaviorException {
        if (!member.isDefinedAtSelectStatementLevel()) {
            throw new RuntimeException("internal error: SCHEMA calc. member : " + member.getUniqueName(OlapNameContext.DEFAULT_VALUES));
        }
        OlapMdxStatementExecutionContext sContext = context.getStatementContext();
        return S_NonEmptyBehaviorFactory.doCreateNonEmptyBehavior(context, sContext, member);
    }

    private static S_NonEmptyBehavior doCreateNonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context, OlapMdxStatementExecutionContext sContext, OlapCalculatedMember member) throws OlapNonEmptyBehaviorException {
        try {
            OlapNonEmptyBehaviorEvaluationContext eContext = new OlapNonEmptyBehaviorEvaluationContext(sContext);
            GFNonEmptyBehaviorEvalContext pContext = new GFNonEmptyBehaviorEvalContext(eContext);
            OlapInstr formula = member.getFormula();
            OlapPreparedInstr formulaInstr = formula.prepare(pContext);
            GFNode formulaNode = formulaInstr.buildGFTree(new GFNodeBuildContext(false), true);
            return formulaNode.nonEmptyBehavior(context);
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] could not create the non empty behavior", (Throwable)ex);
            throw new OlapNonEmptyBehaviorException(ex.getMessage());
        }
    }

    private static String createCycleError(List<OlapCalculatedMember> cycle) {
        OlapNameContext nameContext = OlapNameContext.DEFAULT_VALUES;
        StringBuilder sb = new StringBuilder();
        for (OlapCalculatedMember member : cycle) {
            sb.append(" -> ").append(member.getUniqueName(nameContext));
        }
        sb.append(")");
        return sb.toString();
    }
}

