/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.cluster.shared.schema.S_MeasureGroupDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorNode;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class S_NonEmptyBehavior {
    private static final S_NonEmptyBehavior TRANSPARENT = new S_NonEmptyBehavior(){

        @Override
        public boolean isTransparent() {
            return true;
        }

        @Override
        public String toString() {
            return "(transparent)";
        }
    };
    private static final S_NonEmptyBehavior ONE = new S_NonEmptyBehavior(){

        @Override
        public boolean isOne() {
            return true;
        }

        @Override
        public String toString() {
            return "(one)";
        }
    };
    private static final S_NonEmptyBehavior ZERO = new S_NonEmptyBehavior(){

        @Override
        public boolean isZero() {
            return true;
        }

        @Override
        public String toString() {
            return "(zero)";
        }
    };
    private final List<S_NonEmptyBehaviorNode> nodes;

    S_NonEmptyBehavior() {
        this(Collections.emptyList());
    }

    S_NonEmptyBehavior(S_NonEmptyBehaviorNode node) {
        this(Arrays.asList(node));
    }

    S_NonEmptyBehavior(List<S_NonEmptyBehaviorNode> nodes) {
        this.nodes = nodes;
    }

    public static S_NonEmptyBehavior transparent() {
        return TRANSPARENT;
    }

    public static S_NonEmptyBehavior one() {
        return ONE;
    }

    public static S_NonEmptyBehavior zero() {
        return ZERO;
    }

    public boolean isTransparent() {
        return false;
    }

    public boolean isOne() {
        return false;
    }

    public boolean isZero() {
        return false;
    }

    public boolean hasAggregationWithRollupHierarchy(@Nullable Logger logger, @Nullable String prefix) {
        for (S_NonEmptyBehaviorNode node : this.nodes) {
            if (!node.hasAggregationWithRollupHierarchy(logger, prefix)) continue;
            return true;
        }
        return false;
    }

    public List<S_NonEmptyBehaviorNode> getNodes() {
        return this.nodes;
    }

    public S_NonEmptyBehaviorNode getNode(S_MeasureGroupDef measureGroupDef) {
        for (S_NonEmptyBehaviorNode node : this.nodes) {
            S_MeasureGroupRef ref = node.getMeasureGroupRef().getClusterRef();
            if (!ref.equals(measureGroupDef.getRef())) continue;
            return node;
        }
        throw new RuntimeException("internal error: missing measure group [" + measureGroupDef.getMeasureGroupName() + "]");
    }

    public OlapStringEntity asMdxResult() {
        if (this.isTransparent()) {
            return new OlapStringEntity("$transparent$");
        }
        if (this.isOne()) {
            return new OlapStringEntity("$one$");
        }
        if (this.isZero()) {
            return new OlapStringEntity("$zero$");
        }
        StringBuilder sb = new StringBuilder();
        for (S_NonEmptyBehaviorNode nonEmptyBehavior : this.nodes) {
            if (!sb.isEmpty()) {
                sb.append(",");
            }
            OlapFactMeasureGroupBaseManager measureGroupRef = nonEmptyBehavior.getMeasureGroupRef();
            sb.append(measureGroupRef.getMeasureGroupName());
            List<OlapMeasureMember> measures = nonEmptyBehavior.getMeasures();
            if (measures == null || measures.isEmpty()) continue;
            sb.append(S_NonEmptyBehavior.asMdxResult(measures));
        }
        OlapStringEntity res = new OlapStringEntity(sb.toString());
        return res;
    }

    private static String asMdxResult(List<OlapMeasureMember> measures) {
        StringBuilder sb = new StringBuilder("(");
        for (int ii = 0; ii < measures.size(); ++ii) {
            OlapMeasureMember measure = measures.get(ii);
            if (ii > 0) {
                sb.append(",");
            }
            sb.append(measure.getNameX());
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int ii = 0; ii < this.nodes.size(); ++ii) {
            S_NonEmptyBehaviorNode nonEmptyBehavior = this.nodes.get(ii);
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(nonEmptyBehavior);
        }
        sb.append(")");
        return sb.toString();
    }
}

