/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.cluster.shared.schema.S_FactMemberInfo;
import crazydev.iccube.cluster.shared.schema.S_MemberDefType;
import crazydev.iccube.olap.entity.member.OlapMember;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class S_MemberDef {
    public final String __debug_NAME;
    public final String __debug_NAME_FACT;
    private final int hierIdx;
    private final int factHierIdx;
    private final int factMemberIdx;
    private final S_MemberDefType factType;
    @Nullable
    private final S_FactMemberInfo info;

    public S_MemberDef(OlapMember member) {
        this.hierIdx = member.getHierarchy().getTupleDimensionalityIndex();
        OlapMember fMember = member.getFactIndexingMember();
        this.factHierIdx = fMember.getHierarchy().getTupleDimensionalityIndex();
        this.factMemberIdx = fMember.getUniqueHierarchyMemberIndex();
        this.factType = S_MemberDefType.memberType(fMember);
        this.info = S_FactMemberInfo.setup(this.factType, fMember);
        this.__debug_NAME = "";
        this.__debug_NAME_FACT = "";
    }

    public int getHierIdx() {
        return this.hierIdx;
    }

    public int getFactHierIdx() {
        return this.factHierIdx;
    }

    public int getFactMemberIdx() {
        return this.factMemberIdx;
    }

    public S_MemberDefType getFactType() {
        return this.factType;
    }

    @Nullable
    public S_FactMemberInfo getInfo() {
        return this.info;
    }

    public boolean isIn(List<S_MemberDef> members) {
        for (int i = 0; i < members.size(); ++i) {
            if (this.getFactHierIdx() != members.get(i).getFactHierIdx()) continue;
            return true;
        }
        return false;
    }

    public boolean isForFactsSubCube() {
        return this.factType.isForFactsSubCube();
    }

    public boolean isStandard() {
        return this.factType.isStandard();
    }

    public boolean isCategory() {
        return this.factType.isCategory();
    }

    public boolean isAll() {
        return this.factType.isAll();
    }

    public boolean isMeasure() {
        return this.factType.isMeasure();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S_MemberDef that = (S_MemberDef)o;
        if (this.hierIdx != that.hierIdx) {
            return false;
        }
        if (this.factHierIdx != that.factHierIdx) {
            return false;
        }
        if (this.factMemberIdx != that.factMemberIdx) {
            return false;
        }
        return this.factType == that.factType;
    }

    public int hashCode() {
        int result = this.hierIdx;
        result = 31 * result + this.factHierIdx;
        result = 31 * result + this.factMemberIdx;
        result = 31 * result + this.factType.hashCode();
        return result;
    }

    public String toString() {
        return this.__debug_NAME_FACT;
    }
}

