/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.cluster.shared.schema.S_HierarchyDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.enums.OlapPartitioningType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class S_MeasureGroupDef {
    private final S_MeasureGroupRef ref;
    private final Set<S_HierarchyDef> baseHierarchiesWithReverseIndex;
    private final String cubeName;
    private final String factsName;
    private final String measureGroupName;
    private final OlapPartitioningType partitionType;
    private final List<S_MeasureDef> measures = new ArrayList<S_MeasureDef>();

    public S_MeasureGroupDef(S_MeasureGroupRef ref, String cubeName, String factsName, String measureGroupName, OlapPartitioningType partitionType, Set<S_HierarchyDef> baseHierarchiesWithReverseIndex) {
        this.ref = ref;
        this.baseHierarchiesWithReverseIndex = baseHierarchiesWithReverseIndex;
        this.ref.setReferenced(this);
        this.cubeName = cubeName;
        this.factsName = factsName;
        this.measureGroupName = measureGroupName;
        this.partitionType = partitionType;
    }

    public S_MeasureGroupRef getRef() {
        return this.ref;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getName() {
        return this.factsName;
    }

    public String getMeasureGroupName() {
        return this.measureGroupName;
    }

    public OlapPartitioningType getPartitionType() {
        return this.partitionType;
    }

    public void addMeasure(S_MeasureDef measure) {
        this.measures.add(measure);
    }

    public List<S_MeasureDef> getMeasures() {
        return this.measures;
    }

    public S_MeasureDef getMeasure(String measureName) {
        S_MeasureDef measure = this.lookupMeasure(measureName);
        if (measure != null) {
            return measure;
        }
        throw new RuntimeException("internal error: [" + this.getName() + "] missing measure [" + measureName + "]");
    }

    @Nullable
    public S_MeasureDef lookupMeasure(String name) {
        for (S_MeasureDef measure : this.measures) {
            if (!measure.getName().equals(name)) continue;
            return measure;
        }
        return null;
    }

    public S_MeasureDef resolveMeasure(S_MeasureRef measureRef) {
        S_MeasureDef measureDef = (S_MeasureDef)measureRef.getReferenced();
        if (measureDef == null) {
            throw new RuntimeException("internal error: [" + this.getName() + "] missing measure [" + String.valueOf(measureRef) + "]");
        }
        return measureDef;
    }

    public Set<S_HierarchyDef> getBaseHierarchiesWithReverseIndex() {
        return this.baseHierarchiesWithReverseIndex;
    }
}

