/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureIndex;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import org.jetbrains.annotations.Nullable;

public class S_MeasureDef {
    private final OlapAggregationType hierarchyAggregationType;
    private final S_MeasureRef ref;
    private final String name;
    private final S_MeasureIndex index;
    private final OlapBuilderInputType cubeDataType;
    private final boolean emptyIsZeroAsDouble;
    private final IOlapBuilderMeasureDef measureDef;

    public S_MeasureDef(IOlapBuilderMeasureDef measureDef, S_MeasureGroupDef measureGroup, S_MeasureIndex index, OlapBuilderInputType cubeDataType, OlapAggregationType hierarchyAggregationType, boolean emptyIsZeroAsDouble) {
        this.measureDef = measureDef;
        this.name = measureDef.getName();
        this.ref = new S_MeasureRef(this.name);
        this.ref.setReferenced(this);
        this.index = index;
        this.cubeDataType = cubeDataType;
        this.hierarchyAggregationType = hierarchyAggregationType;
        this.emptyIsZeroAsDouble = emptyIsZeroAsDouble;
    }

    public S_MeasureDef(String name, S_MeasureIndex index, OlapBuilderInputType dbType, OlapAggregationType hierarchyAggregationType, boolean emptyIsZeroAsDouble) {
        this.hierarchyAggregationType = hierarchyAggregationType;
        this.emptyIsZeroAsDouble = emptyIsZeroAsDouble;
        this.name = name;
        this.ref = new S_MeasureRef(name);
        this.ref.setReferenced(this);
        this.index = index;
        this.cubeDataType = dbType;
        this.measureDef = null;
    }

    public S_MeasureRef getRef() {
        return this.ref;
    }

    public String getName() {
        return this.name;
    }

    public S_MeasureIndex getIndex() {
        return this.index;
    }

    public boolean isAlias() {
        return this.index.isAlias();
    }

    public int getFactsColumnIndex() {
        return this.index.getFactsColumnIndex();
    }

    public OlapBuilderInputType getCubeDataType() {
        return this.cubeDataType;
    }

    @Nullable
    public OlapBuilderColumnDecorationType getCubeDataTypeDecoration() {
        return this.measureDef.getFactDataTypeDecoration();
    }

    public OlapAggregationType getHierarchyAggregationType() {
        return this.hierarchyAggregationType;
    }

    public boolean isEmptyIsZero() {
        return this.measureDef.emptyIsZero();
    }

    public OlapScalarEntity toEmptyZeroIfNeeded(OlapScalarEntity scalar) {
        return this.isEmptyIsZero() && scalar.isMdxNull() ? OlapNumericEntity.asZeroForEmpty(this.emptyIsZeroAsDouble) : scalar;
    }

    @Nullable
    public String getFactsColumnName() {
        return this.measureDef == null ? null : this.measureDef.getColumn().getName();
    }
}

