/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class S_FactsMeasureColumns {
    private final IOlapBuilderBaseFactsDef factsDef;
    private final Map<IOlapBuilderMeasureDef, S_MeasureColumn> columns;

    private S_FactsMeasureColumns(IOlapBuilderBaseFactsDef factsDef, Map<IOlapBuilderMeasureDef, S_MeasureColumn> columns) {
        this.factsDef = factsDef;
        this.columns = columns;
    }

    public static S_FactsMeasureColumns create(IOlapBuilderBaseFactsDef factsDef) {
        HashMap<IOlapBuilderMeasureDef, S_MeasureColumn> measureColumnInfos = new HashMap<IOlapBuilderMeasureDef, S_MeasureColumn>();
        HashMap<IOlapBuilderDataColumnDef, List> columnInfos = new HashMap<IOlapBuilderDataColumnDef, List>();
        List<IOlapBuilderMeasureDef> measureDefs = factsDef.getMeasures();
        int measureDefsSize = measureDefs.size();
        for (int measureDefIndex = 0; measureDefIndex < measureDefsSize; ++measureDefIndex) {
            IOlapBuilderMeasureDef measureDef = measureDefs.get(measureDefIndex);
            IOlapBuilderDataColumnDef column = measureDef.getColumn();
            List infos = columnInfos.computeIfAbsent(column, def -> new ArrayList());
            S_MeasureColumn columnInfo = S_FactsMeasureColumns.getColumnInfo(infos, measureDef);
            if (columnInfo == null) {
                columnInfo = new S_MeasureColumn(measureDef, measureDefIndex);
                infos.add(columnInfo);
            }
            measureColumnInfos.put(measureDef, columnInfo);
        }
        return new S_FactsMeasureColumns(factsDef, measureColumnInfos);
    }

    public S_MeasureColumn getColumn(IOlapBuilderMeasureDef measureDef) {
        return this.columns.get(measureDef);
    }

    @Nullable
    private static S_MeasureColumn getColumnInfo(List<S_MeasureColumn> infos, IOlapBuilderMeasureDef measureDef) {
        for (S_MeasureColumn info : infos) {
            if (!info.isOkForMeasure(measureDef)) continue;
            return info;
        }
        return null;
    }
}

