/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdArrays;
import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.facts.N_FactBitmapContainer;
import crazydev.iccube.cluster.shared.schema.S_BitSetTupleDimensionality;
import crazydev.iccube.cluster.shared.schema.S_FactMemberInfo;
import crazydev.iccube.cluster.shared.schema.S_MemberDef;
import crazydev.iccube.cluster.shared.schema.S_MemberDefType;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionality;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapFactory;
import crazydev.iccube.olap.index.bitmap.tor.OlapBitmapTor;
import crazydev.iccube.olap.index.bitmap.tor.OlapBitmapTorAnd;
import crazydev.iccube.olap.index.bitmap.tor.OlapBitmapTorNot;
import crazydev.iccube.olap.index.bitmap.tor.OlapBitmapTorOr;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class S_FactSubCube {
    private final Operation op;
    private final ArrayList<S_FactSubCube> subCubes;
    private final ArrayList<S_MemberDef> members;
    private S_BitSetTupleDimensionality tupleDimensionality;

    protected S_FactSubCube(S_FactSubCube or) {
        this.op = or.op;
        this.subCubes = or.subCubes;
        this.members = or.members;
        this.tupleDimensionality = or.tupleDimensionality;
    }

    public S_FactSubCube(Operation op) {
        this.op = op;
        this.subCubes = new ArrayList();
        this.members = new ArrayList();
    }

    public S_FactSubCube(Operation op, S_MemberDef ... members) {
        this.op = op;
        this.subCubes = new ArrayList();
        this.members = new ArrayList();
        if (members != null) {
            S_MemberDef member;
            for (int ii = 0; ii < members.length && (member = members[ii]).isForFactsSubCube(); ++ii) {
                this.members.add(member);
            }
        }
    }

    public S_FactSubCube(Operation op, S_FactSubCube ... subCubes) {
        this.op = op;
        this.subCubes = new ArrayList();
        this.members = new ArrayList();
        if (subCubes != null) {
            for (int ii = 0; ii < subCubes.length; ++ii) {
                S_FactSubCube subCube = subCubes[ii];
                this.subCubes.add(subCube);
            }
        }
    }

    public S_FactSubCube(Operation op, ArrayList<S_FactSubCube> subCubes, ArrayList<S_MemberDef> members) {
        this.op = op;
        this.subCubes = subCubes;
        this.members = members;
    }

    @Nullable
    public S_FactSubCube asNonEmpty() {
        ArrayList<S_FactSubCube> asNonEmptySubCubes = new ArrayList<S_FactSubCube>();
        for (S_FactSubCube subCube : this.subCubes) {
            S_FactSubCube asNonEmpty = subCube.asNonEmpty();
            if (asNonEmpty == null) continue;
            asNonEmptySubCubes.add(asNonEmpty);
        }
        if (asNonEmptySubCubes.isEmpty() && this.members.isEmpty()) {
            return null;
        }
        return new S_FactSubCube(this.op, asNonEmptySubCubes, this.members);
    }

    private static OlapBitmapTor.Builder createBitmapTor(Operation op, int numberOfRows) {
        return switch (op.ordinal()) {
            case 0 -> new OlapBitmapTorAnd(numberOfRows);
            case 1 -> new OlapBitmapTorOr(numberOfRows);
            case 2 -> new OlapBitmapTorNot(numberOfRows);
            default -> throw new RuntimeException("internal error: unexpected operation [" + String.valueOf((Object)op) + "]");
        };
    }

    public void addMember(S_MemberDef member) {
        if (!member.isForFactsSubCube()) {
            return;
        }
        this.members.add(member);
    }

    public void addSubCube(S_FactSubCube subCube) {
        if (this.op == subCube.op) {
            this.members.addAll(subCube.members);
            this.subCubes.addAll(subCube.subCubes);
        } else if (subCube.op != Operation.NOT && subCube.subCubes.isEmpty() && subCube.members.size() == 1) {
            this.members.add(subCube.members.get(0));
        } else if (subCube.op != Operation.NOT && subCube.members.isEmpty() && subCube.subCubes.size() == 1) {
            this.subCubes.add(subCube.subCubes.get(0));
        } else {
            this.subCubes.add(subCube);
        }
    }

    public OlapBitmapTor createBitmapTor(@Nullable N_MdxRequestContext context, N_FactBitmapContainer bitmapContainer, @Nullable S_TupleDimensionality filterTupleDim) {
        int numberOfRows = bitmapContainer.getNumberOfRows();
        OlapBitmapTor.Builder builder = S_FactSubCube.createBitmapTor(this.op, numberOfRows);
        for (int mm = 0; !(mm >= this.members.size() || mm % 1000 == 0 && context != null && context.isCancelling()); ++mm) {
            S_MemberDef memberDef = this.members.get(mm);
            if (!memberDef.isForFactsSubCube() || filterTupleDim != null && filterTupleDim.isIn(memberDef)) continue;
            S_MemberDefType type = memberDef.getFactType();
            if (type == S_MemberDefType.ALL) {
                builder.add(OlapFactsBitmapFactory.facts_createBitmapAllOnes(numberOfRows));
                continue;
            }
            if (type == S_MemberDefType.CATEGORY) {
                if (context == null) {
                    throw new RuntimeException("internal error: missing context for category [" + String.valueOf(memberDef) + "] (hint: category in permissions)");
                }
                S_FactMemberInfo info = memberDef.getInfo();
                if (info == null) {
                    throw new RuntimeException("internal error: missing info for category [" + String.valueOf(memberDef) + "]");
                }
                OlapHierarchyScope scope = info.scope;
                long cacheId = info.cacheId;
                OlapFactsBitmap cBitmap = context.getOrCreateCategoryBitmap(bitmapContainer, scope, memberDef.getFactHierIdx(), memberDef.getFactMemberIdx(), cacheId);
                if (cBitmap == null) continue;
                builder.add(cBitmap);
                continue;
            }
            OlapFactsBitmap bitmap = bitmapContainer.getForRead(memberDef);
            if (bitmap == null) continue;
            builder.add(bitmap);
        }
        if (context != null && context.isCancelling()) {
            return S_FactSubCube.createBitmapTor(this.op, numberOfRows).asTor();
        }
        for (int i = 0; i < this.subCubes.size(); ++i) {
            S_FactSubCube subCube = this.subCubes.get(i);
            builder.add(subCube.createBitmapTor(context, bitmapContainer, filterTupleDim));
        }
        return builder.asTor();
    }

    public S_TupleDimensionality getTupleDimensionality() {
        if (this.tupleDimensionality == null) {
            this.tupleDimensionality = this.createTupleDimensionality();
        }
        return this.tupleDimensionality;
    }

    private synchronized S_BitSetTupleDimensionality createTupleDimensionality() {
        S_BitSetTupleDimensionality bitSet = new S_BitSetTupleDimensionality();
        this.forEachMember((CdAction<S_MemberDef>)((CdAction)clusterMemberDef -> bitSet.set(clusterMemberDef.getHierIdx())));
        return bitSet;
    }

    private void forEachMember(CdAction<S_MemberDef> action) {
        int i;
        for (i = 0; i < this.subCubes.size(); ++i) {
            S_FactSubCube clusterFactSubCube = this.subCubes.get(i);
            clusterFactSubCube.forEachMember(action);
        }
        for (i = 0; i < this.members.size(); ++i) {
            action.apply((Object)this.members.get(i));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S_FactSubCube that = (S_FactSubCube)o;
        if (this.op != that.op) {
            return false;
        }
        if (!CdArrays.equals(this.members, that.members)) {
            return false;
        }
        return CdArrays.equals(this.subCubes, that.subCubes);
    }

    public int hashCode() {
        int result = this.op.hashCode();
        result = 31 * result + this.subCubes.hashCode();
        result = 31 * result + this.members.hashCode();
        return result;
    }

    public static enum Operation {
        AND,
        OR,
        NOT;

    }
}

