/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.builder.type.DistinctCountOptimType;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class S_CubeDef {
    private final S_SchemaDef schemaDef;
    private final S_CubeRef ref;
    private final String name;
    private final Map<S_MeasureGroupRef, S_MeasureGroupDef> measureGroups = new HashMap<S_MeasureGroupRef, S_MeasureGroupDef>();

    public S_CubeDef(S_SchemaDef schemaDef, S_CubeRef ref, String name) {
        this.schemaDef = schemaDef;
        this.ref = ref;
        this.ref.setReferenced(this);
        this.name = name;
    }

    public S_CubeRef getRef() {
        return this.ref;
    }

    public String getName() {
        return this.name;
    }

    public String getSchemaName() {
        return this.schemaDef.getName();
    }

    public S_SchemaDef getSchemaDef() {
        return this.schemaDef;
    }

    public boolean isIncrLoadActive() {
        return this.schemaDef.isIncrLoadActive();
    }

    public DistinctCountOptimType getDistinctCountOptimType() {
        return this.schemaDef.getDistinctCountOptimType();
    }

    public Collection<S_MeasureGroupDef> getAllMeasureGroups() {
        return this.measureGroups.values();
    }

    public void addMeasureGroup(S_MeasureGroupDef measureGroup) {
        this.measureGroups.put(measureGroup.getRef(), measureGroup);
    }

    public S_MeasureGroupDef getMeasureGroup(String measureGroupName) {
        for (S_MeasureGroupDef group : this.measureGroups.values()) {
            if (!group.getName().equals(measureGroupName)) continue;
            return group;
        }
        throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] [" + this.getName() + "] missing measure group [" + measureGroupName + "]");
    }

    public S_MeasureDef getMeasure(String measureName) {
        for (S_MeasureGroupDef groupDef : this.measureGroups.values()) {
            S_MeasureDef measure = groupDef.lookupMeasure(measureName);
            if (measure == null) continue;
            return measure;
        }
        throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] [" + this.getName() + "] missing measure [" + measureName + "]");
    }

    public S_MeasureGroupDef getMeasureGroup(S_MeasureGroupRef ref) {
        S_MeasureGroupDef group = this.lookupMeasureGroup(ref);
        if (group != null) {
            return group;
        }
        throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] [" + this.getName() + "] missing measure [" + String.valueOf(ref) + "]");
    }

    @Nullable
    public S_MeasureGroupDef lookupMeasureGroup(S_MeasureGroupRef ref) {
        Object referenced = ref.getReferenced();
        if (referenced != null) {
            return (S_MeasureGroupDef)referenced;
        }
        S_MeasureGroupDef group = this.measureGroups.get(ref);
        if (group != null) {
            return group;
        }
        return null;
    }
}

