/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.backup.file;

import crazydev.iccube.cluster.shared.backup.file.S_BackupMultiFileOutputStream;
import crazydev.iccube.cluster.shared.backup.file.S_BackupSingleFileOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class S_BackupFileOutputStream
extends OutputStream {
    protected File file;
    protected FileOutputStream stream;
    protected long sizeB;

    public S_BackupFileOutputStream(File file) throws IOException {
        this.file = file;
        this.stream = new FileOutputStream(file);
        this.sizeB = 0L;
    }

    public static S_BackupFileOutputStream create(File file, long maxSizeB) throws IOException {
        if (maxSizeB == -1L) {
            return new S_BackupSingleFileOutputStream(file);
        }
        return new S_BackupMultiFileOutputStream(file, maxSizeB);
    }

    public long getSizeB() {
        return this.sizeB;
    }

    @Override
    public void write(int b) throws IOException {
        this.stream.write(b);
        ++this.sizeB;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
        this.sizeB += (long)len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    public void sync() throws IOException {
        this.stream.flush();
        this.stream.getFD().sync();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

