/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.backup.file;

import crazydev.iccube.cluster.shared.backup.file.S_BackupFileOutputStreamHelper;
import crazydev.iccube.cluster.shared.backup.file.S_BackupMultiFileInputStream;
import crazydev.iccube.cluster.shared.backup.file.S_BackupSingleFileInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class S_BackupFileInputStream
extends InputStream {
    protected File file;
    protected FileInputStream stream;
    private long sizeB;

    public S_BackupFileInputStream(File file) throws IOException {
        this.file = file;
        this.stream = new FileInputStream(file);
        this.sizeB = 0L;
    }

    public static S_BackupFileInputStream create(File file) throws IOException {
        String newFileName = S_BackupFileOutputStreamHelper.newFileName(file.getName(), 1);
        File newFile = new File(file.getParentFile(), newFileName);
        if (newFile.exists()) {
            return new S_BackupMultiFileInputStream(file);
        }
        return new S_BackupSingleFileInputStream(file);
    }

    public long getSizeB() {
        return this.sizeB;
    }

    @Override
    public int read() throws IOException {
        int val = this.stream.read();
        if (val != -1) {
            ++this.sizeB;
        }
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int val = this.stream.read(b, off, len);
        if (val != -1) {
            this.sizeB += (long)val;
        }
        return val;
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

