/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.backup;

import crazydev.common.collection.CdCPair;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.cluster.shared.backup.file.S_BackupFileOutputStream;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.commons.io.IOUtils;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class S_BackupOutputStream
extends OutputStream {
    private final boolean debug = false;
    private final ByteOrder byteOrder;
    private final File file;
    private final S_BackupFileOutputStream fOut;
    private final DataOutputStream out;
    private boolean compressing;
    private long startMS;
    private long sizeB;

    public S_BackupOutputStream(OlapEngineBackupConfiguration configuration, File file) throws IOException {
        this(ByteOrder.nativeOrder(), configuration, file);
    }

    public S_BackupOutputStream(ByteOrder byteOrder, OlapEngineBackupConfiguration configuration, File file) throws IOException {
        this.byteOrder = byteOrder;
        this.file = file;
        this.fOut = S_BackupFileOutputStream.create(file, configuration.getMaxFileSizeB());
        this.compressing = configuration.isCompressing();
        DataOutputStream header = new DataOutputStream(this.fOut);
        header.writeInt(0);
        header.writeInt(byteOrder == ByteOrder.LITTLE_ENDIAN ? 0 : 1);
        header.writeInt(this.compressing ? 1 : 0);
        header.flush();
        if (this.compressing) {
            LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
            int blockSize = configuration.getCompressionBlockSizeB();
            this.out = new DataOutputStream((OutputStream)new LZ4BlockOutputStream((OutputStream)this.fOut, blockSize, compressor));
            OlapLoggers.BACKUP_X.debug((Object)("[backup] writing [LZ4] [" + blockSize + "] " + file.getName()));
        } else {
            int bufferSize = configuration.getOutBufferSizeB();
            this.out = new DataOutputStream(new BufferedOutputStream(this.fOut, bufferSize));
            OlapLoggers.BACKUP_X.debug((Object)("[backup] writing [no compression] [" + bufferSize + "] " + file.getName()));
        }
        this.startMS = System.currentTimeMillis();
        this.sizeB = 0L;
    }

    public boolean isDebug() {
        return false;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public void write(int value) throws IOException {
        this.writeByte(value);
    }

    @Override
    public void write(byte[] values) throws IOException {
        this.writeBytes(values);
    }

    @Override
    public void write(byte[] values, int off, int len) throws IOException {
        this.writeBytes(values, off, len);
    }

    public void writeByte(int value) throws IOException {
        this.out.write(value);
        ++this.sizeB;
    }

    public void writeBytes(byte[] values) throws IOException {
        this.writeBytes(values, 0, values.length);
    }

    public void writeBytes(byte[] values, int offset, int len) throws IOException {
        this.out.write(values, offset, len);
        this.sizeB += (long)len;
    }

    public void writeBytes(ByteBuffer values, int len) throws IOException {
        int bufferLength;
        if (len <= 0) {
            return;
        }
        byte[] buffer = new byte[4096];
        int bytesToWrite = bufferLength = buffer.length;
        if (len < bufferLength) {
            bytesToWrite = len;
        }
        int totalWritten = 0;
        while (bytesToWrite > 0) {
            values.get(buffer, 0, bytesToWrite);
            this.out.write(buffer, 0, bytesToWrite);
            bytesToWrite = Math.min(len - (totalWritten += bytesToWrite), bufferLength);
        }
        if (totalWritten != len) {
            throw new IOException("could not write [" + len + "] bytes: actual count [" + totalWritten + "]");
        }
        this.sizeB += (long)len;
    }

    public void writeUTF8(String value) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeInt(bytes.length);
        this.writeBytes(bytes);
    }

    public void writeShorts(short[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            this.out.writeShort(values[ii]);
        }
        this.sizeB += (long)(values.length * 2);
    }

    public void writeChar(char value) throws IOException {
        this.out.writeChar(value);
        this.sizeB += 2L;
    }

    public void writeInt(int value) throws IOException {
        this.out.writeInt(value);
        this.sizeB += 4L;
    }

    public void writeLong(long value) throws IOException {
        this.out.writeLong(value);
        this.sizeB += 8L;
    }

    public void writeInts(int[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            this.out.writeInt(values[ii]);
        }
        this.sizeB += (long)(values.length * 4);
    }

    public void writeLongs(long[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            this.out.writeLong(values[ii]);
        }
        this.sizeB += (long)(values.length * 8);
    }

    public void writeFloats(float[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            this.out.writeFloat(values[ii]);
        }
        this.sizeB += (long)(values.length * 4);
    }

    public void writeDoubles(double[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            this.out.writeDouble(values[ii]);
        }
        this.sizeB += (long)(values.length * 8);
    }

    public void writeComparables(Comparable[] values) throws IOException {
        int len;
        if (values.length == 0) {
            return;
        }
        Comparable value0 = values[0];
        if (!(value0 instanceof CdCPair)) {
            throw new RuntimeException("internal error: inconsistent comparable list usage : " + (value0 != null ? value0.getClass().getName() : "<null>"));
        }
        this.out.writeInt(0);
        for (len = 0; len < values.length && values[len] != null; ++len) {
        }
        this.out.writeInt(len);
        this.writePairs(values, len, true);
        this.writePairs(values, len, false);
    }

    private void writePairs(Comparable[] pairs, int len, boolean fst) throws IOException {
        CdCPair pair0 = (CdCPair)pairs[0];
        Comparable value0 = pair0.value(fst);
        if (value0 instanceof LocalDateTime) {
            this.writePairs_LocalDateTimes(pairs, len, fst);
        } else if (value0 instanceof LocalDate) {
            this.writePairs_LocalDates(pairs, len, fst);
        } else if (value0 instanceof Double) {
            this.writePairs_Doubles(pairs, len, fst);
        } else if (value0 instanceof Float) {
            this.writePairs_Floats(pairs, len, fst);
        } else if (value0 instanceof Long) {
            this.writePairs_Longs(pairs, len, fst);
        } else if (value0 instanceof Integer) {
            this.writePairs_Integers(pairs, len, fst);
        } else if (value0 instanceof Short) {
            this.writePairs_Shorts(pairs, len, fst);
        } else {
            throw new RuntimeException("internal error: inconsistent comparable list usage (item) : " + (value0 != null ? value0.getClass().getName() : "<null>"));
        }
    }

    private void writePairs_LocalDateTimes(Comparable[] pairs, int len, boolean fst) throws IOException {
        this.out.writeInt(1);
        for (int ii = 0; ii < len; ++ii) {
            Comparable value = ((CdCPair)pairs[ii]).value(fst);
            LocalDateTime tValue = (LocalDateTime)value;
            this.out.writeLong(CdJodaTimeUtil.toDefaultChronologyMillis((LocalDateTime)tValue));
        }
        this.sizeB += (long)(len * 8);
    }

    private void writePairs_LocalDates(Comparable[] pairs, int len, boolean fst) throws IOException {
        this.out.writeInt(2);
        for (int ii = 0; ii < len; ++ii) {
            Comparable value = ((CdCPair)pairs[ii]).value(fst);
            LocalDate tValue = (LocalDate)value;
            this.out.writeInt(CdJodaTimeUtil.toDefaultChronologyDays((LocalDate)tValue));
        }
        this.sizeB += (long)(len * 4);
    }

    private void writePairs_Doubles(Comparable[] pairs, int len, boolean fst) throws IOException {
        this.out.writeInt(3);
        for (int ii = 0; ii < len; ++ii) {
            Comparable value = ((CdCPair)pairs[ii]).value(fst);
            Double tValue = (Double)value;
            this.out.writeDouble(tValue);
        }
        this.sizeB += (long)(len * 8);
    }

    private void writePairs_Floats(Comparable[] pairs, int len, boolean fst) throws IOException {
        this.out.writeInt(4);
        for (int ii = 0; ii < len; ++ii) {
            Comparable value = ((CdCPair)pairs[ii]).value(fst);
            Float tValue = (Float)value;
            this.out.writeFloat(tValue.floatValue());
        }
        this.sizeB += (long)(len * 4);
    }

    private void writePairs_Longs(Comparable[] pairs, int len, boolean fst) throws IOException {
        this.out.writeInt(5);
        for (int ii = 0; ii < len; ++ii) {
            Comparable value = ((CdCPair)pairs[ii]).value(fst);
            Long tValue = (Long)value;
            this.out.writeLong(tValue);
        }
        this.sizeB += (long)(len * 8);
    }

    private void writePairs_Integers(Comparable[] pairs, int len, boolean fst) throws IOException {
        this.out.writeInt(6);
        for (int ii = 0; ii < len; ++ii) {
            Comparable value = ((CdCPair)pairs[ii]).value(fst);
            Integer tValue = (Integer)value;
            this.out.writeInt(tValue);
        }
        this.sizeB += (long)(len * 4);
    }

    private void writePairs_Shorts(Comparable[] pairs, int len, boolean fst) throws IOException {
        this.out.writeInt(7);
        for (int ii = 0; ii < len; ++ii) {
            Comparable value = ((CdCPair)pairs[ii]).value(fst);
            Short tValue = (Short)value;
            this.out.writeShort(tValue.shortValue());
        }
        this.sizeB += (long)(len * 2);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public void sync() throws IOException {
        OlapLoggers.BACKUP_X.debug((Object)("[backup] starting fsync() [" + this.file.getName() + "]"));
        this.out.flush();
        this.fOut.sync();
        if (this.sizeB == 0L) {
            OlapLoggers.BACKUP_X.debug((Object)("[backup] completed fsync() [" + this.file.getName() + "] [no data written]"));
            return;
        }
        long elapsedMS = System.currentTimeMillis() - this.startMS;
        if (elapsedMS == 0L) {
            OlapLoggers.BACKUP_X.debug((Object)("[backup] completed fsync() [" + this.file.getName() + "] [" + CdSizeUtils.format((double)this.sizeB) + "]"));
            return;
        }
        double rawSizeM = (double)this.sizeB / 1024.0 / 1024.0;
        int rawSpeedMS = (int)(rawSizeM / (double)elapsedMS * 1000.0);
        if (!this.compressing) {
            OlapLoggers.BACKUP_X.debug((Object)("[backup] completed fsync() [" + this.file.getName() + "] [" + CdTimeUtils.formatMillis((long)elapsedMS) + "] [" + CdSizeUtils.format((double)this.sizeB) + "] [" + rawSpeedMS + "MB/s]"));
            return;
        }
        double compressedSizeB = this.fOut.getSizeB();
        double compressionRatio = (double)this.sizeB / compressedSizeB;
        double compressedSizeM = compressedSizeB / 1024.0 / 1024.0;
        int compressedSpeedMS = (int)(compressedSizeM / (double)elapsedMS * 1000.0);
        OlapLoggers.BACKUP_X.debug((Object)("[backup] completed fsync() [" + this.file.getName() + "] [" + CdTimeUtils.formatMillis((long)elapsedMS) + "] [" + CdSizeUtils.format((double)this.sizeB) + "] [" + rawSpeedMS + "MB/s] [compressed:" + CdSizeUtils.format((double)compressedSizeB) + "] [compression-ratio:" + String.format("%.1f", compressionRatio) + "] [compressed-speed:" + compressedSpeedMS + "MB/s]"));
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void closeQuietly() {
        IOUtils.closeQuietly((OutputStream)this.out);
    }
}

