/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.backup;

import crazydev.common.collection.CdCPair;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.cluster.shared.backup.file.S_BackupFileInputStream;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import net.jpountz.lz4.LZ4BlockInputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class S_BackupInputStream
extends InputStream {
    private final ByteOrder byteOrder;
    private final boolean nativeByteOrder;
    private final File file;
    private final DataInputStream in;
    private final int magic;
    private final boolean compressing;
    private S_BackupFileInputStream fIn;
    private long startMS;
    private long sizeB;
    @Nullable
    private Integer lookAhead;

    public S_BackupInputStream(OlapEngineBackupConfiguration configuration, File file) throws IOException {
        this.file = file;
        this.fIn = S_BackupFileInputStream.create(file);
        DataInputStream header = new DataInputStream(this.fIn);
        this.magic = header.readInt();
        this.byteOrder = header.readInt() == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        this.nativeByteOrder = ByteOrder.nativeOrder() == this.byteOrder;
        boolean bl = this.compressing = header.readInt() != 0;
        if (this.compressing) {
            this.in = new DataInputStream((InputStream)new LZ4BlockInputStream((InputStream)this.fIn));
            OlapLoggers.BACKUP_X.debug((Object)("[backup] reading [LZ4] " + file.getName()));
        } else {
            int bufferSize = configuration.getInBufferSizeB();
            this.in = new DataInputStream(new BufferedInputStream(this.fIn, bufferSize));
            OlapLoggers.BACKUP_X.debug((Object)("[backup] reading [no compression] " + file.getName()));
        }
        this.startMS = System.currentTimeMillis();
        this.sizeB = 0L;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public int read() throws IOException {
        int value = this.in.read();
        ++this.sizeB;
        return value;
    }

    @Override
    public int read(byte[] values) throws IOException {
        this.readBytes(values);
        return values.length;
    }

    @Override
    public int read(byte[] values, int off, int len) throws IOException {
        this.readBytes(values, off, len);
        return len;
    }

    public void readBytes(byte[] values) throws IOException {
        this.readBytes(values, 0, values.length);
    }

    public void readBytes(byte[] values, int off, int len) throws IOException {
        int bytesToRead;
        int read;
        if (len <= 0) {
            return;
        }
        for (bytesToRead = len; bytesToRead > 0 && -1 != (read = this.in.read(values, off + len - bytesToRead, bytesToRead)); bytesToRead -= read) {
        }
        if (bytesToRead != 0) {
            throw new IOException("could not read [" + len + "] bytes: remaining [" + bytesToRead + "]");
        }
        this.sizeB += (long)len;
    }

    public void readBytes(ByteBuffer values, int len) throws IOException {
        int read;
        int bufferLength;
        if (len <= 0) {
            return;
        }
        byte[] buffer = new byte[4096];
        int bytesToRead = bufferLength = buffer.length;
        if (len < bufferLength) {
            bytesToRead = len;
        }
        int totalRead = 0;
        while (bytesToRead > 0 && -1 != (read = this.in.read(buffer, 0, bytesToRead))) {
            values.put(buffer, 0, read);
            bytesToRead = Math.min(len - (totalRead += read), bufferLength);
        }
        if (totalRead != len) {
            throw new IOException("could not read [" + len + "] bytes: actual count [" + totalRead + "]");
        }
        this.sizeB += (long)len;
    }

    public String readUTF8() throws IOException {
        int len = this.readInt();
        byte[] bytes = new byte[len];
        this.readBytes(bytes);
        String value = new String(bytes, StandardCharsets.UTF_8);
        return value;
    }

    public void readShorts(short[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = this.in.readShort();
        }
        this.sizeB += (long)(values.length * 2);
    }

    public char readChar() throws IOException {
        char cc = this.in.readChar();
        this.sizeB += 2L;
        return cc;
    }

    public void readChars(char[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = this.in.readChar();
        }
        this.sizeB += (long)(values.length * 2);
    }

    public int readInt() throws IOException {
        int val;
        if (this.lookAhead == null) {
            val = this.in.readInt();
        } else {
            val = this.lookAhead;
            this.lookAhead = null;
        }
        this.sizeB += 4L;
        return val;
    }

    public void readBackInt(int value) {
        this.lookAhead = value;
        this.sizeB -= 4L;
    }

    public long readLong() throws IOException {
        long val = this.in.readLong();
        this.sizeB += 8L;
        return val;
    }

    public void readInts(int[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = this.in.readInt();
        }
        this.sizeB += (long)(values.length * 4);
    }

    public void readLongs(long[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = this.in.readLong();
        }
        this.sizeB += (long)(values.length * 8);
    }

    public void readFloats(float[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = this.in.readFloat();
        }
        this.sizeB += (long)(values.length * 4);
    }

    public void readDoubles(double[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = this.in.readDouble();
        }
        this.sizeB += (long)(values.length * 8);
    }

    public void readComparables(Comparable[] values) throws IOException {
        if (values.length == 0) {
            return;
        }
        int type = this.in.readInt();
        if (type == 0) {
            this.readPairs(values);
            return;
        }
        throw new RuntimeException("internal error: inconsistent comparable list usage : " + type);
    }

    private void readPairs(Comparable[] values) throws IOException {
        int len = this.in.readInt();
        Comparable[] fst = this.readPairs(values.length, len);
        Comparable[] snd = this.readPairs(values.length, len);
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = new CdCPair(fst[ii], snd[ii]);
        }
    }

    private Comparable[] readPairs(int bufferLen, int len) throws IOException {
        int type = this.in.readInt();
        if (type == 1) {
            return this.readPairs_LocalDateTimes(bufferLen, len);
        }
        if (type == 2) {
            return this.readPairs_LocalDates(bufferLen, len);
        }
        if (type == 3) {
            return this.readPairs_Doubles(bufferLen, len);
        }
        if (type == 4) {
            return this.readPairs_Floats(bufferLen, len);
        }
        if (type == 5) {
            return this.readPairs_Longs(bufferLen, len);
        }
        if (type == 6) {
            return this.readPairs_Integers(bufferLen, len);
        }
        if (type == 7) {
            return this.readPairs_Shorts(bufferLen, len);
        }
        throw new RuntimeException("internal error: inconsistent comparable list usage : " + type);
    }

    private LocalDateTime[] readPairs_LocalDateTimes(int bufferLen, int len) throws IOException {
        LocalDateTime[] values = new LocalDateTime[bufferLen];
        for (int ii = 0; ii < len; ++ii) {
            values[ii] = CdJodaTimeUtil.toDefaultChronologyDateTime((long)this.in.readLong());
        }
        this.sizeB += (long)(len * 8);
        return values;
    }

    private LocalDate[] readPairs_LocalDates(int bufferLen, int len) throws IOException {
        LocalDate[] values = new LocalDate[bufferLen];
        for (int ii = 0; ii < len; ++ii) {
            values[ii] = CdJodaTimeUtil.toDefaultChronologyDate((int)this.in.readInt());
        }
        this.sizeB += (long)(len * 4);
        return values;
    }

    private Double[] readPairs_Doubles(int bufferLen, int len) throws IOException {
        Double[] values = new Double[bufferLen];
        for (int ii = 0; ii < len; ++ii) {
            values[ii] = this.in.readDouble();
        }
        this.sizeB += (long)(len * 8);
        return values;
    }

    private Float[] readPairs_Floats(int bufferLen, int len) throws IOException {
        Float[] values = new Float[bufferLen];
        for (int ii = 0; ii < len; ++ii) {
            values[ii] = Float.valueOf(this.in.readFloat());
        }
        this.sizeB += (long)(len * 4);
        return values;
    }

    private Long[] readPairs_Longs(int bufferLen, int len) throws IOException {
        Long[] values = new Long[bufferLen];
        for (int ii = 0; ii < len; ++ii) {
            values[ii] = this.in.readLong();
        }
        this.sizeB += (long)(len * 8);
        return values;
    }

    private Integer[] readPairs_Integers(int bufferLen, int len) throws IOException {
        Integer[] values = new Integer[bufferLen];
        for (int ii = 0; ii < len; ++ii) {
            values[ii] = this.in.readInt();
        }
        this.sizeB += (long)(len * 4);
        return values;
    }

    private Short[] readPairs_Shorts(int bufferLen, int len) throws IOException {
        Short[] values = new Short[bufferLen];
        for (int ii = 0; ii < len; ++ii) {
            values[ii] = this.in.readShort();
        }
        this.sizeB += (long)(len * 2);
        return values;
    }

    public void sync() {
        if (this.sizeB == 0L) {
            OlapLoggers.BACKUP_X.debug((Object)("[backup] restored [" + this.file.getName() + "] [no data written]"));
            return;
        }
        long elapsedMS = System.currentTimeMillis() - this.startMS;
        if (elapsedMS == 0L) {
            OlapLoggers.BACKUP_X.debug((Object)("[backup] restored [" + this.file.getName() + "] [" + CdSizeUtils.format((double)this.sizeB) + "]"));
            return;
        }
        double rawSizeM = (double)this.sizeB / 1024.0 / 1024.0;
        int rawSpeedMS = (int)(rawSizeM / (double)elapsedMS * 1000.0);
        if (!this.compressing) {
            OlapLoggers.BACKUP_X.debug((Object)("[backup] restored [" + this.file.getName() + "] [" + CdTimeUtils.formatMillis((long)elapsedMS) + "] [" + CdSizeUtils.format((double)this.sizeB) + "] [" + rawSpeedMS + "MB/s]"));
            return;
        }
        double compressedSizeB = this.fIn.getSizeB();
        double compressionRatio = (double)this.sizeB / compressedSizeB;
        double compressedSizeM = compressedSizeB / 1024.0 / 1024.0;
        int compressedSpeedMS = (int)(compressedSizeM / (double)elapsedMS * 1000.0);
        OlapLoggers.BACKUP_X.debug((Object)("[backup] restored [" + this.file.getName() + "] [" + CdTimeUtils.formatMillis((long)elapsedMS) + "] [" + CdSizeUtils.format((double)this.sizeB) + "] [" + rawSpeedMS + "MB/s] [compressed:" + CdSizeUtils.format((double)compressedSizeB) + "] [compression-ratio:" + String.format("%.1f", compressionRatio) + "] [compressed-speed:" + compressedSpeedMS + "MB/s]"));
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public void closeQuietly() {
        IOUtils.closeQuietly((InputStream)this.in);
    }
}

