/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.backup;

import crazydev.common.fs.CdVFileSupplier;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.fs.CdZipOptions;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.cluster.master.backup.info.M_BackupActivityInfo;
import crazydev.iccube.cluster.master.backup.info.M_BackupActivityInfoUI;
import crazydev.iccube.cluster.master.backup.info.M_BackupDetailUI;
import crazydev.iccube.cluster.master.backup.info.M_BackupInfo;
import crazydev.iccube.cluster.master.backup.info.M_BackupInfoUI;
import crazydev.iccube.cluster.master.backup.save.M_DeleteBackupInfo;
import crazydev.iccube.cluster.master.backup.save.M_DeleteBackupInfos;
import crazydev.iccube.cluster.shared.backup.S_BackupMode;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfoError;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfoParser;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;
import org.jetbrains.annotations.Nullable;

public abstract class S_BackupHelper {
    public static final int TYPE_PAIRS = 0;
    public static final int TYPE_LOCAL_DATE_TIMES = 1;
    public static final int TYPE_LOCAL_DATES = 2;
    public static final int TYPE_DOUBLES = 3;
    public static final int TYPE_FLOATS = 4;
    public static final int TYPE_LONGS = 5;
    public static final int TYPE_INTEGERS = 6;
    public static final int TYPE_SHORTS = 7;
    public static final String CLEANUP = "cleanup";
    public static final String ACTIVITIES = "activities";
    public static final String TABLES = "tables";
    public static final String FACTS = "facts";
    public static final String SAVE_POINTS = "save-points";
    public static final String M2M = "m2ms";
    public static final String BRIDGE = "bridges";
    public static final String CUBES_UNRESOLVED_ROWS = "unresolved-rows";
    public static final String LOAD_PARTITION_HISTORY = "load-partition-history";

    private S_BackupHelper() {
    }

    public static int VERSION() {
        return 1;
    }

    public static String asFileName(String name) {
        if (S_BackupHelper.isValidFileName(name)) {
            return name;
        }
        Base32 base32 = new Base32();
        byte[] bytes = name.getBytes(StandardCharsets.UTF_8);
        String filename = "_" + base32.encodeToString(bytes);
        return filename;
    }

    private static boolean isValidFileName(String name) {
        for (int idx = 0; idx < name.length(); ++idx) {
            char cc = name.charAt(idx);
            if (idx == 0 && cc == '_') {
                return false;
            }
            if (Character.isLetter(cc) || Character.isDigit(cc) || cc == '(' || cc == ')' || cc == ' ' || cc == '-' || cc == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isBackupWithPartitionHistory(File backupDir) {
        File file = new File(backupDir, "load-partition-history.txt");
        if (!file.exists()) {
            return true;
        }
        try {
            List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
            if (!lines.isEmpty()) {
                String line = lines.getFirst();
                return !"DISCARD".equals(line);
            }
            return true;
        }
        catch (IOException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] could not get backup history mode [" + backupDir.getAbsolutePath() + "]"), (Throwable)ex);
            return true;
        }
    }

    public static void setBackupWithNoPartitionHistory(File backupDir) throws IOException {
        File file = new File(backupDir, "load-partition-history.txt");
        if (file.exists()) {
            file.delete();
        }
        S_BackupHelper.writeFile(file, "DISCARD");
    }

    public static String createTimestamp() {
        long nowMS = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss SSS zzz");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(nowMS);
    }

    public static Date getTimestamp(String timestamp) {
        try {
            Date date = S_BackupHelper.getTimestampX(timestamp);
            return date;
        }
        catch (ParseException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] could not extract timestamp from [" + timestamp + "]"), (Throwable)ex);
            return new Date();
        }
    }

    public static Date getTimestampX(String timestamp) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss SSS zzz");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = df.parse(timestamp);
        return date;
    }

    @Nullable
    public static String getLatestValidBackup(CdVFileSystem vfs, File backupDirectory, String schemaName) {
        List<M_BackupInfo> backups = S_BackupHelper.getBackupInfos(vfs, backupDirectory, schemaName);
        if (backups.isEmpty()) {
            return null;
        }
        M_BackupInfo latest = null;
        for (M_BackupInfo backup : backups) {
            if (!backup.isValid() || !backup.getSchema().equals(schemaName) || latest != null && backup.getTimestamp().compareTo(latest.getTimestamp()) <= 0) continue;
            latest = backup;
        }
        if (latest == null) {
            return null;
        }
        return latest.getTimestamp();
    }

    public static List<M_BackupInfo> getBackupInfos(CdVFileSystem vfs, File backupDirectory, @Nullable String filter) {
        ArrayList<M_BackupInfo> backups = new ArrayList<M_BackupInfo>();
        Path dir = backupDirectory.toPath();
        DirectoryStream.Filter<Path> firstLevelFilter = entry -> entry.getParent().equals(dir) && entry.toFile().isDirectory() && !CdVFileSystem.isTemporary((Path)entry);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, firstLevelFilter);){
            for (Path file : stream) {
                S_BackupHelper.getBackupsInfoForSchema(vfs, backups, filter, file);
            }
        }
        catch (IOException | DirectoryIteratorException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] could not get backup infos [" + backupDirectory.getAbsolutePath() + "]"), (Throwable)ex);
        }
        return backups;
    }

    private static void getBackupsInfoForSchema(CdVFileSystem vfs, List<M_BackupInfo> backups, @Nullable String filter, Path dir) {
        File dirF = dir.toFile();
        try {
            File meta = new File(dir.toFile(), "meta-info.txt");
            List<String> lines = Files.readAllLines(meta.toPath(), StandardCharsets.UTF_8);
            String schema = lines.getFirst().substring("schema:".length());
            if (!CdStringUtils.isNullOrBlank((String)filter) && !Strings.CI.contains((CharSequence)schema, (CharSequence)filter)) {
                return;
            }
            DirectoryStream.Filter<Path> timestampFilter = entry -> entry.getParent().equals(dir) && entry.toFile().isDirectory() && !CdVFileSystem.isTemporary((Path)entry);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, timestampFilter);){
                for (Path file : stream) {
                    M_BackupInfo backup = S_BackupHelper.getBackupInfoForSchema(vfs, schema, file);
                    backups.add(backup);
                }
            }
            catch (IOException | DirectoryIteratorException ex) {
                OlapLoggers.BACKUP.error((Object)("[backup] could not get schema [" + schema + "] backup infos [" + dirF.getName() + "]"), (Throwable)ex);
            }
        }
        catch (IOException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] could not get backup info for [" + dirF.getName() + "]"), (Throwable)ex);
        }
    }

    private static M_BackupInfo getBackupInfoForSchema(CdVFileSystem vfs, String schema, Path dir) {
        File[] activitiesF;
        File dirF = dir.toFile();
        File definition = new File(dirF, "definition.icc-schema");
        String timestamp = dirF.getName();
        boolean valid = new File(dirF, "valid.icc-marker").exists();
        ArrayList<M_BackupActivityInfo> activities = new ArrayList<M_BackupActivityInfo>();
        for (File activityF : activitiesF = S_BackupHelper.activities(vfs, dirF, false)) {
            boolean activityValid = new File(activityF, "valid.icc-marker").exists();
            String activityKind = "n/a";
            File meta = new File(activityF, "meta-info.txt");
            if (meta.exists()) {
                try {
                    List<String> lines = Files.readAllLines(meta.toPath(), StandardCharsets.UTF_8);
                    if (!lines.isEmpty()) {
                        activityKind = lines.getFirst();
                    }
                }
                catch (IOException ex) {
                    OlapLoggers.BACKUP.error((Object)("[backup] could not get backup info for activity [" + activityF.getName() + "]"), (Throwable)ex);
                }
            }
            String activityTimestamp = activityF.getName();
            activities.add(new M_BackupActivityInfo(activityValid, activityKind, activityTimestamp));
        }
        activities.sort(Comparator.comparing(M_BackupActivityInfo::getTimestamp));
        return new M_BackupInfo(schema, timestamp, definition, valid, activities);
    }

    public static void forEachBackupName(CdVFileSystem vfs, File backupDirectory, Consumer<String> action) {
        Path dir = backupDirectory.toPath();
        DirectoryStream.Filter<Path> firstLevelFilter = entry -> entry.getParent().equals(dir) && entry.toFile().isDirectory() && !CdVFileSystem.isTemporary((Path)entry);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, firstLevelFilter);){
            for (Path file : stream) {
                S_BackupHelper.forEachBackupNameForSchemaUI(vfs, file, action);
            }
        }
        catch (IOException | DirectoryIteratorException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] could not get backup names [" + backupDirectory.getAbsolutePath() + "]"), (Throwable)ex);
        }
    }

    public static void forEachBackupInfoUI(CdVFileSystem vfs, File backupDirectory, Consumer<M_BackupInfoUI> action) {
        Path dir = backupDirectory.toPath();
        DirectoryStream.Filter<Path> firstLevelFilter = entry -> entry.getParent().equals(dir) && entry.toFile().isDirectory() && !CdVFileSystem.isTemporary((Path)entry);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, firstLevelFilter);){
            for (Path file : stream) {
                S_BackupHelper.forEachBackupInfoForSchemaUI(vfs, file, action);
            }
        }
        catch (IOException | DirectoryIteratorException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] could not get backup infos [" + backupDirectory.getAbsolutePath() + "]"), (Throwable)ex);
        }
    }

    private static void forEachBackupNameForSchemaUI(CdVFileSystem vfs, Path dir, Consumer<String> action) {
        File dirF = dir.toFile();
        try {
            File meta = new File(dir.toFile(), "meta-info.txt");
            List<String> lines = Files.readAllLines(meta.toPath(), StandardCharsets.UTF_8);
            String schema = lines.getFirst().substring("schema:".length());
            action.accept(schema);
        }
        catch (IOException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] could not get backup info for [" + dirF.getName() + "]"), (Throwable)ex);
        }
    }

    private static void forEachBackupInfoForSchemaUI(CdVFileSystem vfs, Path dir, Consumer<M_BackupInfoUI> action) {
        File dirF = dir.toFile();
        try {
            File meta = new File(dir.toFile(), "meta-info.txt");
            List<String> lines = Files.readAllLines(meta.toPath(), StandardCharsets.UTF_8);
            String schema = lines.getFirst().substring("schema:".length());
            DirectoryStream.Filter<Path> timestampFilter = entry -> entry.getParent().equals(dir) && entry.toFile().isDirectory() && !CdVFileSystem.isTemporary((Path)entry);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, timestampFilter);){
                for (Path file : stream) {
                    M_BackupInfoUI backup = S_BackupHelper.getBackupInfoForSchemaUI(vfs, schema, file);
                    action.accept(backup);
                }
            }
            catch (IOException | DirectoryIteratorException ex) {
                OlapLoggers.BACKUP.error((Object)("[backup] could not get schema [" + schema + "] backup infos [" + dirF.getName() + "]"), (Throwable)ex);
            }
        }
        catch (IOException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] could not get backup info for [" + dirF.getName() + "]"), (Throwable)ex);
        }
    }

    private static M_BackupInfoUI getBackupInfoForSchemaUI(CdVFileSystem vfs, String schema, Path dir) {
        File[] activitiesF;
        File dirF = dir.toFile();
        File definition = new File(dirF, "definition.icc-schema");
        String timestamp = dirF.getName();
        boolean valid = new File(dirF, "valid.icc-marker").exists();
        ArrayList<M_BackupActivityInfoUI> activities = new ArrayList<M_BackupActivityInfoUI>();
        for (File activityF : activitiesF = S_BackupHelper.activities(vfs, dirF, false)) {
            boolean activityValid = new File(activityF, "valid.icc-marker").exists();
            String activityKind = "n/a";
            File meta = new File(activityF, "meta-info.txt");
            if (meta.exists()) {
                try {
                    List<String> lines = Files.readAllLines(meta.toPath(), StandardCharsets.UTF_8);
                    if (!lines.isEmpty()) {
                        activityKind = lines.getFirst();
                    }
                }
                catch (IOException ex) {
                    OlapLoggers.BACKUP.error((Object)("[backup] could not get backup info for activity [" + activityF.getName() + "]"), (Throwable)ex);
                }
            }
            String activityTimestamp = activityF.getName();
            activities.add(new M_BackupActivityInfoUI(activityValid, activityKind, activityTimestamp));
        }
        String group = null;
        try {
            OlapSchemaFactoryInfo info = OlapSchemaFactoryInfoParser.parse(definition);
            group = info.getGroup();
        }
        catch (OlapSchemaFactoryInfoError olapSchemaFactoryInfoError) {
            // empty catch block
        }
        return new M_BackupInfoUI(schema, group, timestamp, definition, valid, activities);
    }

    public static M_BackupDetailUI getBackupDetailUI(CdVFileSystem vfs, File backupDirectory, String schema, String timestamp) {
        OlapFile schemaDir;
        OlapFileSystem backups = OlapFileSystem.createFileSystem(vfs, backupDirectory);
        OlapFile schemaBackupDir = backups.create(schemaDir = backups.create(S_BackupHelper.asFileName(schema)), timestamp);
        if (!schemaBackupDir.exists() || !schemaBackupDir.isDirectory()) {
            return null;
        }
        File schemaBackupDir_ = schemaBackupDir.__getUnderlying();
        long size = vfs.getSize(schemaBackupDir_);
        String errors = null;
        try {
            File errFile = new File(schemaBackupDir_, "error.txt");
            if (errFile.exists()) {
                List<String> lines = Files.readAllLines(errFile.toPath(), StandardCharsets.UTF_8);
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append(line).append("\n");
                }
                errors = sb.toString();
            }
        }
        catch (IOException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] could not extract error information from schema backup [" + schemaBackupDir.getPath() + "]"));
        }
        M_BackupInfoUI backup = S_BackupHelper.getBackupInfoForSchemaUI(vfs, schema, schemaBackupDir_.toPath());
        return new M_BackupDetailUI(backup, size, errors);
    }

    public static OlapFile getBackupFactoryFile(CdVFileSystem vfs, File backupDirectory, String schema, String timestamp) {
        OlapFile schemaDir;
        OlapFileSystem backups = OlapFileSystem.createFileSystem(vfs, backupDirectory);
        OlapFile schemaBackupDir = backups.create(schemaDir = backups.create(S_BackupHelper.asFileName(schema)), timestamp);
        if (!schemaBackupDir.exists() || !schemaBackupDir.isDirectory()) {
            return null;
        }
        return backups.create(schemaBackupDir, "definition.icc-schema");
    }

    public static boolean deleteBackup(CdVFileSystem vfs, File backupDirectory, String schema, String timestamp) {
        OlapFile schemaDir;
        OlapFileSystem backups = OlapFileSystem.createFileSystem(vfs, backupDirectory);
        OlapFile schemaBackupDir = backups.create(schemaDir = backups.create(S_BackupHelper.asFileName(schema)), timestamp);
        if (!schemaBackupDir.exists() || !schemaBackupDir.isDirectory()) {
            return false;
        }
        File schemaBackupDir_ = schemaBackupDir.__getUnderlying();
        boolean deleted = vfs.delete(schemaBackupDir_);
        OlapLoggers.BACKUP.info((Object)("[backup] delete schema backup [" + schema + "] [" + timestamp + "] [" + deleted + "] [" + schemaBackupDir.getPath() + "]"));
        return deleted;
    }

    public static M_DeleteBackupInfos deleteBackups(CdVFileSystem vfs, File backupDirectory, String schema, String timestamp) {
        ArrayList<M_DeleteBackupInfo> infos = new ArrayList<M_DeleteBackupInfo>();
        if (!CLEANUP.equals(timestamp)) {
            boolean deleted = S_BackupHelper.deleteBackup(vfs, backupDirectory, schema, timestamp);
            infos.add(new M_DeleteBackupInfo(schema, timestamp, deleted));
        } else {
            List<M_BackupInfo> backups = S_BackupHelper.getBackupInfos(vfs, backupDirectory, schema);
            backups.sort((o1, o2) -> -o1.getTimestamp().compareTo(o2.getTimestamp()));
            int keptCount = 0;
            for (M_BackupInfo backup : backups) {
                boolean deleted;
                if (!backup.getSchema().equals(schema)) continue;
                if (!backup.isValid()) {
                    deleted = S_BackupHelper.deleteBackup(vfs, backupDirectory, schema, backup.getTimestamp());
                    infos.add(new M_DeleteBackupInfo(schema, backup.getTimestamp(), deleted));
                    continue;
                }
                if (keptCount < 2) {
                    ++keptCount;
                    infos.add(new M_DeleteBackupInfo(schema, backup.getTimestamp(), false));
                    continue;
                }
                deleted = S_BackupHelper.deleteBackup(vfs, backupDirectory, schema, backup.getTimestamp());
                infos.add(new M_DeleteBackupInfo(schema, backup.getTimestamp(), deleted));
            }
        }
        return new M_DeleteBackupInfos(infos);
    }

    public static M_DeleteBackupInfos cleanAllBackups(CdVFileSystem vfs, File backupDirectory) {
        ArrayList<M_DeleteBackupInfo> infos = new ArrayList<M_DeleteBackupInfo>();
        S_BackupHelper.forEachBackupName(vfs, backupDirectory, schema -> {
            M_DeleteBackupInfos deleted = S_BackupHelper.deleteBackups(vfs, backupDirectory, schema, CLEANUP);
            infos.addAll(deleted.getInfos());
        });
        return new M_DeleteBackupInfos(infos);
    }

    public static File exportBackup(CdVFileSystem vfs, File tmpDirectory, File backupDirectory, String schema, String timestamp) throws IOException {
        String schemaFile = S_BackupHelper.asFileName(schema);
        File schemaDir = new File(backupDirectory, schemaFile);
        File schemaBackupDir = new File(schemaDir, timestamp);
        if (!schemaBackupDir.exists()) {
            throw new FileNotFoundException("schema backup not found [" + schemaBackupDir.getPath() + "]");
        }
        File meta = new File(schemaBackupDir.getParentFile(), "meta-info.txt");
        if (!meta.exists()) {
            throw new FileNotFoundException("schema backup meta not found [" + meta.getPath() + "]");
        }
        File out = vfs.createTmpFileForDownload(tmpDirectory, "zip");
        try {
            vfs.zip(CdZipOptions.withRoot(), out, new File[]{meta, schemaBackupDir});
            return out;
        }
        catch (IOException ex) {
            vfs.delete(out);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importBackup(CdVFileSystem vfs, File backupDirectory, String fileName, CdVFileSupplier<InputStream> zip) throws IOException {
        File unzipDir = vfs.createSchemaBackupTmpDirectoryForUpload(backupDirectory, fileName);
        try {
            String timestamp;
            CdVFileSystemUtils.deleteDirectory((File)unzipDir);
            vfs.uploadZip(unzipDir, zip);
            File meta = new File(unzipDir, "meta-info.txt");
            if (!meta.exists()) {
                throw new IOException("invalid schema backup (missing meta-info.txt)");
            }
            List<String> lines = Files.readAllLines(meta.toPath(), StandardCharsets.UTF_8);
            String schema = lines.get(0).substring("schema:".length());
            File[] unzipFiles = unzipDir.listFiles(pathname -> !pathname.getName().equals("meta-info.txt"));
            if (unzipFiles == null) {
                throw new IOException("inconsistent schema backup");
            }
            if (unzipFiles.length != 1) {
                throw new IOException("inconsistent schema backup (" + unzipFiles.length + ")");
            }
            String schemaFileName = S_BackupHelper.asFileName(schema);
            File schemaBackupDir = vfs.createSchemaBackupDirectory(backupDirectory, schema, schemaFileName);
            File toSchemaBackupDir = new File(schemaBackupDir, timestamp = unzipFiles[0].getName());
            if (toSchemaBackupDir.exists()) {
                throw new IOException("existing schema [" + schema + "] backup [" + timestamp + "] (delete first the existing backup to import the new backup)");
            }
            File fromSchemaBackupDir = new File(unzipDir, timestamp);
            vfs.moveDirectory(fromSchemaBackupDir, toSchemaBackupDir);
        }
        finally {
            vfs.delete(unzipDir);
        }
    }

    public static File createSchemaBackupDirectory(CdVFileSystem vfs, File backupDirectory, String schema, IOlapBuilderSchemaDefFactory schemaDefinition, OlapBuilderMetaInformationRepository metaInfo) throws IOException {
        File backupDir = vfs.createSchemaBackupDirectory(backupDirectory, schema, S_BackupHelper.asFileName(schema), S_BackupHelper::createTimestamp);
        if (!backupDir.exists()) {
            throw new IOException("could not create the schema [" + schema + "] backup directory [" + backupDir.getAbsolutePath() + "]");
        }
        S_BackupHelper.createBackupDir(backupDir, TABLES, true);
        S_BackupHelper.createBackupDir(backupDir, FACTS, true);
        S_BackupHelper.createBackupDir(backupDir, M2M, false);
        S_BackupHelper.createBackupDir(backupDir, BRIDGE, false);
        S_BackupHelper.createBackupDir(backupDir, CUBES_UNRESOLVED_ROWS, false);
        S_BackupHelper.createBackupDir(backupDir, SAVE_POINTS, false);
        S_BackupHelper.createBackupDir(backupDir, ACTIVITIES, false);
        S_BackupHelper.writeVersion(backupDir);
        S_BackupHelper.writeSchemaDefinition(backupDir, schemaDefinition, metaInfo);
        return backupDir;
    }

    public static File createSchemaBackupDirectoryForUnloadPartitions(String schema, File rootBackup, S_BackupMode mode, IOlapEngineLoadSchemaParams params) throws IOException {
        if (!rootBackup.exists()) {
            throw new IOException("missing backup directory [" + rootBackup.getAbsolutePath() + "] for schema [" + schema + "]");
        }
        File activityDir = new File(rootBackup, ACTIVITIES);
        if (!activityDir.exists()) {
            throw new IOException("missing backup activities directory [" + activityDir.getAbsolutePath() + "] for schema [" + schema + "]");
        }
        String timestamp = S_BackupHelper.createTimestamp();
        File dir = new File(activityDir, timestamp);
        if (dir.exists()) {
            throw new IOException("existing backup directory [" + dir.getAbsolutePath() + "] for schema [" + schema + "]");
        }
        if (!dir.mkdir()) {
            throw new IOException("could not create the schema [" + schema + "] backup directory [" + dir.getAbsolutePath() + "]");
        }
        S_BackupHelper.createBackupDir(dir, FACTS, true);
        params.save(new File(dir, "meta-info.txt"));
        String xmlaStatement = params.getXmlaStatement();
        if (CdStringUtils.isNullOrBlank((String)xmlaStatement)) {
            xmlaStatement = "n/a";
        }
        S_BackupHelper.writeFile(new File(dir, "command.txt"), "# " + mode.name() + "\n" + xmlaStatement);
        return dir;
    }

    public static File createSchemaBackupDirectoryForLoadPartitions(String schema, File rootBackup, S_BackupMode mode, IOlapEngineLoadSchemaParams params) throws IOException {
        if (!rootBackup.exists()) {
            throw new IOException("missing backup directory [" + rootBackup.getAbsolutePath() + "] for schema [" + schema + "]");
        }
        File activityDir = new File(rootBackup, ACTIVITIES);
        if (!activityDir.exists()) {
            throw new IOException("missing backup activities directory [" + activityDir.getAbsolutePath() + "] for schema [" + schema + "]");
        }
        String timestamp = S_BackupHelper.createTimestamp();
        File dir = new File(activityDir, timestamp);
        if (dir.exists()) {
            throw new IOException("existing backup directory [" + dir.getAbsolutePath() + "] for schema [" + schema + "]");
        }
        if (!dir.mkdir()) {
            throw new IOException("could not create the schema [" + schema + "] backup directory [" + dir.getAbsolutePath() + "]");
        }
        S_BackupHelper.createBackupDir(dir, FACTS, true);
        S_BackupHelper.createBackupDir(dir, CUBES_UNRESOLVED_ROWS, false);
        S_BackupHelper.createBackupDir(dir, SAVE_POINTS, false);
        params.save(new File(dir, "meta-info.txt"));
        String xmlaStatement = params.getXmlaStatement();
        if (CdStringUtils.isNullOrBlank((String)xmlaStatement)) {
            xmlaStatement = "n/a";
        }
        S_BackupHelper.writeFile(new File(dir, "command.txt"), "# " + mode.name() + "\n" + xmlaStatement);
        return dir;
    }

    public static File createSchemaBackupDirectoryForIncrLoad(CdVFileSystem vfs, File backupDirectory, String schema, IOlapEngineLoadSchemaParams params) throws IOException {
        String schemaFileName = S_BackupHelper.asFileName(schema);
        File dir = vfs.createSchemaBackupTmpDirectoryForIncrLoad(backupDirectory, schemaFileName, S_BackupHelper::createTimestamp);
        S_BackupHelper.createBackupDir(dir, TABLES, true);
        S_BackupHelper.createBackupDir(dir, M2M, false);
        S_BackupHelper.createBackupDir(dir, BRIDGE, false);
        params.save(new File(dir, "meta-info.txt"));
        S_BackupHelper.writeFile(new File(dir, "command.txt"), "# LOAD_INCR\n");
        return dir;
    }

    public static File createSchemaBackupDirectoryForExecScript(String schema, File rootBackup, String script) throws IOException {
        if (!rootBackup.exists()) {
            throw new IOException("missing backup directory [" + rootBackup.getAbsolutePath() + "] for schema [" + schema + "]");
        }
        File activityDir = new File(rootBackup, ACTIVITIES);
        if (!activityDir.exists()) {
            throw new IOException("missing backup activities directory [" + activityDir.getAbsolutePath() + "] for schema [" + schema + "]");
        }
        String timestamp = S_BackupHelper.createTimestamp();
        File dir = new File(activityDir, timestamp);
        if (dir.exists()) {
            throw new IOException("existing backup directory [" + dir.getAbsolutePath() + "] for schema [" + schema + "]");
        }
        if (!dir.mkdir()) {
            throw new IOException("could not create the schema [" + schema + "] backup directory [" + dir.getAbsolutePath() + "]");
        }
        S_BackupHelper.writeFile(new File(dir, "meta-info.txt"), "EXECUTE_SCRIPT\n" + script);
        S_BackupHelper.writeFile(new File(dir, "command.txt"), "# SCRIPT\n" + script);
        return dir;
    }

    private static void createBackupDir(File dir, String name, boolean meta) throws IOException {
        File nestedDir = new File(dir, name);
        if (!nestedDir.mkdir()) {
            throw new IOException("could not create the backup directory [" + nestedDir.getAbsolutePath() + "]");
        }
        if (meta) {
            S_BackupHelper.writeFile(new File(nestedDir, "meta-info.txt"), "");
        }
    }

    public static File getSchemaBackupDirectory(File backupDirectory, String schema, String timestamp) {
        String schemaFileName = S_BackupHelper.asFileName(schema);
        File schemaDir = new File(backupDirectory, schemaFileName);
        File dir = new File(schemaDir, timestamp);
        return dir;
    }

    public static void writeFile(File file, String content) throws IOException {
        if (file.exists()) {
            throw new IOException("duplicated backup file [" + file.getAbsolutePath() + "]");
        }
        try {
            FileOutputStream fOut = new FileOutputStream(file);
            OutputStreamWriter oWriter = new OutputStreamWriter((OutputStream)fOut, StandardCharsets.UTF_8);
            BufferedWriter writer = new BufferedWriter(oWriter);
            writer.write(content);
            ((Writer)writer).flush();
            fOut.getFD().sync();
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            throw new IOException("could not write to backup file [" + file.getAbsolutePath() + "]", ex);
        }
    }

    public static void appendToFile(File file, String content) throws IOException {
        if (!file.exists()) {
            throw new IOException("missing backup file [" + file.getAbsolutePath() + "]");
        }
        try {
            FileOutputStream fOut = new FileOutputStream(file, true);
            OutputStreamWriter oWriter = new OutputStreamWriter((OutputStream)fOut, StandardCharsets.UTF_8);
            BufferedWriter writer = new BufferedWriter(oWriter);
            writer.write(content);
            ((Writer)writer).flush();
            fOut.getFD().sync();
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            throw new IOException("could not write to backup file [" + file.getAbsolutePath() + "]", ex);
        }
    }

    public static void writeVersion(File dir) throws IOException {
        S_BackupHelper.writeFile(new File(dir, "version.txt"), String.valueOf(S_BackupHelper.VERSION()));
    }

    public static int getBackupVersion(File root) {
        int n;
        block6: {
            File versionF = new File(root, "version.txt");
            if (!versionF.exists()) {
                return 0;
            }
            BufferedReader reader = null;
            try {
                int version;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(versionF), StandardCharsets.UTF_8));
                String value = reader.readLine().trim();
                n = version = Integer.parseInt(value);
                if (reader == null) break block6;
            }
            catch (IOException ex) {
                try {
                    throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"could not restore version [" + root.getAbsolutePath() + "]", ex});
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        IOUtils.closeQuietly(reader);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        return n;
    }

    public static void writeSchemaDefinition(File dir, IOlapBuilderSchemaDefFactory definition, OlapBuilderMetaInformationRepository metaInfo) throws IOException {
        try {
            File fromFile = definition.getXmlFile();
            if (fromFile == null) {
                S_BackupHelper.writeSchemaDefinitionWithJAXB(dir, definition, metaInfo);
                return;
            }
            File toFile = new File(dir, "definition.icc-schema");
            FileInputStream fromIn = new FileInputStream(fromFile);
            BufferedInputStream fromInB = new BufferedInputStream(fromIn);
            FileOutputStream toOut = new FileOutputStream(toFile);
            BufferedOutputStream toOutB = new BufferedOutputStream(toOut);
            IOUtils.copy((InputStream)fromInB, (OutputStream)toOutB);
            toOutB.flush();
            toOut.getFD().sync();
            fromInB.close();
            toOutB.close();
        }
        catch (IOException ex) {
            throw new IOException("could not write the schema definition [" + definition.getName() + "]", ex);
        }
    }

    private static void writeSchemaDefinitionWithJAXB(File dir, IOlapBuilderSchemaDefFactory definition, OlapBuilderMetaInformationRepository metaInfo) throws IOException {
        try {
            File file = new File(dir, "definition.icc-schema");
            FileOutputStream fOut = new FileOutputStream(file, true);
            OutputStreamWriter oWriter = new OutputStreamWriter((OutputStream)fOut, StandardCharsets.UTF_8);
            PrintWriter writer = new PrintWriter(new BufferedWriter(oWriter));
            CdXmlUtils.marshall((Writer)writer, (Object)definition, (Class[])metaInfo.getPersistentClasses());
            ((Writer)writer).flush();
            fOut.getFD().sync();
            ((Writer)writer).close();
        }
        catch (JAXBException | IOException ex) {
            throw new IOException("could not write the schema definition [" + definition.getName() + "]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] activities(CdVFileSystem vfs, File backupDir, boolean validOnly) {
        File dir = new File(backupDir, ACTIVITIES);
        ArrayList<File> activities = new ArrayList<File>();
        if (dir.exists()) {
            DirectoryStream stream = null;
            try {
                stream = vfs.createDirectoryStream(dir, entry -> {
                    if (Files.isDirectory(entry, new LinkOption[0]) && !CdVFileSystem.isTemporary((Path)entry)) {
                        boolean valid = new File(entry.toFile(), "valid.icc-marker").exists();
                        if (validOnly && !valid) {
                            OlapLoggers.BACKUP.debug((Object)("[backup] ignoring invalid activity " + String.valueOf(entry)));
                            return false;
                        }
                        return true;
                    }
                    return false;
                });
                for (Path path : stream) {
                    activities.add(path.toFile());
                }
            }
            catch (IOException ex) {
                try {
                    OlapLoggers.BACKUP.error((Object)"[backup] could not retrieve the activities", (Throwable)ex);
                    activities.clear();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)stream);
            }
            IOUtils.closeQuietly((Closeable)stream);
        }
        activities.sort((o1, o2) -> {
            String n1 = o1.getName();
            String n2 = o2.getName();
            return n1.compareTo(n2);
        });
        return activities.toArray(new File[0]);
    }

    public static File[] prevBackups(File backupDirectory, String schema, String timestamp) {
        String schemaFileName = S_BackupHelper.asFileName(schema);
        File schemaDir = new File(backupDirectory, schemaFileName);
        File[] backups = schemaDir.listFiles((dir, name) -> name.compareTo(timestamp) < 0);
        if (backups == null) {
            return new File[0];
        }
        return backups;
    }

    public static boolean deleteForContinueBackupOnLoadPartitionsOnError(@Nullable File dir) {
        if (dir == null || !dir.exists()) {
            return true;
        }
        try {
            return CdVFileSystemUtils.deleteQuietly((File)dir);
        }
        catch (RuntimeException ex) {
            OlapLoggers.BACKUP.warn((Object)("[backup] could not delete the directory [" + dir.getAbsolutePath() + "]"), (Throwable)ex);
            return false;
        }
    }
}

