/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.schema;

import crazydev.iccube.cluster.node.context.N_FastCrossjoinContext;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_FactTuplesDef;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapAggregation;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class N_FastCj_Cache {
    private final HashMap<N_FactPage, OlapFactsBitmap> cache = new HashMap();
    private final S_FactTupleDef filterMembers;
    private List<S_FactTuplesDef> filters;

    N_FastCj_Cache(S_FactTupleDef filterMembers) {
        this.filterMembers = filterMembers;
    }

    public OlapFactsBitmap get(N_FastCrossjoinContext context, N_FactPage factPage) {
        return this.cache.computeIfAbsent(factPage, fPage -> this.calc(context, (N_FactPage)fPage));
    }

    void addToFilter(S_FactTuplesDef newFilter) {
        for (Map.Entry<N_FactPage, OlapFactsBitmap> entry : this.cache.entrySet()) {
            IFactsBitmapAndTor andTor = OlapFactsBitmapAggregation.facts_createBitmapAndTor();
            andTor.add(entry.getValue());
            this.add(entry.getKey(), andTor, newFilter);
            this.cache.put(entry.getKey(), andTor.facts_asBitmap());
        }
        if (this.filters == null) {
            this.filters = new ArrayList<S_FactTuplesDef>();
        }
        this.filters.add(newFilter);
    }

    private OlapFactsBitmap calc(N_FastCrossjoinContext context, N_FactPage factPage) {
        IFactsBitmapAndTor andTor = OlapFactsBitmapAggregation.facts_createBitmapAndTor();
        andTor.add(context.getGlobalBitmap(factPage));
        factPage.addForCj((OlapFactsBitmapCollector)andTor, this.filterMembers);
        this.add(factPage, andTor);
        return andTor.facts_asBitmap();
    }

    private void add(N_FactPage factPage, IFactsBitmapAndTor andTor) {
        if (this.filters != null) {
            for (int i = 0; i < this.filters.size(); ++i) {
                S_FactTuplesDef filter = this.filters.get(i);
                this.add(factPage, andTor, filter);
            }
        }
    }

    private void add(N_FactPage factPage, IFactsBitmapAndTor andTor, S_FactTuplesDef filter) {
        int size = filter.size();
        for (int i = 0; i < size; ++i) {
            S_FactTupleDef tupleDef = filter.get(i);
            factPage.addForCj((OlapFactsBitmapCollector)andTor, tupleDef);
        }
    }

    public S_FactTupleDef getFilterMembers() {
        return this.filterMembers;
    }
}

