/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.schema;

import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.facts.N_FactBitmapContainer;
import crazydev.iccube.cluster.shared.schema.S_BitSetTupleDimensionality;
import crazydev.iccube.cluster.shared.schema.S_CategoryDef;
import crazydev.iccube.cluster.shared.schema.S_FactSubCube;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapZero;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBuffer;
import crazydev.iccube.olap.index.bitmap.tor.OlapBitmapTor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.mutable.MutableLong;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class N_Category {
    private final S_CategoryDef def;
    private final Map<N_FactBitmapContainer, OlapFactsBitmap> bitmaps = new ConcurrentHashMap<N_FactBitmapContainer, OlapFactsBitmap>();

    public N_Category(S_CategoryDef def) {
        this.def = def;
    }

    public long sizeOf() {
        MutableLong sizeOf = new MutableLong();
        this.bitmaps.forEach((facts, bitmap) -> {
            if (bitmap instanceof OlapFactsBitmapRoaringBuffer) {
                OlapFactsBitmapRoaringBuffer buffer = (OlapFactsBitmapRoaringBuffer)bitmap;
                ImmutableRoaringBitmap bits = buffer.asRoaring();
                sizeOf.add(bits.sizeOf());
            }
        });
        return sizeOf.longValue();
    }

    public String toString() {
        return this.def.toString();
    }

    public OlapFactsBitmap getOrCreateCategoryBitmap(N_MdxRequestContext context, N_FactBitmapContainer bitmapContainer) {
        int baseHierarchyIndex = this.def.getBaseHierarchyIndex();
        if (baseHierarchyIndex != -1 && !bitmapContainer.isIndexingHierarchy(baseHierarchyIndex)) {
            return null;
        }
        OlapFactsBitmap bitmap = this.bitmaps.get(bitmapContainer);
        if (bitmap == null) {
            bitmap = this.getOrCreateBitmap(context, bitmapContainer);
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapFactsBitmap getOrCreateBitmap(N_MdxRequestContext context, N_FactBitmapContainer bitmapContainer) {
        Map<N_FactBitmapContainer, OlapFactsBitmap> map = this.bitmaps;
        synchronized (map) {
            S_FactSubCube subCube = this.def.getSubCube();
            S_BitSetTupleDimensionality filterTupleDim = S_BitSetTupleDimensionality.ZERO;
            OlapBitmapTor tor = subCube.createBitmapTor(context, bitmapContainer, filterTupleDim);
            OlapFactsBitmap bitmap = !tor.isEmpty() ? tor.solve() : OlapFactsBitmapZero.INSTANCE;
            this.bitmaps.put(bitmapContainer, bitmap);
            return bitmap;
        }
    }
}

