/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.sparse;

import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.context.N_CancellingContext;
import crazydev.iccube.cluster.node.facts.sparse.N_HashSparseListOptimizer;
import crazydev.iccube.cluster.node.facts.sparse.N_PaginatedSparseListOptimizer;
import crazydev.iccube.cluster.node.facts.sparse.N_SparseList;
import crazydev.iccube.cluster.node.facts.sparse.N_SparseListMutatedException;
import crazydev.iccube.cluster.node.facts.sparse.N_SparseListOptimizer;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.olap.index.bitmap.facts.concise.OlapConciseBitmapArrayGuts;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class N_PaginatedSparseList
extends N_SparseList {
    public static final int BITS_1024 = 10;
    public static final int BITS_32 = 5;
    private static final long OPTIMIZE_MIN_COST = 2048L;
    private final int bits;
    private final int mask;
    private int[][][] bitmapPages;

    public N_PaginatedSparseList(int sizeMax, int bits) {
        this(new int[1][][], sizeMax, bits);
    }

    private N_PaginatedSparseList(int[][][] bitmapPages, int sizeMax, int bits) {
        super(sizeMax);
        this.bitmapPages = bitmapPages;
        this.bits = bits;
        this.mask = (1 << bits) - 1;
    }

    @Override
    public String getOptimizeInfo() {
        return "page/" + this.getSizeMax() + "/" + this.bits;
    }

    public int getBits() {
        return this.bits;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (int pp = 0; pp < this.bitmapPages.length; ++pp) {
            int[][] page = this.bitmapPages[pp];
            if (page == null) continue;
            for (int bb = 0; bb < page.length; ++bb) {
                if (page[bb] == null) continue;
                ++size;
            }
        }
        return size;
    }

    @Override
    @Nullable
    protected int[] doGet(int index) {
        int pageIndex = index >> this.bits;
        int pageOffset = index & this.mask;
        if (pageIndex >= this.bitmapPages.length) {
            return null;
        }
        int[][] page = this.bitmapPages[pageIndex];
        if (page == null) {
            return null;
        }
        if (pageOffset < page.length) {
            return page[pageOffset];
        }
        return null;
    }

    @Override
    protected void doSet(int index, int[] value) {
        Object page;
        int pageIndex = index >> this.bits;
        int pageOffset = index & this.mask;
        if (pageIndex >= this.bitmapPages.length) {
            this.ensureBitmapPages(pageIndex);
        }
        if ((page = this.bitmapPages[pageIndex]) == null) {
            int[][] nArrayArray = new int[1 << this.bits][];
            this.bitmapPages[pageIndex] = nArrayArray;
            page = nArrayArray;
        }
        if (pageOffset < ((int[][])page).length) {
            page[pageOffset] = value;
            return;
        }
        int[][] page_ = new int[1 << this.bits][];
        System.arraycopy(page, 0, page_, 0, ((int[][])page).length);
        page_[pageOffset] = value;
        this.bitmapPages[pageIndex] = page_;
    }

    private void ensureBitmapPages(int pageIndex) {
        if (pageIndex >= this.bitmapPages.length) {
            int[][][] bitmapPages_ = new int[pageIndex + 1][][];
            System.arraycopy(this.bitmapPages, 0, bitmapPages_, 0, this.bitmapPages.length);
            this.bitmapPages = bitmapPages_;
        }
    }

    @Override
    public N_SparseList copyTo(N_CancellingContext context, N_SparseList other) {
        N_SparseList other_ = other;
        int indexOffset = 0;
        for (int pp = 0; pp < this.bitmapPages.length && !context.isCancelling(); ++pp) {
            int[][] page = this.bitmapPages[pp];
            if (page != null) {
                for (int bb = 0; bb < page.length; ++bb) {
                    int[] bitmap = page[bb];
                    if (bitmap == null) continue;
                    try {
                        other_.set(indexOffset + bb, bitmap);
                        continue;
                    }
                    catch (N_SparseListMutatedException ex) {
                        other_ = ex.getTo();
                    }
                }
            }
            indexOffset += 1 << this.bits;
        }
        return other_;
    }

    @Override
    public void compact(N_CancellingContext context, boolean withBitmaps) {
        for (int pp = 0; pp < this.bitmapPages.length && !context.isCancelling(); ++pp) {
            int[][] page = this.bitmapPages[pp];
            if (page == null) continue;
            int indexMax = -1;
            for (int bb = 0; bb < page.length; ++bb) {
                OlapConciseBitmapArrayGuts guts;
                int[] bitmap = page[bb];
                if (bitmap == null) continue;
                indexMax = bb;
                if (!withBitmaps || !(guts = new OlapConciseBitmapArrayGuts(bitmap)).trimToSize()) continue;
                page[bb] = guts.words();
            }
            int pageLen = indexMax + 1;
            if (pageLen >= page.length) continue;
            int[][] page_ = new int[pageLen][];
            System.arraycopy(page, 0, page_, 0, pageLen);
            this.bitmapPages[pp] = page_;
        }
    }

    @Override
    public N_SparseList optimize(N_CancellingContext context, String facts, String partition) {
        try {
            return this.unsafeOptimize(context, facts, partition);
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER.warn((Object)("[builder] unexpected error while optimizing [" + facts + "] [" + partition + "]"), (Throwable)ex);
            return this;
        }
    }

    private N_SparseList unsafeOptimize(N_CancellingContext context, String facts, String partition) {
        long cost = N_PaginatedSparseListOptimizer.computeCost(this.bitmapPages);
        if (cost < 2048L) {
            return this;
        }
        int sizeMax = this.getSizeMax();
        int size = this.getSize();
        ArrayList<N_SparseListOptimizer> optimizers = new ArrayList<N_SparseListOptimizer>();
        if (size < 1088) {
            optimizers.add(new N_HashSparseListOptimizer(sizeMax, size));
        }
        if (this.bits != 10) {
            optimizers.add(new N_PaginatedSparseListOptimizer(sizeMax, size, 10));
        }
        if (!optimizers.isEmpty()) {
            N_SparseListOptimizer[] optimizers_ = optimizers.toArray(new N_SparseListOptimizer[optimizers.size()]);
            int indexOffset = 0;
            for (int pp = 0; pp < this.bitmapPages.length; ++pp) {
                Object page = this.bitmapPages[pp];
                if (page != null) {
                    for (int bb = 0; bb < ((Object)page).length; ++bb) {
                        Object bitmap = page[bb];
                        if (bitmap == null) continue;
                        for (int oo = 0; oo < optimizers_.length; ++oo) {
                            N_SparseListOptimizer optimizer = optimizers_[oo];
                            optimizer.addIndex(indexOffset + bb);
                        }
                    }
                }
                indexOffset += 1 << this.bits;
            }
        }
        N_SparseListOptimizer bestOptimizer = null;
        long bestOptimizerCost = cost;
        for (N_SparseListOptimizer optimizer : optimizers) {
            long optimizerCost = optimizer.computeCost();
            if (optimizerCost >= bestOptimizerCost) continue;
            bestOptimizer = optimizer;
            bestOptimizerCost = optimizerCost;
        }
        if (bestOptimizer != null) {
            N_SparseList optimized = bestOptimizer.optimize(context, this);
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)("[builder] optimized [" + facts + "] [" + partition + "] from [" + this.getOptimizeInfo() + "][" + cost + "] to [" + optimized.getOptimizeInfo() + "][" + bestOptimizerCost + "]"));
            }
            return optimized;
        }
        return this;
    }

    public static N_PaginatedSparseList restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        int sizeMax = in.readInt();
        int bits = in.readInt();
        int len = in.readInt();
        int[][][] bitmapPages = new int[len][][];
        for (int pp = 0; pp < bitmapPages.length && !context.isCancelling(); ++pp) {
            int pageLen = in.readInt();
            if (pageLen <= -1) continue;
            int[][] page = new int[pageLen][];
            for (int bb = 0; bb < page.length && !context.isCancelling(); ++bb) {
                int bitmapLen = in.readInt();
                if (bitmapLen <= -1) continue;
                int[] bitmap = new int[bitmapLen];
                in.readInts(bitmap);
                page[bb] = bitmap;
            }
            bitmapPages[pp] = page;
        }
        return new N_PaginatedSparseList(bitmapPages, sizeMax, bits);
    }
}

