/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.sparse;

import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.context.N_CancellingContext;
import crazydev.iccube.cluster.node.facts.sparse.N_IntObjectHashMap;
import crazydev.iccube.cluster.node.facts.sparse.N_PaginatedSparseList;
import crazydev.iccube.cluster.node.facts.sparse.N_SparseList;
import crazydev.iccube.cluster.node.facts.sparse.N_SparseListMutatedException;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class N_HashSparseList
extends N_SparseList {
    private final N_IntObjectHashMap<int[]> bitmaps;

    public N_HashSparseList(int sizeMax) {
        this(new N_IntObjectHashMap<int[]>(), sizeMax);
    }

    private N_HashSparseList(N_IntObjectHashMap<int[]> bitmaps, int sizeMax) {
        super(sizeMax);
        this.bitmaps = bitmaps;
    }

    @Override
    public String getOptimizeInfo() {
        return "hash/" + this.getSizeMax() + "/" + this.getSize();
    }

    @Override
    public int getSize() {
        return this.bitmaps.size();
    }

    @Override
    @Nullable
    protected int[] doGet(int index) {
        return (int[])this.bitmaps.get(index);
    }

    @Override
    protected void doSet(int index, int[] value) throws N_SparseListMutatedException {
        this.bitmaps.put(index, value);
        if (this.bitmaps.size() >= 1088) {
            N_SparseList other = new N_PaginatedSparseList(this.getSizeMax(), 10);
            other = this.copyTo(N_CancellingContext.NOOP, other);
            throw new N_SparseListMutatedException(this, other);
        }
    }

    @Override
    public N_SparseList copyTo(N_CancellingContext context, N_SparseList other) {
        N_SparseList[] other_ = new N_SparseList[]{other};
        for (Int2ObjectMap.Entry entry : this.bitmaps.int2ObjectEntrySet()) {
            if (context.isCancelling()) break;
            int[] bitmap = (int[])entry.getValue();
            if (bitmap == null) continue;
            try {
                other_[0].set(entry.getIntKey(), bitmap);
            }
            catch (N_SparseListMutatedException ex) {
                other_[0] = ex.getTo();
            }
        }
        return other_[0];
    }

    @Override
    public void compact(N_CancellingContext context, boolean withBitmaps) {
    }

    @Override
    public N_SparseList optimize(N_CancellingContext context, String facts, String partition) {
        return this;
    }

    public static N_HashSparseList restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        N_IntObjectHashMap<int[]> bitmaps = new N_IntObjectHashMap<int[]>();
        int sizeMax = in.readInt();
        int size = in.readInt();
        for (int ii = 0; ii < size && !context.isCancelling(); ++ii) {
            int index = in.readInt();
            int wordCount = in.readInt();
            if (wordCount <= -1) continue;
            int[] words = new int[wordCount];
            in.readInts(words);
            bitmaps.put(index, words);
        }
        return new N_HashSparseList(bitmaps, sizeMax);
    }
}

