/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.roaring.mmap;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.facts.roaring.N_FactPageImmutableContainersI;
import crazydev.iccube.cluster.node.facts.roaring.mmap.N_FactPageRoaringBitmapFileConfiguration;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.cluster.shared.schema.S_HierarchyDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.MappeableContainer;

public class N_FactPageFileImmutableContainers
implements N_FactPageImmutableContainersI {
    private static final long MAX_MAGIC_NUMBER = 0x100000000L;
    private static long SHALLOW_SIZE_OF = -1L;
    private final S_SchemaDef schemaDef;
    private final String nameForStats;
    private final int hierarchyIdx;
    private final N_FactPageRoaringBitmapFileConfiguration configuration;
    private final String filePath;
    @Nullable
    private FileChannel appender;
    @Nullable
    private MemorySegment mmap;

    public N_FactPageFileImmutableContainers(S_SchemaDef schemaDef, String nameForStats, int hierarchyIdx, N_FactPageRoaringBitmapFileConfiguration configuration, boolean openForAppending) {
        this.schemaDef = schemaDef;
        this.nameForStats = nameForStats;
        this.hierarchyIdx = hierarchyIdx;
        this.configuration = configuration;
        this.filePath = configuration.getFilePath(hierarchyIdx);
        if (openForAppending) {
            this.openForAppending(StandardOpenOption.CREATE_NEW);
        }
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        return size;
    }

    public long fileSizeOf() {
        long l;
        block8: {
            FileChannel fileChannel = FileChannel.open(Paths.get(this.filePath, new String[0]), StandardOpenOption.READ);
            try {
                l = fileChannel.size();
                if (fileChannel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException("IO error : file guts-container [" + this.nameForStats + "] hierarchy:" + this.hierarchyIdx + " while opening for file size", ex);
                }
            }
            fileChannel.close();
        }
        return l;
    }

    public void openForAppending(StandardOpenOption createOption) {
        OlapLoggers.BUILDER.debug((Object)("[facts] file guts-container [" + this.nameForStats + "] hierarchy:" + this.hierarchyIdx + " APPENDING"));
        this.closeMemoryMapping();
        try {
            this.appender = FileChannel.open(Paths.get(this.filePath, new String[0]), createOption, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        catch (IOException ex) {
            throw new RuntimeException("IO error : file guts-container [" + this.nameForStats + "] hierarchy:" + this.hierarchyIdx + " while opening for appending", ex);
        }
    }

    public void memoryMapForReading() {
        OlapLoggers.BUILDER.debug((Object)("[facts] file guts-container [" + this.nameForStats + "] hierarchy:" + this.hierarchyIdx + " READING"));
        this.closeAppender();
        try (FileChannel fileChannel = FileChannel.open(Paths.get(this.filePath, new String[0]), StandardOpenOption.READ);){
            this.mmap = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size(), Arena.ofAuto());
        }
        catch (IOException ex) {
            throw new RuntimeException("IO error : file guts-container [" + this.nameForStats + "] hierarchy:" + this.hierarchyIdx + " while memory mapping for reading", ex);
        }
    }

    public void cleanupResource(OlapFileCleaner fileCleaner) {
        OlapLoggers.BUILDER.info((Object)("[facts] file guts-container [" + this.nameForStats + "] hierarchy:" + this.hierarchyIdx + " CLEANUP"));
        this.closeMemoryMapping();
        this.closeAppender();
        this.deleteFile(fileCleaner);
    }

    @Override
    public int add(byte[] container) {
        FileChannel fc = this.appender;
        if (fc == null) {
            throw new RuntimeException("internal error : file guts-container [" + this.nameForStats + "] unexpected missing appender");
        }
        ByteBuffer buffer = ByteBuffer.wrap(container);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            long pos = fc.size();
            while (buffer.hasRemaining()) {
                fc.write(buffer);
            }
            if (pos >= 0x100000000L) {
                S_HierarchyDef hierarchy = this.schemaDef.lookupHierarchy(this.hierarchyIdx);
                String h = hierarchy != null ? hierarchy.getName() : String.valueOf(this.hierarchyIdx);
                String errorInfo = "[facts] guts-containers [" + this.nameForStats + "] [hierarchy:" + h + "] ";
                String error = errorInfo + " unexpected containers size [" + pos + "]";
                throw new RuntimeException(error);
            }
            return (int)pos;
        }
        catch (IOException ex) {
            throw new RuntimeException("IO error : file guts-container [" + this.nameForStats + "] hierarchy:" + this.hierarchyIdx + " while adding container", ex);
        }
    }

    @Override
    public MappeableContainer getMappeableContainer(int magicNumber) {
        MemorySegment ms = this.mmap;
        if (ms == null) {
            throw new RuntimeException("internal error : file guts-container [" + this.nameForStats + "] unexpected missing mapped buffer");
        }
        long pos = Integer.toUnsignedLong(magicNumber);
        byte s1 = this.mmap.get(ValueLayout.JAVA_BYTE, pos);
        byte s2 = this.mmap.get(ValueLayout.JAVA_BYTE, pos + 1L);
        byte s3 = this.mmap.get(ValueLayout.JAVA_BYTE, pos + 2L);
        char size = (char)(s1 & 0xFF | (s2 & 0xFF) << 8);
        int ordinal = s3 & 0xFF;
        ByteBuffer buffer = ms.asSlice(pos + 3L, size - 3).asByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        return MappeableContainer.build(ordinal, buffer);
    }

    @Override
    public int serializedSizeInBytesAtIndexForStats(int magicNumber) {
        return 0;
    }

    private void closeMemoryMapping() {
        this.mmap = null;
    }

    private void closeAppender() {
        if (this.appender != null) {
            try {
                this.appender.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void deleteFile(OlapFileCleaner fileCleaner) {
        File f = null;
        try {
            f = Paths.get(this.filePath, new String[0]).toFile();
            if (!f.delete()) {
                OlapLoggers.BUILDER.warn((Object)("[facts] file guts-container [" + this.nameForStats + "] hierarchy:" + this.hierarchyIdx + " could not delete [" + f.getAbsolutePath() + "]"));
                fileCleaner.register(f);
            }
        }
        catch (Exception ignored) {
            OlapLoggers.BUILDER.warn((Object)("[facts] file guts-container [" + this.nameForStats + "] hierarchy:" + this.hierarchyIdx + " could not delete [" + (f != null ? f.getAbsolutePath() : this.filePath) + "]"));
            fileCleaner.register(f);
        }
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        MemorySegment ms = this.mmap;
        if (ms == null) {
            S_HierarchyDef hierarchy = this.schemaDef.lookupHierarchy(this.hierarchyIdx);
            String h = hierarchy != null ? hierarchy.getName() : String.valueOf(this.hierarchyIdx);
            String errorInfo = "[facts] guts-containers [" + this.nameForStats + "] [hierarchy:" + h + "] ";
            throw new RuntimeException("internal error : unexpected missing memory mapped file " + errorInfo);
        }
        long size = ms.byteSize();
        out.writeLong(size);
        int bufferSize = 4096;
        for (long offset = 0L; offset < size; offset += 4096L) {
            int chunkSize = (int)Math.min(4096L, size - offset);
            ByteBuffer buffer = ms.asSlice(offset, chunkSize).asByteBuffer();
            out.writeBytes(buffer, chunkSize);
        }
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        int read;
        FileChannel fc = this.appender;
        if (fc == null) {
            S_HierarchyDef hierarchy = this.schemaDef.lookupHierarchy(this.hierarchyIdx);
            String h = hierarchy != null ? hierarchy.getName() : String.valueOf(this.hierarchyIdx);
            String errorInfo = "[facts] guts-containers [" + this.nameForStats + "] [hierarchy:" + h + "] ";
            throw new RuntimeException("internal error : unexpected missing file " + errorInfo);
        }
        byte[] bytes = new byte[4096];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (long bytesToRead = in.readLong(); bytesToRead > 0L; bytesToRead -= (long)read) {
            int toRead = (int)Math.min((long)bytes.length, bytesToRead);
            read = in.read(bytes, 0, toRead);
            buffer.clear();
            buffer.put(bytes, 0, read);
            buffer.flip();
            while (buffer.hasRemaining()) {
                fc.write(buffer);
            }
        }
    }

    public String toString() {
        return this.mmap != null ? "READING" : (this.appender != null ? "APPENDING" : "N/A");
    }
}

