/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.roaring;

import crazydev.common.collection.CdPaginatedIntList;
import crazydev.common.collection.CdPair;
import crazydev.common.collection.TCharArrayList;
import crazydev.iccube.cluster.node.facts.roaring.N_FactPageRoaringMetaContainerReader;
import crazydev.iccube.cluster.node.facts.roaring.N_PointableRoaringArrayDataWriterI;
import crazydev.iccube.cluster.node.facts.sparse.N_IntObjectHashMap;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.Nullable;

public class N_FactPageRoaringMetaContainerWriter {
    private final N_IntObjectHashMap<CdPaginatedIntList> meta = new N_IntObjectHashMap();
    private final S_SchemaDef schemaDef;
    private final int hierarchyIdx;
    private int maxMemberIDX = -1;
    private int minMemberIDX = Integer.MAX_VALUE;
    private int maxBitmapKey = 0;

    public N_FactPageRoaringMetaContainerWriter(S_SchemaDef schemaDef, int hierarchyIdx) {
        this.schemaDef = schemaDef;
        this.hierarchyIdx = hierarchyIdx;
    }

    public N_FactPageRoaringMetaContainerReader toReader(@Nullable N_FactPageRoaringMetaContainerReader existingReader) {
        Int2ObjectOpenHashMap<CdPair<TCharArrayList, IntArrayList>> metaData = N_FactPageRoaringMetaContainerReader.transform(this.meta);
        this.meta.clear();
        this.maxBitmapKey = 0;
        return N_FactPageRoaringMetaContainerReader.build(this.schemaDef, this.hierarchyIdx, metaData, this.minMemberIDX, this.maxMemberIDX, existingReader);
    }

    public long loadingSizeOf() {
        MutableLong size = new MutableLong(this.meta.sizeOf(false));
        this.meta.values().forEach(t -> size.add(t.sizeOf()));
        return size.longValue();
    }

    public N_PointableRoaringArrayDataWriterI getForWriteMemberMeta(int memberIdx) {
        return (magicNumber, key) -> this.addImmutableContainer(memberIdx, key, magicNumber);
    }

    private void addImmutableContainer(int memberIdx, char bitmapKey, int immutableMagicNumber) {
        CdPaginatedIntList temp;
        boolean newKey;
        boolean bl = newKey = !this.meta.containsKey(bitmapKey);
        if (newKey) {
            temp = new CdPaginatedIntList();
            this.meta.put(bitmapKey, temp);
            this.maxBitmapKey = Math.max(bitmapKey, this.maxBitmapKey);
        } else {
            temp = (CdPaginatedIntList)this.meta.get(bitmapKey);
        }
        this.maxMemberIDX = Math.max(this.maxMemberIDX, memberIdx);
        this.minMemberIDX = Math.min(this.minMemberIDX, memberIdx);
        temp.add(memberIdx);
        temp.add(immutableMagicNumber);
        if (newKey) {
            this.meta.forEach((key, list) -> {
                if (key + 1 < this.maxBitmapKey) {
                    list.trimToSize();
                }
            });
        }
    }

    public boolean containsMember(int toMemberIdx) {
        for (CdPaginatedIntList list : this.meta.values()) {
            for (int i = 0; i < list.size(); i += 2) {
                int t = list.getInt(i);
                if (t != toMemberIdx) continue;
                return false;
            }
        }
        return true;
    }
}

