/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.roaring;

import crazydev.common.utils.CdPaginatedByteArrayContainer;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.facts.roaring.N_FactPageImmutableContainersI;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.cluster.shared.schema.S_HierarchyDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.roaringbitmap.buffer.MappeableContainer;

public class N_FactPageRamImmutableContainers
extends CdPaginatedByteArrayContainer
implements N_FactPageImmutableContainersI {
    private static final int PAGE_SIZE_POS = 17;
    private final S_SchemaDef schemaDef;
    private final String nameForStats;
    private final int hierarchyIdx;

    public N_FactPageRamImmutableContainers(S_SchemaDef schemaDef, String nameForStats, int hierarchyIdx) {
        super(17);
        this.schemaDef = schemaDef;
        this.nameForStats = nameForStats;
        this.hierarchyIdx = hierarchyIdx;
    }

    protected String getErrorInfo() {
        S_HierarchyDef hierarchy = this.schemaDef.lookupHierarchy(this.hierarchyIdx);
        String h = hierarchy != null ? hierarchy.getName() : String.valueOf(this.hierarchyIdx);
        return "[facts] guts-containers [" + this.nameForStats + "] [hierarchy:" + h + "] ";
    }

    @Override
    public MappeableContainer getMappeableContainer(int magicNumber) {
        int page = this.getPage(magicNumber);
        int posInPage = this.getPosInPage(magicNumber);
        byte[] array = (byte[])this.bytes.get(page);
        char size = (char)(array[posInPage] & 0xFF | (array[posInPage + 1] & 0xFF) << 8);
        int ordinal = array[posInPage + 2] & 0xFF;
        ByteBuffer buffer = ByteBuffer.wrap(array, posInPage + 3, size - 3).slice().order(ByteOrder.LITTLE_ENDIAN);
        return MappeableContainer.build(ordinal, buffer);
    }

    @Override
    public int serializedSizeInBytesAtIndexForStats(int magicNumber) {
        int page = this.getPage(magicNumber);
        int posInPage = this.getPosInPage(magicNumber);
        byte[] array = (byte[])this.bytes.get(page);
        return (char)(array[posInPage] & 0xFF | (array[posInPage + 1] & 0xFF) << 8);
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.pageBitPos);
        out.writeInt(this.bytes.size());
        for (byte[] bits : this.bytes) {
            if (bits != null) {
                out.writeInt(bits.length);
                out.writeBytes(bits);
                continue;
            }
            out.writeInt(-1);
        }
        out.writeInt(this.currentPos.size());
        for (Integer cPos : this.currentPos) {
            out.writeInt(cPos);
        }
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        int ii;
        int pageBitPosR = in.readInt();
        if (pageBitPosR != this.pageBitPos) {
            throw new RuntimeException("internal error : unexpected page-bit-pos [" + pageBitPosR + "][" + this.pageBitPos + "]");
        }
        int bytesC = in.readInt();
        for (ii = 0; ii < bytesC; ++ii) {
            int len = in.readInt();
            if (len != -1) {
                byte[] bits = new byte[len];
                in.readBytes(bits);
                this.bytes.add(bits);
                continue;
            }
            this.bytes.add(null);
        }
        this.bytes.trimToSize();
        int currentPosC = in.readInt();
        for (ii = 0; ii < currentPosC; ++ii) {
            this.currentPos.add(in.readInt());
        }
        this.currentPos.trimToSize();
    }
}

