/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.facts.N_AggregatorHelper;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.member.OlapMeasureVectorMember;
import crazydev.iccube.olap.entity.scalar.OlapCellMeasureVectorScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class N_MeasureVectorTupleAggregatorHelper
extends N_AggregatorHelper {
    private final N_MdxRequestContext context;
    private final GFContext gfContext;
    private final S_FactTupleDef tupleDef;
    private final S_MeasureRef[] measureRefs;
    private final OlapAggregationType aggregationType;
    @Nullable
    private final S_TupleDimensionalityDef overwrittenHierarchies;
    @Nullable
    private final S_VisualTotalsDef visualTotals;
    @Nullable
    private final List<S_RequestSubCubeDef> subCubes;
    private final OlapMeasureVectorMember measure;
    @Nullable
    private S_MeasureDef[] measureDefs;

    public N_MeasureVectorTupleAggregatorHelper(N_MdxRequestContext context, GFContext gfContext, N_MeasureGroup measureGroup, S_FactTupleDef tupleDef, OlapMeasureVectorMember measure, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        super(measureGroup);
        this.context = context;
        this.gfContext = gfContext;
        this.tupleDef = tupleDef;
        this.measureRefs = measure.getClusterRefs();
        this.aggregationType = measure.getHierarchyAggregationType();
        if (this.aggregationType != OlapAggregationType.SUM) {
            throw new RuntimeException("internal error: inconsistent measures-vector processing [" + this.aggregationType.name() + "]");
        }
        this.overwrittenHierarchies = overwrittenHierarchies;
        this.visualTotals = visualTotals;
        this.subCubes = subCubes;
        this.measure = measure;
    }

    @Override
    public boolean isDrillthroughActive() {
        return this.context.isDrillthroughActive();
    }

    @Override
    public OlapAggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Override
    public String getMeasureName() {
        return "MeasuresVector-" + this.measureGroup.getMeasureGroupName();
    }

    @Override
    public boolean hasNulls() {
        boolean hasNulls = this.measureGroup.hasNulls();
        return hasNulls;
    }

    @Override
    public OlapScalarEntity aggregate(OlapAggregationType aggregationType) {
        S_MeasureDef[] measureDefs = new S_MeasureDef[this.measureRefs.length];
        OlapAggregationType[] aggregationTypes = new OlapAggregationType[this.measureRefs.length];
        boolean requireEmptyZeroProcessing = false;
        for (int ii = 0; ii < this.measureRefs.length; ++ii) {
            S_MeasureDef measureDef;
            S_MeasureRef measureRef = this.measureRefs[ii];
            measureDefs[ii] = measureDef = this.measureGroup.resolveMeasure(measureRef);
            aggregationTypes[ii] = measureDef.getHierarchyAggregationType();
            requireEmptyZeroProcessing |= measureDef.isEmptyIsZero();
        }
        if (requireEmptyZeroProcessing) {
            this.measureDefs = measureDefs;
        }
        OlapScalarEntity res = this.measureGroup.aggregateTuple(this.context, this.gfContext, this.tupleDef, this.measure, this.measureRefs, measureDefs, aggregationTypes, this.overwrittenHierarchies, this.visualTotals, this.subCubes);
        return res;
    }

    @Override
    public long cardinality() {
        long cardinality = this.measureGroup.cardinality(this.context, this.tupleDef, this.overwrittenHierarchies, this.visualTotals, this.subCubes);
        return cardinality;
    }

    @Override
    public boolean isNoEmpty() {
        boolean noEmpty = this.measureGroup.isNoEmpty(this.context, this.tupleDef, this.overwrittenHierarchies, this.visualTotals, this.subCubes);
        return noEmpty;
    }

    @Override
    public OlapScalarEntity toEmptyZeroIfNeeded(OlapScalarEntity scalar) {
        if (this.measureDefs != null && scalar instanceof OlapCellMeasureVectorScalarEntity) {
            OlapCellMeasureVectorScalarEntity entities = (OlapCellMeasureVectorScalarEntity)scalar;
            scalar = entities.toEmptyZeroIfNeeded(this.measureDefs);
        }
        return scalar;
    }
}

