/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.context.N_FastCrossjoinContext;
import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.context.N_SetEvaluatorContext;
import crazydev.iccube.cluster.node.facts.FastNoEmptyFactory;
import crazydev.iccube.cluster.node.facts.N_AggregatorHelper;
import crazydev.iccube.cluster.node.facts.N_DistinctCountTransformer;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_FastCrossjoinAndTorTupleRoaring;
import crazydev.iccube.cluster.node.facts.N_IFastNoEmpty;
import crazydev.iccube.cluster.node.facts.N_MeasureVectorTupleAggregatorHelper;
import crazydev.iccube.cluster.node.facts.N_PartitionedMeasureGroup;
import crazydev.iccube.cluster.node.facts.N_RegularMeasureGroup;
import crazydev.iccube.cluster.node.facts.N_RegularTupleAggregatorHelper;
import crazydev.iccube.cluster.node.schema.N_BuildFactContext;
import crazydev.iccube.cluster.node.schema.N_BuildSchemaContext;
import crazydev.iccube.cluster.node.schema.N_FastCj_Cache;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextKind;
import crazydev.iccube.cluster.shared.schema.S_CubeDef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_FactTuplesDef;
import crazydev.iccube.cluster.shared.schema.S_HierarchyDimensionality;
import crazydev.iccube.cluster.shared.schema.S_HollowUpdate;
import crazydev.iccube.cluster.shared.schema.S_IncrLoadDimensionUpdateDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.olapiterator.fastcj.CjBitmapHelper;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMeasureVectorMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.facts.aggregation.OlapFactsEntityAggregators;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapOrTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapAggregation;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapCollector;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.IntConsumer;

public abstract class N_MeasureGroup {
    protected final S_SchemaDef schemaDef;
    protected final S_CubeDef cubeDef;
    protected final S_MeasureGroupDef measureGroupDef;
    private final S_BuildSchemaContextKind buildMode;
    @Nullable
    private S_HierarchyDimensionality indexingHierarchies;

    protected N_MeasureGroup(S_BuildSchemaContextKind buildMode, S_SchemaDef schemaDef, S_CubeDef cubeDef, S_MeasureGroupDef measureGroupDef) {
        this.buildMode = buildMode;
        this.schemaDef = schemaDef;
        this.cubeDef = cubeDef;
        this.measureGroupDef = measureGroupDef;
    }

    public static N_MeasureGroup create(S_BuildSchemaContextKind buildMode, S_SchemaDef schemaDef, S_CubeDef cubeDef, S_MeasureGroupDef measureGroupDef) {
        OlapPartitioningType partitionType = schemaDef.isFactPartitioningActive() ? measureGroupDef.getPartitionType() : OlapPartitioningType.NONE;
        switch (partitionType) {
            case NONE: {
                return new N_RegularMeasureGroup(buildMode, schemaDef, cubeDef, measureGroupDef);
            }
            case DATA_TABLE_DEFINED: 
            case OLAP_LEVEL_DEFINED: {
                return new N_PartitionedMeasureGroup(buildMode, schemaDef, cubeDef, measureGroupDef);
            }
        }
        throw new RuntimeException("internal error: [" + schemaDef.getName() + "] [" + measureGroupDef.getName() + "] unexpected partition type [" + String.valueOf((Object)partitionType) + "]");
    }

    public abstract void cleanupResources(OlapFileCleaner var1);

    public abstract void savePartitionsContent(N_BackupContext var1, OlapEngineBackupConfiguration var2, File var3) throws IOException;

    public int restorePartitionContent(N_RestoreContext context, OlapEngineBackupConfiguration configuration, File dir, int backupID, String nameForStats) throws IOException {
        N_FactPage factPage = this.getFactPage(backupID, nameForStats);
        factPage.restore(context, configuration, dir);
        return factPage.getNumberOfRows();
    }

    protected abstract N_FactPage getFactPage(int var1, String var2);

    public abstract void clearOnIncrLoadFullReload(OlapFileCleaner var1);

    public abstract void unloadPartitions(OlapFileCleaner var1, List<S_FactPageRef> var2);

    public abstract void unloadMeasureGroup(OlapFileCleaner var1);

    public abstract void adoptPartitions(OlapFileCleaner var1, N_MeasureGroup var2, @Nullable S_FactPageRef var3, S_FactPageRef var4);

    protected void preValidateAdoptPartition(@Nullable S_FactPageRef partition, @Nullable N_FactPage factPage, S_FactPageRef loadedPartition, @Nullable N_FactPage loadedFactPage) {
        if (partition == null) {
            if (factPage != null) {
                throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent adopt partition [" + this.getName() + "] [" + factPage.getName() + "]");
            }
        } else {
            if (factPage == null) {
                throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent adopt partition [" + this.getName() + "] [" + String.valueOf(partition) + "]");
            }
            if (!factPage.getRef().equals(partition)) {
                throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent adopt partition [" + this.getName() + "] [" + String.valueOf(factPage.getRef()) + "] [" + String.valueOf(partition) + "]");
            }
        }
        if (loadedFactPage == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent adopt partition [" + this.getName() + "] [" + String.valueOf(loadedPartition) + "]");
        }
        if (!loadedFactPage.getRef().equals(loadedPartition)) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] inconsistent adopt partition [" + this.getName() + "] [" + String.valueOf(loadedFactPage.getRef()) + "] [" + String.valueOf(loadedPartition) + "]");
        }
    }

    public abstract void getInformationForPerformanceTests(OlapSchemaInformationForTests var1, S_FactPageRef var2);

    public abstract void dumpIndex(FileOutputStream var1, OlapSchemaDumpIndexHierarchies var2, S_FactPageRef var3) throws IOException;

    public abstract void createPartitionStats(OlapStatsContext var1, OlapFactsLevelsBitmapsStats var2, List<OlapFactsPartitionStats> var3, S_FactPageRef var4, Set<OlapDimension> var5);

    public abstract void createIncrLoadPartitionStats(List<OlapFactsPartitionStats> var1, S_FactPageRef var2);

    public abstract void onSchemaPartitionsLoaded();

    public abstract void onSchemaPartitionsLoadedOnError(OlapFileCleaner var1);

    public boolean isLevelPartitioned() {
        OlapPartitioningType partitionType = this.measureGroupDef.getPartitionType();
        return partitionType == OlapPartitioningType.OLAP_LEVEL_DEFINED;
    }

    public IOlapFactListFactory getFactsColumnListFactory() {
        return this.schemaDef.getFactsColumnListFactory();
    }

    public S_FactBitmapContainerFactory getFactsBitmapContainerFactory() {
        return this.schemaDef.getFactsBitmapContainerFactory();
    }

    public String getName() {
        return this.measureGroupDef.getName();
    }

    public String getMeasureGroupName() {
        return this.measureGroupDef.getMeasureGroupName();
    }

    public String getCubeName() {
        return this.cubeDef.getName();
    }

    public String getSchemaName() {
        return this.schemaDef.getName();
    }

    public boolean isIndexingHierarchy(int hierarchyIndex) {
        if (this.indexingHierarchies == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] facts [" + this.getName() + "] missing indexing-hierarchies");
        }
        boolean indexing = this.indexingHierarchies.hasHierarchy(hierarchyIndex);
        return indexing;
    }

    public S_MeasureDef resolveMeasure(S_MeasureRef measureRef) {
        return this.measureGroupDef.resolveMeasure(measureRef);
    }

    public abstract N_FactPage createFactPage(N_BuildFactContext var1, S_CubeRef var2, S_MeasureGroupRef var3, S_FactPageRef var4, boolean var5, int var6, String var7);

    public abstract N_FactPage getFactPage(S_CubeRef var1, S_MeasureGroupRef var2, S_FactPageRef var3);

    public abstract N_FactPage getM2MFactPage();

    public void onDimensionChanged(N_BuildSchemaContext context, S_IncrLoadDimensionUpdateDef incrLoadUpdate, S_HollowUpdate hollowUpdate) {
        this.schemaDef.resizeDimension(context, incrLoadUpdate);
        this.doOnDimensionChanged(context, hollowUpdate);
    }

    protected abstract void doOnDimensionChanged(N_BuildSchemaContext var1, S_HollowUpdate var2);

    public abstract void onTableRowsProcessingCompleted(N_BuildSchemaContext var1, S_FactPageRef var2);

    public final void onProcessFactsCompleted(N_BuildSchemaContext context, S_HierarchyDimensionality indexingHierarchies) {
        this.indexingHierarchies = indexingHierarchies;
        this.doOnProcessFactsCompleted(context);
    }

    protected abstract void doOnProcessFactsCompleted(N_BuildSchemaContext var1);

    public final void onIncrLoadProcessFactsCompleted(N_BuildSchemaContext context) {
        this.doOnIncrLoadProcessFactsCompleted(context);
    }

    protected abstract void doOnIncrLoadProcessFactsCompleted(N_BuildSchemaContext var1);

    protected void performDistinctCountProcessing(N_BuildSchemaContext context, List<N_FactPage> factPages) {
        boolean performDistinctCount = !this.schemaDef.isIncrLoadActive();
        OlapLoggers.BUILDER.info((Object)("[facts] distinct count processing [" + performDistinctCount + "] for [" + this.getName() + "] for schema [" + this.getSchemaName() + "]"));
        if (performDistinctCount) {
            String schema = this.schemaDef.getName();
            String cube = this.cubeDef.getName();
            String facts = this.measureGroupDef.getName();
            String info = schema + " : " + cube + " : " + facts;
            OlapFileCleaner fileCleaner = context.getFileCleaner();
            N_DistinctCountTransformer.apply(context, fileCleaner, info, factPages);
        }
    }

    public abstract OlapScalarEntityFactColumn[] factsColumnForTests__();

    public abstract boolean measureHasNullsInFactColumns(OlapMeasureMember var1);

    public abstract String sizeInRows();

    public abstract int sizeInRowsEx();

    public abstract int partitionCount();

    public abstract boolean hasNulls();

    public abstract boolean hasNulls(S_MeasureRef var1);

    public IOlapIteratorFilter<OlapMember> getFastNonEmptyFilter(N_MdxRequestContext context, GFContext gfContext, S_FactTupleDef tupleDef, OlapMeasureMember measure, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        N_RegularTupleAggregatorHelper helper = new N_RegularTupleAggregatorHelper(context, gfContext, this, tupleDef, measure, overwrittenHierarchies, visualTotals, subCubes);
        return helper.getFastNonEmptyFilter();
    }

    public OlapScalarEntity evalTuple(N_MdxRequestContext context, GFContext gfContext, S_FactTupleDef tupleDef, OlapMeasureMember measure, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        if (!(measure instanceof OlapMeasureVectorMember)) {
            N_RegularTupleAggregatorHelper helper = new N_RegularTupleAggregatorHelper(context, gfContext, this, tupleDef, measure, overwrittenHierarchies, visualTotals, subCubes);
            OlapFactsEntityAggregators.OlapFactsEntityAggregator aggregator = OlapFactsEntityAggregators.regularEntityAggregator(((N_AggregatorHelper)helper).getAggregationType());
            OlapScalarEntity val = aggregator.aggregate(helper);
            return val;
        }
        OlapMeasureVectorMember vectorMember = (OlapMeasureVectorMember)measure;
        N_MeasureVectorTupleAggregatorHelper helper = new N_MeasureVectorTupleAggregatorHelper(context, gfContext, this, tupleDef, vectorMember, overwrittenHierarchies, visualTotals, subCubes);
        OlapFactsEntityAggregators.OlapFactsEntityAggregator aggregator = OlapFactsEntityAggregators.measureVectorEntityAggregator();
        OlapScalarEntity val = aggregator.aggregate(helper);
        return val;
    }

    public abstract IOlapIteratorFilter<OlapMember> getFastNonEmptyFilter(N_MdxRequestContext var1, GFContext var2, S_FactTupleDef var3, OlapMeasureMember var4, OlapAggregationType var5, S_MeasureDef var6, @Nullable S_TupleDimensionalityDef var7, @Nullable S_VisualTotalsDef var8, @Nullable List<S_RequestSubCubeDef> var9);

    public abstract OlapScalarEntity aggregateTuple(N_MdxRequestContext var1, GFContext var2, S_FactTupleDef var3, OlapMeasureVectorMember var4, S_MeasureRef[] var5, S_MeasureDef[] var6, OlapAggregationType[] var7, @Nullable S_TupleDimensionalityDef var8, @Nullable S_VisualTotalsDef var9, @Nullable List<S_RequestSubCubeDef> var10);

    public abstract OlapScalarEntity aggregateTuple(N_MdxRequestContext var1, GFContext var2, S_FactTupleDef var3, OlapMeasureMember var4, OlapAggregationType var5, S_MeasureDef var6, @Nullable S_TupleDimensionalityDef var7, @Nullable S_VisualTotalsDef var8, @Nullable List<S_RequestSubCubeDef> var9);

    public abstract long cardinality(N_MdxRequestContext var1, S_FactTupleDef var2, @Nullable S_TupleDimensionalityDef var3, @Nullable S_VisualTotalsDef var4, @Nullable List<S_RequestSubCubeDef> var5);

    public abstract boolean isNoEmpty(N_MdxRequestContext var1, S_FactTupleDef var2, @Nullable S_TupleDimensionalityDef var3, @Nullable S_VisualTotalsDef var4, @Nullable List<S_RequestSubCubeDef> var5);

    public abstract List<N_SetEvaluatorContext.FactPageBitmap> createSetSeedBitmap(N_MdxRequestContext var1, S_FactTupleDef var2, OlapBitSet var3, @Nullable S_TupleDimensionalityDef var4, @Nullable S_VisualTotalsDef var5, @Nullable List<S_RequestSubCubeDef> var6);

    public abstract OlapScalarEntity aggregateSetTuple(GFContext var1, N_SetEvaluatorContext var2, S_FactTupleDef var3, OlapAggregationType var4);

    public abstract long cardinalitySetTuple(N_SetEvaluatorContext var1, S_FactTupleDef var2);

    public abstract boolean isNoEmptySetTuple(N_SetEvaluatorContext var1, S_FactTupleDef var2);

    public abstract void fastcrossjoin_preInit(N_FastCrossjoinContext var1, OlapTupleDimensionality var2);

    public abstract CjBitmapHelper.CjBitmap fastcrossjoin_init(N_FastCrossjoinContext var1, OlapTupleDimensionality var2, S_FactTuplesDef var3, @Nullable CjBitmapHelper.CjBitmap var4, @Nullable CjBitmapHelper.CjBitmap var5);

    public abstract CjBitmapHelper.CjTupleListReducer fastcrossjoin_reduce(N_FastCrossjoinContext var1, S_NonEmptyBehavior var2, boolean var3, int var4, CjBitmapHelper.CjTupleListReducer var5, @Nullable N_FastCj_Cache var6, @Nullable CjBitmapHelper.CjTupleListReducer var7);

    public abstract void fast_crossjoin_addToGlobalFilter(N_FastCrossjoinContext var1, S_FactTuplesDef var2, CjBitmapHelper.CjBitmap var3);

    public abstract long getRowCount();

    void fast_crossjoin_addToGlobalFilter(N_FastCrossjoinContext context, N_FactPage factPage, S_FactTuplesDef tuples, CjBitmapHelper.CjBitmap bitmap) {
        IFactsBitmapOrTor orTor = OlapFactsBitmapAggregation.facts_createBitmapOrTor();
        bitmap.forEach(i -> factPage.addForCj((OlapFactsBitmapCollector)orTor, tuples.get(i)));
        if (!orTor.noAdds()) {
            context.addToGlobalFilter(factPage, orTor);
        }
    }

    CjBitmapHelper.CjTupleListReducer fastcrossjoin_reduce(N_FastCrossjoinContext context, S_NonEmptyBehavior nonEmptyBehavior, boolean isfcjReduce, N_FactPage factPage, int setIndex, CjBitmapHelper.CjTupleListReducer tuplesReducer, N_FastCj_Cache filterMembers, CjBitmapHelper.CjTupleListReducer newReducingBitmap) {
        S_FactTuplesDef tuples = context.getInitialSet(setIndex);
        if (tuples.isMemberMeasureList()) {
            return tuplesReducer;
        }
        List<OlapScalarEntityFactColumn> measureCols = context.getFactColumnsWithNulls(nonEmptyBehavior, factPage);
        OlapFactsBitmap globalBitmap = context.getGlobalBitmap(factPage);
        int tupleListCardinality = tuples.get(0).getClusterTupleDimensionality().cardinality();
        N_IFastNoEmpty fastAndtor = N_MeasureGroup.createFastAndTor(context, globalBitmap, measureCols, isfcjReduce, filterMembers, factPage, setIndex, tuples, tupleListCardinality);
        if (isfcjReduce && fastAndtor.isAlwaysZero()) {
            return newReducingBitmap;
        }
        CjBitmapHelper.CjBitmap tupleSetReducer = isfcjReduce ? CjBitmapHelper.createBitmap() : newReducingBitmap.asBitmap();
        tuplesReducer.forEach(bit -> {
            if (isfcjReduce && newReducingBitmap.getBit(bit)) {
                tupleSetReducer.setBit(bit);
            } else {
                fastAndtor.addAndClear(factPage, bit);
                if (fastAndtor.isNoEmpty()) {
                    tupleSetReducer.setBit(bit);
                }
            }
        });
        return tupleSetReducer;
    }

    private static N_IFastNoEmpty createFastAndTor(N_FastCrossjoinContext context, OlapFactsBitmap globalBitmap, List<OlapScalarEntityFactColumn> measureCols, boolean isfcjReduce, N_FastCj_Cache filterMembers, N_FactPage factPage, int setIndex, S_FactTuplesDef tuples, int tupleListCardinality) {
        if (tupleListCardinality == 1) {
            N_FastCrossjoinContext.BitmapCache cache = context.getCacheForTupleBitmaps(factPage, tuples, setIndex);
            return FastNoEmptyFactory.createForFastCrossjoin(factPage, globalBitmap, measureCols, tuples, cache, isfcjReduce ? filterMembers : null);
        }
        return new N_FastCrossjoinAndTorTupleRoaring(tuples::get, factPage, measureCols, globalBitmap, isfcjReduce ? filterMembers : null, tupleListCardinality);
    }

    @NotNull
    CjBitmapHelper.CjBitmap fastcrossjoin_init(N_FastCrossjoinContext context, N_FactPage factPage, OlapTupleDimensionality cjTupleDimensionality, S_FactTuplesDef tuples, @Nullable CjBitmapHelper.CjBitmap tupleFilter, CjBitmapHelper.CjBitmap newReducingBitmap) {
        OlapFactsBitmap globalBitmap = context.getGlobalBitmap(factPage);
        if (globalBitmap.isZero()) {
            return newReducingBitmap;
        }
        CjBitmapHelper.CjBitmap tupleSetReducer = CjBitmapHelper.createBitmap();
        IFactsBitmapAndTor andTor = OlapFactsBitmapAggregation.facts_createBitmapAndTor();
        MutableInt count = new MutableInt(0);
        IntConsumer nonEmptyCalculator = i -> {
            if (newReducingBitmap.getBit(i)) {
                tupleSetReducer.setBit(i);
            } else {
                andTor.add(globalBitmap);
                S_FactTupleDef tuple = tuples.get(i);
                factPage.addForCj((OlapFactsBitmapCollector)andTor, tuple);
                if (andTor.isNoEmpty() || andTor.noAdds()) {
                    count.increment();
                    tupleSetReducer.setBit(i);
                }
                andTor.clear();
            }
        };
        if (tupleFilter == null) {
            int maxInitRow = context.getInitialNonEmptyMaxRow();
            for (int i2 = 0; i2 < tuples.size(); ++i2) {
                if (maxInitRow > 0 && count.intValue() > maxInitRow) {
                    CjBitmapHelper.CjBitmap bitmap = CjBitmapHelper.createBitmapSingleRange(i2, tuples.size());
                    bitmap.or(tupleSetReducer);
                    return bitmap;
                }
                nonEmptyCalculator.accept(i2);
            }
        } else {
            tupleFilter.forEach(nonEmptyCalculator);
        }
        return tupleSetReducer;
    }

    public abstract void fastcrossjoin_initTable(N_FastCrossjoinContext var1);

    public static interface IFactAggregator {
        public OlapScalarEntity asScalarEntity();
    }
}

