/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.common.collection.CdActionEx;
import crazydev.common.collection.CdPair;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdArrayUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchHierarchiesInfoI;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageTasks;
import crazydev.iccube.builder.type.DistinctCountOptimType;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.context.N_CancellingContext;
import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.context.N_OlapContext;
import crazydev.iccube.cluster.node.context.N_OlapContextLoggers;
import crazydev.iccube.cluster.node.facts.FastNoEmptyFactory;
import crazydev.iccube.cluster.node.facts.IFastNoEmpty;
import crazydev.iccube.cluster.node.facts.N_DistinctCountTransformKind;
import crazydev.iccube.cluster.node.facts.N_DistinctCountTransformer;
import crazydev.iccube.cluster.node.facts.N_DistinctCountUniques;
import crazydev.iccube.cluster.node.facts.N_FactBitmapContainer;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsBitmapCount;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsContainer;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsSizeOf;
import crazydev.iccube.cluster.node.facts.N_FactPageColumnLookup;
import crazydev.iccube.cluster.node.facts.N_MdxRequestBitmapCache;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.node.schema.N_BuildFactContext;
import crazydev.iccube.cluster.node.schema.N_BuildSchemaContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.cluster.shared.schema.S_CubeDef;
import crazydev.iccube.cluster.shared.schema.S_FactMemberInfo;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_HierarchyDef;
import crazydev.iccube.cluster.shared.schema.S_HollowUpdate;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureIndex;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.cluster.shared.schema.S_MemberDef;
import crazydev.iccube.cluster.shared.schema.S_MemberDefType;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionality;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.cluster.shared.schema.S_UserMeasureDef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapAbstractIteratorFilter;
import crazydev.iccube.common.IOlapCancellingContext;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.tuple.IOlapMembers;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.facts.IOlapFactPartitionForDrillthrough;
import crazydev.iccube.olap.facts.column.columns.OlapFactMeasureColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapNewCountScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.index.bitmap.OlapBitmapNotStoppableCallback;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapAggregation;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapCollector;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapDT;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapFactory;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapOne;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapVisitor;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBufferOne;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapMeasureStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaFactsBuilderStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class N_FactPage
implements N_FactBitmapContainer,
IOlapFactPartitionForDrillthrough,
Comparable<N_FactPage> {
    private final Object globalLOCK = new Object();
    private final N_MeasureGroup measureGroup;
    private final S_FactPageRef ref;
    private final IOlapFactListFactory factsColumnListFactory;
    private final int backupID;
    private final String nameForStats;
    @Nullable
    private final String nameForDrillthrough;
    private final S_CubeDef cubeDef;
    private final S_MeasureGroupDef measureGroupDef;
    private final OlapScalarEntityFactColumn[] facts;
    private final String[] factMeasureNames;
    private final N_DistinctCountTransformKind[] factsTransformed;
    private final N_FactPageBitmapGutsContainer bitmapContainer;
    private final N_FactPageTasks tasks;
    private final AtomicInteger nextRowId = new AtomicInteger();
    @Nullable
    private N_FactPageColumnLookup lookup;

    public N_FactPage(N_BuildFactContext context, N_MeasureGroup measureGroup, S_FactPageRef ref, IOlapFactListFactory factsColumnListFactory, S_FactBitmapContainerFactory factsBitmapContainerFactory, int backupID, String nameForStats, @Nullable String nameForDrillthrough, S_SchemaDef schemaDef, S_CubeDef cubeDef, S_MeasureGroupDef measureGroupDef, boolean empty) {
        this.measureGroup = measureGroup;
        this.ref = ref;
        this.ref.setReferenced(this);
        this.factsColumnListFactory = factsColumnListFactory;
        this.backupID = backupID;
        this.nameForStats = nameForStats;
        this.nameForDrillthrough = nameForDrillthrough;
        this.cubeDef = cubeDef;
        this.measureGroupDef = measureGroupDef;
        this.bitmapContainer = factsBitmapContainerFactory.createBitmapContainer(context, this, measureGroup, nameForStats, schemaDef);
        List<S_MeasureDef> measures = measureGroupDef.getMeasures();
        this.facts = new OlapScalarEntityFactColumn[measures.size()];
        this.factMeasureNames = new String[measures.size()];
        for (S_MeasureDef measure : measures) {
            OlapScalarEntityFactColumn column;
            if (measure.isAlias()) continue;
            this.facts[measure.getFactsColumnIndex()] = column = this.createColumn(measure);
            this.factMeasureNames[measure.getFactsColumnIndex()] = measure.getName();
        }
        this.factsTransformed = new N_DistinctCountTransformKind[this.facts.length];
        this.tasks = new N_FactPageTasks(context.getConfiguration(), schemaDef, this);
        if (empty) {
            this.onTableRowsProcessingCompleted(context.getSchemaContext());
        }
        OlapLoggers.BUILDER.info((Object)("[facts] created [" + measureGroup.getMeasureGroupName() + "] [" + nameForStats + "] :: @" + System.identityHashCode(this)));
    }

    @Override
    public String getSchemaName() {
        return this.measureGroup.getSchemaName();
    }

    public N_FactPageBitmapGutsContainer getBitmapContainer() {
        return this.bitmapContainer;
    }

    public int getNumberOfFacts() {
        return this.facts.length;
    }

    public OlapScalarEntityFactColumn getFacts(int index) {
        return this.facts[index];
    }

    public IOlapIteratorFilter<OlapMember> getFastNonEmptyFilter(N_MdxRequestContext context, GFContext dtContext, S_FactTupleDef tupleDef, OlapMeasureMember measure, OlapAggregationType aggregationType, S_MeasureDef measureDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        OlapScalarEntityFactColumn measureColumn = this.facts[measure.getMeasureIndex().getFactsColumnIndex()];
        IFactsBitmapAndTor gBitmap = this.createGlobalBitmapFor(context, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
        OlapFactsBitmap bits = gBitmap.noAdds() ? OlapFactsBitmapRoaringBufferOne.INSTANCE : gBitmap.facts_asBitmap();
        List<OlapScalarEntityFactColumn> columnsWithNulls = measureColumn.hasNulls() ? List.of(measureColumn) : Collections.emptyList();
        IFastNoEmpty fastNonEmpty = FastNoEmptyFactory.creatFastNoEmpty(this, columnsWithNulls, bits);
        GFContext eContext = dtContext;
        OlapNameContext nContext = dtContext.getNameContext();
        return new NonEmptyFilter(context, eContext, nContext, this, fastNonEmpty);
    }

    public String getFactMeasureNames(int index) {
        return this.factMeasureNames[index];
    }

    private OlapScalarEntityFactColumn createColumn(S_MeasureDef measure) {
        OlapFactMeasureColumnId id = new OlapFactMeasureColumnId(this.cubeDef.getName(), this.measureGroupDef.getName(), measure);
        OlapAggregationType hierarchyAggregationType = measure.getHierarchyAggregationType();
        OlapBuilderInputType cubeDataType = measure.getCubeDataType();
        OlapBuilderColumnDecorationType cubeDataTypeDecoration = measure.getCubeDataTypeDecoration();
        if (hierarchyAggregationType == OlapAggregationType.COUNT) {
            return new OlapNewCountScalarEntityFactColumn(this.factsColumnListFactory, id, cubeDataType);
        }
        if (cubeDataTypeDecoration == OlapBuilderColumnDecorationType.ARRAY) {
            return cubeDataType.createScalarEntityVectorFactColumn(this.factsColumnListFactory, id);
        }
        return cubeDataType.createScalarEntityFactColumn(this.factsColumnListFactory, id);
    }

    public void cleanupResources(OlapFileCleaner fileCleaner) {
        for (OlapScalarEntityFactColumn fact : this.facts) {
            if (fact == null) continue;
            fact.cleanupResources(fileCleaner);
        }
        this.bitmapContainer.cleanupResources(fileCleaner);
    }

    public S_FactPageRef getRef() {
        return this.ref;
    }

    public int getBackupID() {
        return this.backupID;
    }

    public String getName() {
        return this.ref.toString();
    }

    @Override
    public String getNameForStats() {
        return this.nameForStats;
    }

    public String getMeasureName(int columnIdx) {
        List<S_MeasureDef> measures = this.measureGroupDef.getMeasures();
        S_MeasureDef measure = measures.get(columnIdx);
        return measure.getName();
    }

    public OlapScalarEntityFactColumn getColumn(S_MeasureDef measureDef) {
        S_MeasureDef measureDef_ = this.extractUnderlyingMeasure(measureDef);
        OlapScalarEntityFactColumn column = this.facts[measureDef_.getFactsColumnIndex()];
        if (column == null) {
            S_MeasureIndex index = measureDef.getIndex();
            throw new RuntimeException("internal error: missing facts column for measure [" + measureDef.getName() + "] [" + index.getDefIndex() + "/" + index.getFactsColumnIndex() + "]");
        }
        return column;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private S_MeasureDef extractUnderlyingMeasure(S_MeasureDef measureDef) {
        if (!(measureDef instanceof S_UserMeasureDef)) return measureDef;
        S_UserMeasureDef userMeasureDef = (S_UserMeasureDef)measureDef;
        List<S_MeasureDef> refMeasureDefs = userMeasureDef.getRefMeasureDefs();
        if (refMeasureDefs.size() != 1) throw new RuntimeException("internal error: user defined measure [" + measureDef.getName() + "] with formula not supported");
        return this.extractUnderlyingMeasure(refMeasureDefs.get(0));
    }

    public OlapScalarEntityFactColumn[] getColumns(S_MeasureDef[] measureDefs) {
        OlapScalarEntityFactColumn[] columns = new OlapScalarEntityFactColumn[measureDefs.length];
        for (int ii = 0; ii < measureDefs.length; ++ii) {
            OlapScalarEntityFactColumn column;
            S_MeasureDef measureDef = measureDefs[ii];
            columns[ii] = column = this.getColumn(measureDef);
        }
        return columns;
    }

    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info) {
        this.bitmapContainer.getInformationForPerformanceTests(info);
    }

    public void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies) throws IOException {
        throw new RuntimeException("NOT YET");
    }

    public void createStats(OlapStatsContext context, OlapFactsLevelsBitmapsStats statsPerLevel, List<OlapFactsPartitionStats> partitionsStats, Set<OlapDimension> dimensions__) {
        long rowCount = this.nextRowId.get();
        boolean restoredFromConvertedBackup = this.bitmapContainer.isRestoredFromConvertedBackup();
        N_FactPageBitmapGutsBitmapCount bitmapCount = this.bitmapContainer.getBitmapCount();
        N_FactPageBitmapGutsSizeOf bitmapsRamSize = this.bitmapContainer.sizeOf();
        long metaTemporarySize = this.bitmapContainer.getMetaTemporarySize();
        HashMap<String, String> aggregations = new HashMap<String, String>();
        List<S_MeasureDef> measures = this.measureGroupDef.getMeasures();
        for (S_MeasureDef measure : measures) {
            aggregations.put(measure.getName(), measure.getHierarchyAggregationType().getFriendlyName());
        }
        String partitionId = this.getNameForStats();
        ArrayList<OlapMeasureStats> measuresStats = new ArrayList<OlapMeasureStats>();
        for (OlapScalarEntityFactColumn factColumn : this.facts) {
            if (factColumn == null) continue;
            String name = factColumn.getId().getColumnName();
            String aggregationType = (String)aggregations.get(name);
            String dataType = factColumn.getFactDataType().name();
            String columnType = factColumn.getFriendlyTypeName();
            long ramSize = factColumn.sizeOf();
            long filesSize = factColumn.sizeOfFiles();
            measuresStats.add(new OlapMeasureStats(name, aggregationType == null ? "n/a" : aggregationType, dataType, columnType, ramSize, filesSize, factColumn.hasNulls()));
        }
        partitionsStats.add(new OlapFactsPartitionStats(partitionId, restoredFromConvertedBackup, rowCount, bitmapCount, bitmapsRamSize, measuresStats, metaTemporarySize));
        this.bitmapContainer.createLevelStats(statsPerLevel, dimensions__);
    }

    public void createIncrLoadStats(List<OlapFactsPartitionStats> partitionsStats) {
        String partitionId = this.getNameForStats();
        long rowCount = this.nextRowId.get();
        N_FactPageBitmapGutsBitmapCount bitmapCount = this.bitmapContainer.getBitmapCount();
        N_FactPageBitmapGutsSizeOf bitmapsRamSize = new N_FactPageBitmapGutsSizeOf();
        List<OlapMeasureStats> measuresStats = Collections.emptyList();
        long metaTemporarySize = this.bitmapContainer.getMetaTemporarySize();
        partitionsStats.add(new OlapFactsPartitionStats(partitionId, false, rowCount, bitmapCount, bitmapsRamSize, measuresStats, metaTemporarySize));
    }

    public void addFactsRows(N_CancellingContext context, @Nullable OlapSchemaFactsBuilderStats stats, OlapFactRowAggregationType rowAggregationType, N_FactPageBatchHierarchiesInfoI info) {
        if (context.isCancelling()) {
            return;
        }
        this.doAddFactsRows(context, stats, rowAggregationType, info);
    }

    private void doAddFactsRows(N_CancellingContext context, @Nullable OlapSchemaFactsBuilderStats stats, OlapFactRowAggregationType rowAggregationType, N_FactPageBatchHierarchiesInfoI info) {
        this.tasks.addBatch(context, stats, info);
        this.tasks.process(context, stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDimensionChanged(N_BuildSchemaContext context, N_MeasureGroup measureGroup, S_SchemaDef schemaDef, S_HollowUpdate hollowUpdate) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.bitmapContainer.onDimensionChanged(context, measureGroup, schemaDef, hollowUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableRowsProcessingCompleted(N_BuildSchemaContext context) {
        boolean incrLoad = context.isIncrLoad();
        N_OlapContextLoggers loggers = context.loggers();
        Logger builder = loggers.builder();
        if (builder.isInfoEnabled()) {
            builder.info((Object)("[facts] process rows completed for partition  [" + this.getNameForStats() + "]"));
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            this.onLoadCompleted(context, builder, incrLoad);
        }
    }

    private void onLoadCompleted(N_BuildSchemaContext context, @Nullable Logger logger, boolean incrLoad) {
        int nextRowIdFromBatch;
        if (logger == null) {
            logger = OlapLoggers.BUILDER;
        }
        if (incrLoad) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[facts] incr. load completed [" + this.getNameForStats() + "] :: @" + System.identityHashCode(this)));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("[facts] load completed [" + this.getNameForStats() + "] :: @" + System.identityHashCode(this)));
        }
        if ((nextRowIdFromBatch = this.tasks.onFactsProcessingCompleted()) > 0) {
            if (this.nextRowId.get() > 0 && !incrLoad) {
                throw new RuntimeException("internal error: mix add-rows [" + nextRowIdFromBatch + "] w/ add-row [" + this.nextRowId.get() + "]");
            }
            this.nextRowId.set(nextRowIdFromBatch);
        }
        if (incrLoad) {
            this.bitmapContainer.onIncrLoadCompleted(context);
            return;
        }
        this.bitmapContainer.onLoadCompleted(context);
        if (this.cubeDef.isIncrLoadActive()) {
            return;
        }
        OlapLoggers.BUILDER.info((Object)("[facts] trimming columns for partition [" + this.getNameForStats() + "] [" + this.facts.length + "]"));
        for (OlapScalarEntityFactColumn fact : this.facts) {
            if (fact == null) continue;
            fact.trimToSize();
        }
        OlapLoggers.BUILDER.info((Object)("[facts] compacting index for partition [" + this.getNameForStats() + "]"));
        this.bitmapContainer.compact();
    }

    public boolean hasNulls() {
        for (int ii = 0; ii < this.facts.length; ++ii) {
            OlapScalarEntityFactColumn column = this.facts[ii];
            if (column == null || !column.hasNulls()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNulls(S_MeasureRef measureRef) {
        S_MeasureDef measureDef = this.measureGroupDef.resolveMeasure(measureRef);
        OlapScalarEntityFactColumn column = this.getColumn(measureDef);
        return column.hasNulls();
    }

    @Override
    @Nullable
    public OlapFactsBitmap getForRead(S_MemberDef memberDef) {
        return this.bitmapContainer.getForRead(memberDef.getFactHierIdx(), memberDef.getFactMemberIdx());
    }

    @Override
    public int getNumberOfRows() {
        return this.nextRowId.get();
    }

    public int commitNumberOfRows(int delta) {
        return this.nextRowId.addAndGet(delta);
    }

    @Override
    public boolean isIndexing(S_MemberDef s_memberDef) {
        return this.isIndexingHierarchy(s_memberDef.getFactHierIdx());
    }

    @Override
    public S_MeasureGroupDef getMeasureGroupDef() {
        return this.measureGroupDef;
    }

    public String toString() {
        return this.getName();
    }

    public OlapScalarEntityFactColumn[] getAllColumns() {
        return this.facts;
    }

    public boolean measureHasNullsInFactColumns(OlapMeasureMember measure) {
        return this.dt_getFactColumn(measure).hasNulls();
    }

    public int sizeInRows() {
        return this.nextRowId.get();
    }

    public IFactsBitmapAndTor createGlobalBitmapFor(N_MdxRequestContext requestContext, S_FactTupleDef tupleDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        S_TupleDimensionalityDef visualDimensionality;
        N_MdxRequestBitmapCache bitmapCache = requestContext.getOrCreateBitmapCache(this);
        IFactsBitmapAndTor andTor = OlapFactsBitmapAggregation.facts_createBitmapAndTor(this.nextRowId.get());
        bitmapCache.addToTor(requestContext, andTor, tupleDef.getClusterTupleDimensionality(), overwrittenHierarchies);
        bitmapCache.addToTor(requestContext, andTor, subCubes);
        if (visualTotals != null) {
            visualTotals.addToTor(requestContext, andTor, this);
            visualDimensionality = visualTotals.getDimensionality();
        } else {
            visualDimensionality = null;
        }
        int[] tupleMemberCount = new int[]{0};
        int[] tupleMembersMappedCount = new int[]{0};
        tupleDef.forEach((type, iHierarchyIndex, hierarchyIndex, memberIndex, info) -> {
            if (type.isStandard()) {
                tupleMemberCount[0] = tupleMemberCount[0] + 1;
                if (visualDimensionality != null && visualDimensionality.isIn(hierarchyIndex)) {
                    return;
                }
                OlapFactsBitmap forRead = this.bitmapContainer.getForRead(hierarchyIndex, memberIndex);
                if (forRead != null) {
                    andTor.add(forRead);
                    tupleMembersMappedCount[0] = tupleMembersMappedCount[0] + 1;
                }
            } else if (type.isCategory()) {
                tupleMemberCount[0] = tupleMemberCount[0] + 1;
                if (visualDimensionality != null && visualDimensionality.isIn(hierarchyIndex)) {
                    return;
                }
                OlapFactsBitmap cBitmap = requestContext.getOrCreateCategoryBitmap(this, info.scope, hierarchyIndex, memberIndex, info.cacheId);
                if (cBitmap != null) {
                    andTor.add(cBitmap);
                    tupleMembersMappedCount[0] = tupleMembersMappedCount[0] + 1;
                }
            }
        });
        if (tupleMemberCount[0] > 0 && tupleMembersMappedCount[0] == 0 && bitmapCache.emptyDefaults() && requestContext.getSlicer() == null && requestContext.getSubSelect() == null && visualTotals == null && (subCubes == null || subCubes.isEmpty())) {
            return OlapFactsBitmapAggregation.facts_createBitmapAndTor(this.nextRowId.get());
        }
        return andTor;
    }

    public OlapFactsBitmapVisitor createBitmapVisitor(N_MdxRequestContext requestContext, S_FactTupleDef tupleDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        IFactsBitmapAndTor andTor = this.createGlobalBitmapFor(requestContext, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
        if (andTor.noAdds()) {
            OlapFactsBitmap bitmap = OlapFactsBitmapFactory.facts_createBitmapAllOnes(this.nextRowId.get());
            return bitmap;
        }
        return andTor;
    }

    @Nullable
    public OlapFactsBitmap createSetSeedBitmap(N_MdxRequestContext requestContext, S_FactTupleDef tupleDef, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        IFactsBitmapAndTor andTor = this.createGlobalBitmapFor(requestContext, tupleDef, overwrittenHierarchies, visualTotals, subCubes);
        OlapFactsBitmap bitmap = andTor.noAdds() ? null : andTor.facts_asBitmap();
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getDistinctTransformableColumns() {
        Object object = this.globalLOCK;
        synchronized (object) {
            List<S_MeasureDef> measures = this.measureGroupDef.getMeasures();
            ArrayList<Integer> columns = new ArrayList<Integer>();
            for (int ii = 0; ii < measures.size(); ++ii) {
                if (!this.isDistinctTransformable(ii)) continue;
                columns.add(ii);
            }
            return columns;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDistinctTransformable(int columnIdx) {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.facts[columnIdx] == null) {
                return false;
            }
            List<S_MeasureDef> measures = this.measureGroupDef.getMeasures();
            S_MeasureDef measure = measures.get(columnIdx);
            OlapAggregationType aggregationType = measure.getHierarchyAggregationType();
            DistinctCountOptimType distinctCountOptim = this.cubeDef.getDistinctCountOptimType();
            boolean res = aggregationType == OlapAggregationType.DISTINCT_COUNT && this.facts[columnIdx].shouldTransformToDistinctCount(distinctCountOptim);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllDistincts(N_OlapContext context, N_DistinctCountUniques uniqueFacts, int columnIdx) {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapScalarEntityFactColumn column = this.facts[columnIdx];
            if (column == null) {
                throw new RuntimeException("internal error: missing facts column [" + columnIdx + "]");
            }
            column.addAllDistincts(context, uniqueFacts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CdPair<Long, Long> distinctTransform(N_OlapContext context, OlapFileCleaner fileCleaner, N_DistinctCountUniques uniqueFacts, int columnIdx) {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapScalarEntityFactColumn column = this.facts[columnIdx];
            N_DistinctCountTransformKind[] factsTransformation = new N_DistinctCountTransformKind[1];
            if (column == null) {
                throw new RuntimeException("internal error: missing facts column [" + columnIdx + "]");
            }
            this.facts[columnIdx] = N_DistinctCountTransformer.transformUniqueFacts(context, fileCleaner, factsTransformation, column, uniqueFacts);
            this.factsTransformed[columnIdx] = factsTransformation[0];
            CdPair res = column.isInMemory() ? new CdPair((Object)column.sizeOf(), (Object)this.facts[columnIdx].sizeOf()) : new CdPair((Object)column.sizeOfFiles(), (Object)this.facts[columnIdx].sizeOfFiles());
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(N_BackupContext context, OlapEngineBackupConfiguration configuration, File dir) throws IOException {
        if (context.isCancelling()) {
            return;
        }
        long startMS_ = System.currentTimeMillis();
        OlapLoggers.BACKUP_X.debug((Object)("[backup] saving partition [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "]"));
        long startMS = System.currentTimeMillis();
        OlapLoggers.BACKUP_X.debug((Object)("[backup] saving partition facts [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "] [measure-count:" + this.facts.length + "]"));
        File file = new File(dir, this.backupID + ".icc-facts");
        try (S_BackupOutputStream out = new S_BackupOutputStream(configuration, file);){
            out.writeInt(this.nextRowId.get());
            out.writeInt(-this.facts.length);
            List<S_MeasureDef> measureDefs = this.measureGroupDef.getMeasures();
            OlapLoggers.BACKUP_X.debug((Object)("[backup] saving partition facts [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "] [" + this.facts.length + "] [" + measureDefs.size() + "]"));
            for (int ii = 0; ii < this.facts.length; ++ii) {
                S_MeasureDef measureDef = measureDefs.get(ii);
                if (this.facts[ii] == null) {
                    OlapLoggers.BACKUP_X.debug((Object)("[backup]                measure [" + this.nameForStats + "] [" + ii + "] [" + measureDef.getName() + "] [alias:" + measureDef.isAlias() + "] [ignored]"));
                    continue;
                }
                OlapScalarEntityFactColumn fact = this.facts[ii];
                N_DistinctCountTransformKind transformation = this.factsTransformed[ii];
                OlapLoggers.BACKUP_X.debug((Object)("[backup]                measure [" + this.nameForStats + "] [" + ii + "] [" + measureDef.getName() + "] [alias:" + measureDef.isAlias() + "] [" + fact.getId().toStringForLogs() + "] [" + fact.getFriendlyTypeName() + "] [transformation:" + String.valueOf((Object)transformation) + "]"));
                out.writeInt(transformation != null ? transformation.getBackupUUID() : -1);
                fact.save(context, out);
            }
            if (!context.isCancelling()) {
                out.sync();
            }
        }
        OlapLoggers.BACKUP_X.debug((Object)("[backup] saved partition facts [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "] [ " + CdTimeUtils.formatMillisEx((long)startMS) + " ]"));
        startMS = System.currentTimeMillis();
        OlapLoggers.BACKUP_X.debug((Object)("[backup] saving partition index [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "]"));
        file = new File(dir, this.backupID + ".icc-index");
        out = new S_BackupOutputStream(configuration, file);
        try {
            this.bitmapContainer.save(context, out);
            if (!context.isCancelling()) {
                out.sync();
            }
        }
        finally {
            out.close();
        }
        OlapLoggers.BACKUP_X.debug((Object)("[backup] saved partition index [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "] [ " + CdTimeUtils.formatMillisEx((long)startMS) + " ]"));
        OlapLoggers.BACKUP_X.debug((Object)("[backup] saved partition [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "] [ " + CdTimeUtils.formatMillisEx((long)startMS_) + " ]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(N_RestoreContext context, OlapEngineBackupConfiguration configuration, File dir) throws IOException {
        if (context.isCancelling()) {
            return;
        }
        long startMS_ = System.currentTimeMillis();
        OlapLoggers.BACKUP_X.debug((Object)("[backup] restoring partition [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "]"));
        long startMS = System.currentTimeMillis();
        OlapLoggers.BACKUP_X.debug((Object)("[backup] restoring partition facts [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "]"));
        File file = new File(dir, this.backupID + ".icc-facts");
        S_BackupInputStream in = new S_BackupInputStream(configuration, file);
        try {
            int cc;
            int factsLength;
            this.nextRowId.set(in.readInt());
            this.tasks.restore(this.nextRowId.get());
            if (context.isVersion0()) {
                int hierarchies = in.readInt();
                for (int ii = 0; ii < hierarchies; ++ii) {
                    in.readInt();
                }
            }
            if ((factsLength = Math.abs(cc = in.readInt())) != this.facts.length) {
                throw new RuntimeException("internal error: unexpected column count [" + cc + "] [" + this.facts.length + "]");
            }
            OlapLoggers.BACKUP_X.debug((Object)("[backup] restoring partition facts [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "] [measures:" + cc + "]"));
            List<S_MeasureDef> measureDefs = this.measureGroupDef.getMeasures();
            if (cc < 0) {
                for (int ii = 0; ii < this.facts.length; ++ii) {
                    N_DistinctCountTransformKind transformation;
                    S_MeasureDef measureDef = measureDefs.get(ii);
                    if (this.facts[ii] == null) {
                        OlapLoggers.BACKUP_X.debug((Object)("[backup]                   measure [" + this.nameForStats + "] [" + ii + "] [" + measureDef.getName() + "] [alias:" + measureDef.isAlias() + "] [ignored]"));
                        continue;
                    }
                    OlapLoggers.BACKUP_X.debug((Object)("[backup]                   measure [" + this.nameForStats + "] [" + ii + "] [" + measureDef.getName() + "] [alias:" + measureDef.isAlias() + "] [restoring]"));
                    int backupUUID = in.readInt();
                    this.factsTransformed[ii] = transformation = backupUUID != -1 ? N_DistinctCountTransformKind.valueOf(backupUUID) : null;
                    if (transformation != null) {
                        this.facts[ii] = this.facts[ii].createColumnForDistinctCountTransform(transformation);
                    }
                    OlapScalarEntityFactColumn fact = this.facts[ii];
                    OlapLoggers.BACKUP_X.debug((Object)("[backup]                   measure [" + this.nameForStats + "] [" + ii + "] [" + measureDef.getName() + "] [" + fact.getId().toStringForLogs() + "] [" + fact.getFriendlyTypeName() + "] [transformation:" + String.valueOf((Object)transformation) + "]"));
                    fact.restore(context, in);
                }
            } else {
                for (int ii = 0; ii < this.facts.length; ++ii) {
                    S_MeasureDef measureDef = measureDefs.get(ii);
                    OlapLoggers.BACKUP_X.debug((Object)("[backup]                   measure [" + this.nameForStats + "] [" + ii + "] [" + measureDef.getName() + "] [alias:" + measureDef.isAlias() + "] [" + (this.facts[ii] == null) + "]"));
                    int backupUUID = in.readInt();
                    N_DistinctCountTransformKind columnTransformation = backupUUID != -1 ? N_DistinctCountTransformKind.valueOf(backupUUID) : null;
                    OlapScalarEntityFactColumn factColumn = this.facts[ii];
                    if (factColumn == null) {
                        OlapLoggers.BACKUP_X.debug((Object)("[backup]                   measure [" + this.nameForStats + "] [" + ii + "] [" + measureDef.getName() + "] [alias:" + measureDef.isAlias() + "] [" + (this.facts[ii] == null) + "] [create]"));
                        factColumn = this.createColumn(measureDef);
                    }
                    if (columnTransformation != null) {
                        factColumn = factColumn.createColumnForDistinctCountTransform(columnTransformation);
                    }
                    OlapLoggers.BACKUP_X.debug((Object)("[backup]                   measure [" + this.nameForStats + "] [" + ii + "] [" + measureDef.getName() + "] [alias:" + measureDef.isAlias() + "] [" + factColumn.getId().toStringForLogs() + "] [" + factColumn.getFriendlyTypeName() + "] [measure:" + ii + "] [transformation:" + String.valueOf((Object)columnTransformation) + "]"));
                    factColumn.restore(context, in);
                    if (this.facts[ii] == null) continue;
                    this.factsTransformed[ii] = columnTransformation;
                    this.facts[ii] = factColumn;
                }
            }
            in.sync();
        }
        finally {
            in.closeQuietly();
        }
        OlapLoggers.BACKUP_X.debug((Object)("[backup] restored partition facts [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "] [ " + CdTimeUtils.formatMillisEx((long)startMS) + " ]"));
        startMS = System.currentTimeMillis();
        OlapLoggers.BACKUP_X.debug((Object)("[backup] restoring partition index [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "]"));
        file = new File(dir, this.backupID + ".icc-index");
        in = new S_BackupInputStream(configuration, file);
        try {
            this.bitmapContainer.restore(context, in);
            in.sync();
        }
        finally {
            in.closeQuietly();
        }
        OlapLoggers.BACKUP_X.debug((Object)("[backup] restored partition index [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "] [ " + CdTimeUtils.formatMillisEx((long)startMS) + " ]"));
        OlapLoggers.BACKUP_X.info((Object)("[backup] restored partition [" + this.nameForStats + "/" + this.backupID + "] for schema [" + this.cubeDef.getSchemaName() + "] [ " + CdTimeUtils.formatMillisEx((long)startMS_) + " ]"));
    }

    public void addForCj(OlapFactsBitmapCollector bitmapAndTor, S_FactTupleDef tuple) {
        tuple.forEach((memberType, iHierarchyIndex, hierarchyIndex, memberIndex, info) -> {
            if (memberType.isStandard()) {
                OlapFactsBitmap bitmap = this.bitmapContainer.getForRead(hierarchyIndex, memberIndex);
                bitmapAndTor.add(bitmap == null ? this.getAllBitmap() : bitmap);
            } else if (memberType.isAll()) {
                bitmapAndTor.add(this.getAllBitmap());
            }
        });
    }

    public void addForCj(OlapFactsBitmapCollector bitmapAndTor, S_MemberDef member) {
        if (member.isStandard()) {
            OlapFactsBitmap bitmap = this.bitmapContainer.getForRead(member.getHierIdx(), member.getFactMemberIdx());
            bitmapAndTor.add(bitmap == null ? this.getAllBitmap() : bitmap);
        } else if (member.isAll()) {
            bitmapAndTor.add(this.getAllBitmap());
        } else {
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    public OlapFactsBitmap createGlobalBitmapForCj(N_MdxRequestContext requestContext, OlapTupleDimensionality cjTupleDimensionality) {
        N_MdxRequestBitmapCache bitmapCache = requestContext.getOrCreateBitmapCache(this);
        IFactsBitmapAndTor andTor = OlapFactsBitmapAggregation.facts_createBitmapAndTor(this.nextRowId.get());
        bitmapCache.addToTor(requestContext, andTor, cjTupleDimensionality, null);
        S_TupleDimensionality slicerAndSubDim = bitmapCache.getSlicerAndSubDim();
        requestContext.addDefaults(cjTupleDimensionality.union(slicerAndSubDim), member -> this.addForCj((OlapFactsBitmapCollector)andTor, (S_MemberDef)member));
        return andTor.noAdds() ? OlapFactsBitmapOne.INSTANCE : andTor.facts_asBitmap();
    }

    OlapFactsBitmap getAllBitmap() {
        return OlapFactsBitmapFactory.facts_createBitmapAllOnes(this.getNumberOfRows());
    }

    boolean isNotIndexing(S_FactTupleDef ... tuples) {
        MutableBoolean isIndexing = new MutableBoolean(false);
        for (int ii = 0; ii < tuples.length && !isIndexing.booleanValue(); ++ii) {
            S_FactTupleDef tuple = tuples[ii];
            tuple.forEach((memberType, iHierarchyIndex, hierarchyIndex, memberIndex, info) -> {
                if (this.measureGroup.isIndexingHierarchy(hierarchyIndex)) {
                    isIndexing.setValue(true);
                }
            });
        }
        return !isIndexing.booleanValue();
    }

    @Nullable
    public OlapFactsBitmap getForRead(int hierarchyIndex, int memberIndex) {
        return this.bitmapContainer.getForRead(hierarchyIndex, memberIndex);
    }

    public boolean isNoEmpty(int hierarchyIndex, int memberIndex) {
        return this.bitmapContainer.isNoEmpty(hierarchyIndex, memberIndex);
    }

    @Override
    @Nullable
    public String dt_getPartitionId() {
        return this.nameForDrillthrough;
    }

    @Override
    public boolean dt_isForManyToMany(OlapDimension dimension) {
        return true;
    }

    @Override
    public List<OlapDimension> dt_getIndexingDimensions(List<OlapDimension> dimensions) {
        ArrayList<OlapDimension> iDimensions = new ArrayList<OlapDimension>();
        for (OlapDimension dimension : dimensions) {
            OlapHierarchy hierarchy = dimension.getFactIndexingHierarchy();
            int hierarchyIdx = hierarchy.getTupleDimensionalityIndex();
            if (!this.isIndexingHierarchy(hierarchyIdx)) continue;
            iDimensions.add(dimension);
        }
        return iDimensions;
    }

    private List<OlapLevel> dt_getIndexingLevels(OlapDimension dimension) {
        OlapHierarchy hierarchy = dimension.getFactIndexingHierarchy();
        int hierarchyIdx = hierarchy.getTupleDimensionalityIndex();
        if (!this.isIndexingHierarchy(hierarchyIdx)) {
            return new ArrayList<OlapLevel>();
        }
        List<OlapLevel> levels = hierarchy.getLevels();
        return levels;
    }

    @Override
    public boolean isIndexingHierarchy(int hierarchyIdx) {
        return this.bitmapContainer.isIndexingHierarchy(hierarchyIdx);
    }

    @Override
    public OlapScalarEntityFactColumn dt_getFactColumn(OlapMeasureMember measure) {
        S_MeasureIndex index = this.extractUnderlyingMeasure(measure).getMeasureIndex();
        OlapScalarEntityFactColumn column = this.facts[index.getFactsColumnIndex()];
        return column;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OlapMeasureMember extractUnderlyingMeasure(OlapMeasureMember measure) {
        if (!(measure instanceof OlapUserMeasureMember)) return measure;
        OlapUserMeasureMember userMeasure = (OlapUserMeasureMember)measure;
        List<OlapMeasureMember> refMeasures = userMeasure.getRefMeasures();
        if (refMeasures.size() != 1) throw new RuntimeException("internal error: user defined measure [" + userMeasure.getNameX() + "] with formula not supported");
        return this.extractUnderlyingMeasure(refMeasures.get(0));
    }

    @Override
    public List<OlapMember> dt_getFactIndexingMembers(OlapDimension dimension, IntArrayList rowIds) {
        throw new RuntimeException("internal error: inconsistent DRILLTHROUGH processing");
    }

    @Override
    public List<List<OlapMember>> dt_getFactIndexingMembersForManyToMany(IOlapCancellingContext context, OlapDimension dimension, IntArrayList rowIds) {
        if (!this.dt_isForManyToMany(dimension)) {
            throw new RuntimeException("internal error : inconsistent getFactIndexingMembersForManyToMany usage (regular facts)");
        }
        if (rowIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<OlapLevel> levels = this.dt_getIndexingLevels(dimension);
        DT_UniqueAndSortedList uniqueAndSortedRowIds = new DT_UniqueAndSortedList(rowIds);
        List[] uniqueAndSortedMembers = levels == null || levels.isEmpty() ? new List[uniqueAndSortedRowIds.size()] : this.dt_getFactIndexingMembersForManyToMany(context, levels, uniqueAndSortedRowIds);
        ArrayList<List<OlapMember>> indexingMembers = new ArrayList<List<OlapMember>>();
        for (int idx = 0; idx < rowIds.size(); ++idx) {
            if (idx % 1000 == 0) {
                context.assertNotCancelling("drillthrough");
            }
            int rowId = rowIds.getInt(idx);
            int pos = CdArrayUtils.binarySearch((IntArrayList)uniqueAndSortedRowIds, (int)rowId);
            List member = uniqueAndSortedMembers[pos];
            indexingMembers.add(member);
        }
        return indexingMembers;
    }

    private List<OlapMember>[] dt_getFactIndexingMembersForManyToMany(IOlapCancellingContext context, List<OlapLevel> levels, final DT_UniqueAndSortedList uniqueAndSortedRowIds) {
        final List[] indexingMembers = new List[uniqueAndSortedRowIds.size()];
        OlapFactsBitmapDT uniqueAndSortedRowIdsAsBitmap = uniqueAndSortedRowIds.asBitmap(OlapFactsBitmapFactory.facts_createBitmapDT());
        for (OlapLevel level : levels) {
            IOlapMemoryLevelMember dataHandler = level.getDataHandler();
            dataHandler.forEachMemberEx((CdActionEx<OlapMember>)((CdActionEx)(idx, member) -> {
                OlapFactsBitmap bitmap;
                if (idx % 100 == 0) {
                    context.assertNotCancelling("drillthrough");
                }
                if ((bitmap = this.dt_getForRead((OlapMember)member)) != null && bitmap.isNoEmpty()) {
                    OlapFactsBitmapAggregation.and(uniqueAndSortedRowIdsAsBitmap, bitmap, new OlapBitmapNotStoppableCallback(){
                        final /* synthetic */ OlapMember val$member;
                        {
                            this.val$member = olapMember;
                            Objects.requireNonNull(this$0);
                        }

                        @Override
                        public boolean onRange(int startRowId, int endRowId) {
                            for (int rowId = startRowId; rowId < endRowId; ++rowId) {
                                int pos = CdArrayUtils.binarySearch((IntArrayList)uniqueAndSortedRowIds, (int)rowId);
                                ArrayList<OlapMember> members = indexingMembers[pos];
                                if (members == null) {
                                    indexingMembers[pos] = members = new ArrayList<OlapMember>();
                                }
                                boolean isAncestor = false;
                                for (int ii = 0; ii < members.size(); ++ii) {
                                    OlapMember indexingMember = (OlapMember)members.get(ii);
                                    if (!this.val$member.isAncestor(indexingMember)) continue;
                                    isAncestor = true;
                                    break;
                                }
                                if (isAncestor) continue;
                                boolean added = false;
                                for (int ii = 0; ii < members.size(); ++ii) {
                                    OlapMember indexingMember = (OlapMember)members.get(ii);
                                    if (!indexingMember.isAncestor(this.val$member)) continue;
                                    members.set(ii, this.val$member);
                                    added = true;
                                    break;
                                }
                                if (added) continue;
                                members.add(this.val$member);
                            }
                            return true;
                        }
                    });
                }
                return true;
            }));
        }
        return indexingMembers;
    }

    @Nullable
    private OlapFactsBitmap dt_getForRead(OlapMember member) {
        OlapMember fMember = member.getFactIndexingMember();
        int factHierIdx = fMember.getHierarchy().getTupleDimensionalityIndex();
        int factMemberIdx = fMember.getUniqueHierarchyMemberIndex();
        OlapFactsBitmap bitmap = this.bitmapContainer.getForRead(factHierIdx, factMemberIdx);
        return bitmap;
    }

    @Override
    public int compareTo(@NotNull N_FactPage o) {
        return this.measureGroup.getMeasureGroupName().compareTo(o.measureGroup.getMeasureGroupName());
    }

    public Set<S_HierarchyDef> getBaseHierarchiesWithReverseIndex() {
        return this.measureGroupDef.getBaseHierarchiesWithReverseIndex();
    }

    public N_FactPageColumnLookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new N_FactPageColumnLookup(this);
        }
        return this.lookup;
    }

    private static class NonEmptyFilter
    implements OlapAbstractIteratorFilter<OlapMember> {
        private final N_MdxRequestContext rContext;
        private final IOlapEvaluationExceptionContext eContext;
        private final OlapNameContext nContext;
        private final N_FactBitmapContainer bContainer;
        private final IFastNoEmpty fastNonEmpty;

        public NonEmptyFilter(N_MdxRequestContext rContext, IOlapEvaluationExceptionContext eContext, OlapNameContext nContext, N_FactBitmapContainer bContainer, IFastNoEmpty fastNonEmpty) {
            this.rContext = rContext;
            this.eContext = eContext;
            this.nContext = nContext;
            this.bContainer = bContainer;
            this.fastNonEmpty = fastNonEmpty;
        }

        @Override
        public IOlapIteratorFilter<OlapMember> newInstance() {
            return new NonEmptyFilter(this.rContext, this.eContext, this.nContext, this.bContainer, this.fastNonEmpty);
        }

        @Override
        public boolean accept(OlapMember member) {
            if (member.isAll()) {
                return true;
            }
            if (member.isCategoryMember()) {
                S_MemberDefType memberType = S_MemberDefType.memberType(member);
                int hIndex = member.getHierarchy().getTupleDimensionalityIndex();
                int mIndex = member.getUniqueHierarchyMemberIndex();
                S_FactMemberInfo info = S_FactMemberInfo.setup(memberType, member);
                OlapHierarchyScope scope = info.scope;
                long cacheId = info.cacheId;
                IOlapMembers.touchCategories(member);
                OlapFactsBitmap bitmap = this.rContext.getOrCreateCategoryBitmap(this.bContainer, scope, hIndex, mIndex, cacheId);
                return this.fastNonEmpty.isNoEmpty(bitmap);
            }
            if (member.isCalculated()) {
                throw new OlapEvaluationException(this.eContext, OlapErrorCode.UNEXPECTED_CALC_MEMBER, new Serializable[]{member.getUniqueName(this.nContext)});
            }
            if (this.fastNonEmpty.isAlwaysZero()) {
                return false;
            }
            OlapMember fMember = member.getFactIndexingMember();
            int hierIndex = fMember.getHierarchy().getTupleDimensionalityIndex();
            int fIndex = fMember.getUniqueHierarchyMemberIndex();
            return this.fastNonEmpty.isNoEmpty(hierIndex, fIndex);
        }
    }

    private static class DT_UniqueAndSortedList
    extends IntArrayList {
        private static final long serialVersionUID = -2997125268823077068L;

        public DT_UniqueAndSortedList(IntArrayList other) {
            IntOpenHashSet uniques = new IntOpenHashSet(other.elements());
            this.a = uniques.toIntArray();
            this.size = this.a.length;
            CdArrayUtils.sort((IntArrayList)this);
        }

        public OlapFactsBitmapDT asBitmap(OlapFactsBitmapDT bitmap) {
            for (int idx = 0; idx < this.size(); ++idx) {
                bitmap.setBit(this.getInt(idx));
            }
            return bitmap;
        }
    }
}

