/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts;

import crazydev.common.utils.CdStringUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.apache.log4j.Logger;

public class N_DistinctCountUniques {
    private final Logger logger;
    private final String factsName;
    private final String measureName;
    private final Object2IntOpenHashMap<Object> surrogateKeys = new Object2IntOpenHashMap();
    private long surrogateKey = 0L;

    public N_DistinctCountUniques(Logger logger, String factsName, String measureName) {
        this.logger = logger;
        this.factsName = factsName;
        this.measureName = measureName;
    }

    public void addIfMissing(Comparable value) {
        if (!this.surrogateKeys.containsKey((Object)value)) {
            long key;
            if ((key = this.surrogateKey++) > Integer.MAX_VALUE) {
                throw new RuntimeException("internal error : unsupported number of unique values [" + key + "] for [" + this.factsName + "] [" + this.measureName + "]");
            }
            this.surrogateKeys.put((Object)value, (int)key);
        }
    }

    public void onDone() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("[distinct-count] %s :: distinct-count processing measure [%s] distinct-values count [%s]", this.factsName, this.measureName, CdStringUtils.formatNice((long)this.uniqueFactsCount())));
        }
    }

    public long uniqueFactsCount() {
        return this.surrogateKey;
    }

    public int indexOf(Object value) {
        return this.surrogateKeys.getInt(value);
    }
}

