/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.context;

import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.node.facts.N_SetTupleAggregatorHelper;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.context.S_SetEvaluatorContextInitData;
import crazydev.iccube.cluster.shared.context.S_SetEvaluatorContextRef;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.facts.aggregation.OlapFactsEntityAggregators;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapAggregation;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapFactory;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapVisitor;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class N_SetEvaluatorContext {
    private final N_MdxRequestContext mdxRequestContext;
    private final S_SetEvaluatorContextRef ref;
    private final N_MeasureGroup measureGroup;
    private final S_MeasureRef measureRef;
    private final S_MeasureDef measureDef;
    private final OlapMeasureMember measure;
    private final List<FactPageBitmap> factPageBitmaps;
    @Nullable
    private final OlapFactsEntityAggregators.OlapFactsEntityAggregator aggregator;
    private final OlapAggregationType aggregationType;

    public N_SetEvaluatorContext(N_MdxRequestContext mdxRequestContext, S_SetEvaluatorContextInitData data) {
        this.mdxRequestContext = mdxRequestContext;
        this.ref = data.getRef();
        this.ref.setReferenced(this);
        N_Schema schema = mdxRequestContext.getSchemaContext();
        S_MeasureGroupRef measureGroupRef = data.getMeasureGroupRef();
        this.measureGroup = schema.getMeasureGroup(measureGroupRef);
        this.measure = data.getMeasure();
        this.measureRef = this.measure.getClusterRefs()[0];
        this.measureDef = this.measureGroup.resolveMeasure(this.measureRef);
        this.aggregationType = this.measureDef.getHierarchyAggregationType();
        OlapFactsEntityAggregators.OlapFactsEntityAggregator aggregator = OlapFactsEntityAggregators.regularEntityAggregator(this.aggregationType);
        this.aggregator = !mdxRequestContext.isDrillthroughActive() ? (!aggregator.isDefault() ? aggregator : null) : aggregator;
        List<S_RequestSubCubeDef> subCubes = mdxRequestContext.resolveRequestSubCubes(data.getSubCubes());
        this.factPageBitmaps = this.measureGroup.createSetSeedBitmap(mdxRequestContext, data.getTupleDef(), data.getTupleD(), data.getOverwrittenHierarchies(), data.getVisualTotals(), subCubes);
    }

    public S_SetEvaluatorContextRef getRef() {
        return this.ref;
    }

    private N_MdxRequestContext getMdxRequestContext() {
        return this.mdxRequestContext;
    }

    public boolean isDrillthroughActive() {
        return this.mdxRequestContext.isDrillthroughActive();
    }

    public N_MeasureGroup getMeasureGroup() {
        return this.measureGroup;
    }

    public S_MeasureDef getMeasureDef() {
        return this.measureDef;
    }

    public FactPageBitmap getFactPageBitmap(int index) {
        return this.factPageBitmaps.get(index);
    }

    public int getFactPageBitmapCount() {
        return this.factPageBitmaps == null ? 0 : this.factPageBitmaps.size();
    }

    public OlapScalarEntity evalSetTuple(GFContext gfContext, S_FactTupleDef tupleDef) {
        if (this.aggregator == null) {
            if (this.mdxRequestContext.isDrillthroughActive()) {
                throw new RuntimeException("internal error: missing aggregator (DRILLTHROUGH activated)");
            }
            OlapScalarEntity value = this.measureGroup.aggregateSetTuple(gfContext, this, tupleDef, this.aggregationType);
            OlapScalarEntity res = this.measureDef.toEmptyZeroIfNeeded(value);
            return res;
        }
        N_SetTupleAggregatorHelper helper = new N_SetTupleAggregatorHelper(this, gfContext, this.measureGroup, tupleDef);
        OlapScalarEntity val = this.aggregator.aggregate(helper);
        return val;
    }

    public OlapMeasureMember getMeasure() {
        return this.measure;
    }

    public N_MdxRequestContext getRequestContext() {
        return this.mdxRequestContext;
    }

    public static final class FactPageBitmap {
        @Nullable
        public final OlapFactsBitmap bitmap;
        public final N_FactPage factPage;
        private final OlapBitSet tupleD;

        public FactPageBitmap(OlapBitSet tupleD, @Nullable OlapFactsBitmap bitmap, N_FactPage factPage) {
            this.tupleD = tupleD;
            this.bitmap = bitmap;
            this.factPage = factPage;
        }

        public IFactsBitmapAndTor createSetBitmap(N_SetEvaluatorContext context, S_FactTupleDef tupleDef) {
            IFactsBitmapAndTor andTor = OlapFactsBitmapAggregation.facts_createBitmapAndTor(this.factPage.getNumberOfRows());
            if (this.bitmap != null) {
                andTor.add(this.bitmap);
            }
            tupleDef.forEach((type, iHierarchyIndex, hierarchyIndex, memberIndex, info) -> {
                N_MdxRequestContext requestContext;
                OlapFactsBitmap cBitmap;
                if (!this.tupleD.get(iHierarchyIndex)) {
                    return;
                }
                if (type.isStandard()) {
                    OlapFactsBitmap forRead = this.factPage.getForRead(hierarchyIndex, memberIndex);
                    if (forRead != null) {
                        andTor.add(forRead);
                    }
                } else if (type.isCategory() && (cBitmap = (requestContext = context.getMdxRequestContext()).getOrCreateCategoryBitmap(this.factPage, info.scope, hierarchyIndex, memberIndex, info.cacheId)) != null) {
                    andTor.add(cBitmap);
                }
            });
            return andTor;
        }

        public OlapFactsBitmapVisitor createSetBitmapVisitor(N_SetEvaluatorContext context, S_FactTupleDef tupleDef) {
            IFactsBitmapAndTor andTor = this.createSetBitmap(context, tupleDef);
            if (andTor.noAdds()) {
                OlapFactsBitmap bitmap = OlapFactsBitmapFactory.facts_createBitmapAllOnes(this.factPage.getNumberOfRows());
                return bitmap;
            }
            return andTor;
        }

        public int getNumberOfRows() {
            return this.factPage.getNumberOfRows();
        }

        public OlapScalarEntityFactColumn getColumn(S_MeasureDef measureDef) {
            return this.factPage.getColumn(measureDef);
        }

        public OlapScalarEntityFactColumn.Aggregator createAggregator(S_MeasureDef measureDef, OlapAggregationType aggregationType) {
            OlapScalarEntityFactColumn column = this.factPage.getColumn(measureDef);
            return OlapScalarEntityFactColumn.createMultiColumnAggregator(column, aggregationType);
        }
    }
}

