/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.context;

import crazydev.iccube.cluster.node.context.N_ApplicationContext;
import crazydev.iccube.cluster.node.context.N_FastCrossjoinContext;
import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.context.N_MdxStatementRequestContext;
import crazydev.iccube.cluster.node.schema.N_Category;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.node.schema.N_SessionCategoryManager;
import crazydev.iccube.cluster.shared.context.S_FastCrossjoinContextInitData;
import crazydev.iccube.cluster.shared.context.S_FastCrossjoinContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxRequestContextInitData;
import crazydev.iccube.cluster.shared.context.S_MdxRequestContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxSessionContextInitData;
import crazydev.iccube.cluster.shared.context.S_MdxSessionContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextInitData;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.cluster.shared.context.S_SetEvaluatorContextInitData;
import crazydev.iccube.cluster.shared.context.S_SetEvaluatorContextRef;
import crazydev.iccube.cluster.shared.schema.S_CategoryDef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class N_MdxSessionContext {
    private final N_ApplicationContext appContext;
    private final S_MdxSessionContextRef ref;
    private final Map<S_MdxStatementRequestContextRef, N_MdxStatementRequestContext> mdxStatementRequests = new HashMap<S_MdxStatementRequestContextRef, N_MdxStatementRequestContext>();
    private final N_SessionCategoryManager categoryManager;

    public N_MdxSessionContext(N_ApplicationContext appContext, S_MdxSessionContextInitData data) {
        this.appContext = appContext;
        this.ref = data.getRef();
        this.ref.setReferenced(this);
        this.categoryManager = new N_SessionCategoryManager();
    }

    public N_ApplicationContext getAppContext() {
        return this.appContext;
    }

    public S_MdxSessionContextRef getRef() {
        return this.ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMdxStatementRequestContext(N_Schema schema, S_MdxStatementRequestContextInitData data) {
        N_MdxStatementRequestContext context = new N_MdxStatementRequestContext(this, schema, data);
        S_MdxStatementRequestContextRef ref = context.getRef();
        Map<S_MdxStatementRequestContextRef, N_MdxStatementRequestContext> map = this.mdxStatementRequests;
        synchronized (map) {
            if (this.mdxStatementRequests.get(ref) != null) {
                throw new RuntimeException("internal error: existing MDX statement context [" + String.valueOf(ref) + "]");
            }
            this.mdxStatementRequests.put(ref, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMdxStatementRequestContext(S_MdxStatementRequestContextRef contextRef) {
        Map<S_MdxStatementRequestContextRef, N_MdxStatementRequestContext> map = this.mdxStatementRequests;
        synchronized (map) {
            this.mdxStatementRequests.remove(contextRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public N_MdxStatementRequestContext getMdxStatementRequestContext(S_MdxStatementRequestContextRef ref) {
        Map<S_MdxStatementRequestContextRef, N_MdxStatementRequestContext> map = this.mdxStatementRequests;
        synchronized (map) {
            N_MdxStatementRequestContext request = this.mdxStatementRequests.get(ref);
            if (request == null) {
                throw new RuntimeException("internal error: missing MDX statement context [" + String.valueOf(ref) + "]");
            }
            return request;
        }
    }

    public void createMdxRequestContext(S_MdxRequestContextInitData data) {
        S_MdxStatementRequestContextRef statementContextRef = data.getMdxStatementContextRef();
        N_MdxStatementRequestContext statementContext = this.getMdxStatementRequestContext(statementContextRef);
        statementContext.createMdxRequestContext(data);
    }

    public N_MdxRequestContext getMdxRequestContext(S_MdxStatementRequestContextRef statementContextRef, S_MdxRequestContextRef ref) {
        N_MdxStatementRequestContext statementContext = this.getMdxStatementRequestContext(statementContextRef);
        N_MdxRequestContext request = statementContext.getMdxRequestContext(ref);
        return request;
    }

    public void createFastCrossjoinContext(S_FastCrossjoinContextInitData data) {
        S_MdxStatementRequestContextRef statementContextRef = data.getMdxStatementContextRef();
        N_MdxStatementRequestContext statementContext = this.getMdxStatementRequestContext(statementContextRef);
        statementContext.createFastCrossjoinContext(data);
    }

    public N_FastCrossjoinContext getFastCrossjoinContext(S_MdxStatementRequestContextRef statementContextRef, S_FastCrossjoinContextRef ref) {
        N_MdxStatementRequestContext statementContext = this.getMdxStatementRequestContext(statementContextRef);
        N_FastCrossjoinContext request = statementContext.getFastCrossjoinContext(ref);
        return request;
    }

    public void createSetEvaluatorContext(S_SetEvaluatorContextInitData data) {
        S_MdxStatementRequestContextRef statementContextRef = data.getMdxStatementContextRef();
        S_MdxRequestContextRef mdxRequestContextRef = data.getMdxRequestContextRef();
        N_MdxRequestContext mdxRequestContext = this.getMdxRequestContext(statementContextRef, mdxRequestContextRef);
        mdxRequestContext.createSetEvaluatorContext(mdxRequestContext, data);
    }

    public void deleteSetEvaluatorContext(S_MdxStatementRequestContextRef mdxStatementContextRef, S_MdxRequestContextRef mdxRequestContextRef, S_SetEvaluatorContextRef contextRef) {
        N_MdxRequestContext mdxRequestContext = this.getMdxRequestContext(mdxStatementContextRef, mdxRequestContextRef);
        mdxRequestContext.deleteSetEvaluatorContext(contextRef);
    }

    public void createCategory(N_Schema schema, S_CategoryDef category, List<S_CategoryDef> children) {
        this.categoryManager.addCategory(schema, category, children);
    }

    public String toString() {
        return this.ref.toString();
    }

    @Nullable
    public N_Category lookupCategory(N_Schema schema, int hierarchyIndex, int memberIndex, long cacheId) {
        N_Category category = this.categoryManager.getCategory(schema, hierarchyIndex, memberIndex, cacheId);
        return category;
    }
}

