/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.request;

import crazydev.iccube.cluster.master.request.M_TimeoutRequestManager;
import crazydev.iccube.common.executor.OlapThreadFactory;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class M_DefaultTimeoutRequestManager
extends M_TimeoutRequestManager {
    private final ScheduledExecutorService executor;
    private final ConcurrentHashMap<String, RequestInfo> activeRequests = new ConcurrentHashMap();
    private volatile boolean shutdown;

    public M_DefaultTimeoutRequestManager(int periodS) {
        OlapLoggers.REQUEST_TIMEOUT_MANAGER.info((Object)("[timeout-request-manager] manager initialized [periodS:" + periodS + "]"));
        this.shutdown = false;
        this.executor = Executors.newScheduledThreadPool(1, new OlapThreadFactory("timeout-request"));
        this.executor.scheduleAtFixedRate(new TimeRequestLogic(this), 0L, periodS, TimeUnit.SECONDS);
    }

    @Override
    public void shutdownNow() {
        this.shutdown = true;
        OlapLoggers.REQUEST_TIMEOUT_MANAGER.info((Object)"[timeout-request-manager] shutdown requested");
        this.executor.shutdownNow();
        OlapLoggers.REQUEST_TIMEOUT_MANAGER.info((Object)"[timeout-request-manager] shutdown completed");
    }

    @Override
    public boolean hasRequests() {
        return !this.activeRequests.isEmpty();
    }

    @Override
    public void addRequest(IcCubeRequest request) {
        if (this.shutdown) {
            return;
        }
        String requestUUID = request.getClientUUID();
        try {
            String mdx = request.getMdxForCancelReport();
            if (mdx == null && !request.isMonitoredForTimeout()) {
                return;
            }
            String requestInfo = mdx != null ? mdx : "<not-available>";
            this.activeRequests.put(requestUUID, new RequestInfo(this.requestStatusManager, requestUUID, requestInfo));
            OlapLoggers.REQUEST_TIMEOUT_MANAGER.info((Object)("[timeout-request-manager] added request [" + requestUUID + "] [running:" + this.activeRequests.size() + "] [" + request.getUserFriendlyTypeName() + "]"));
        }
        catch (RuntimeException ex) {
            OlapRequestId requestId = request.getRequestId();
            OlapLoggers.REQUEST_TIMEOUT_MANAGER.error((Object)("[timeout-request-manager] unexpected error while adding the request [" + request.getInternalTypeName() + "] [" + requestId.getId() + "] [" + requestUUID + "]"), (Throwable)ex);
        }
    }

    @Override
    public void removeRequest(String requestUUID) {
        if (this.shutdown) {
            return;
        }
        try {
            this.activeRequests.remove(requestUUID);
            OlapLoggers.REQUEST_TIMEOUT_MANAGER.info((Object)("[timeout-request-manager] removed request [" + requestUUID + "] [running:" + this.activeRequests.size() + "]"));
        }
        catch (RuntimeException ex) {
            OlapLoggers.REQUEST_TIMEOUT_MANAGER.error((Object)("[timeout-request-manager] unexpected error while removing the request [" + requestUUID + "]"), (Throwable)ex);
        }
    }

    private class TimeRequestLogic
    implements Runnable {
        final /* synthetic */ M_DefaultTimeoutRequestManager this$0;

        TimeRequestLogic(M_DefaultTimeoutRequestManager m_DefaultTimeoutRequestManager) {
            M_DefaultTimeoutRequestManager m_DefaultTimeoutRequestManager2 = m_DefaultTimeoutRequestManager;
            Objects.requireNonNull(m_DefaultTimeoutRequestManager2);
            this.this$0 = m_DefaultTimeoutRequestManager2;
        }

        @Override
        public void run() {
            try {
                int activeCount;
                if (OlapLoggers.REQUEST_TIMEOUT_MANAGER.isDebugEnabled()) {
                    int activeCount2 = this.this$0.activeRequests.size();
                    OlapLoggers.REQUEST_TIMEOUT_MANAGER.debug((Object)("[timeout-request-manager] monitoring MDX requests [running:" + activeCount2 + "] " + this.timeouts()));
                } else if (OlapLoggers.REQUEST_TIMEOUT_MANAGER.isInfoEnabled() && (activeCount = this.this$0.activeRequests.size()) > 0) {
                    OlapLoggers.REQUEST_TIMEOUT_MANAGER.info((Object)("[timeout-request-manager] monitoring MDX requests [running:" + activeCount + "] " + this.timeouts()));
                }
                if (this.this$0.shutdown || this.this$0.activeRequests.isEmpty()) {
                    return;
                }
                this.this$0.activeRequests.forEachValue(Long.MAX_VALUE, request -> {
                    if (request.isTimeout()) {
                        if (OlapLoggers.REQUEST_TIMEOUT_MANAGER.isInfoEnabled()) {
                            OlapLoggers.REQUEST_TIMEOUT_MANAGER.info((Object)("[timeout-request-manager] request timeout [" + request.requestUUID + "] cancelling the request"));
                        }
                        request.cancel();
                        this.this$0.activeRequests.remove(request.requestUUID);
                    }
                });
            }
            catch (RuntimeException ex) {
                OlapLoggers.REQUEST_TIMEOUT_MANAGER.error((Object)"[timeout-request-manager] unexpected error while monitoring MDX requests", (Throwable)ex);
            }
        }

        private String timeouts() {
            try {
                HashMap<String, Integer> counts = new HashMap<String, Integer>();
                this.this$0.activeRequests.forEachValue(Long.MAX_VALUE, request -> {
                    String key = this.this$0.requestStatusManager.getRequestTimeoutKey(request.requestUUID);
                    counts.compute(key, (k, count) -> count != null ? count + 1 : 1);
                });
                StringBuilder sb = new StringBuilder();
                counts.forEach((k, c) -> sb.append((String)k).append(":").append(c).append(" "));
                return sb.toString();
            }
            catch (RuntimeException ignored) {
                return "";
            }
        }
    }

    private static class RequestInfo {
        final IcCubeRequestStatusManager requestStatusManager;
        final String requestUUID;
        final String mdx;

        RequestInfo(IcCubeRequestStatusManager requestStatusManager, String requestUUID, String mdx) {
            this.requestStatusManager = requestStatusManager;
            this.requestUUID = requestUUID;
            this.mdx = mdx;
        }

        boolean isTimeout() {
            boolean timeout = this.requestStatusManager.isRequestTimeout(this.requestUUID);
            return timeout;
        }

        void cancel() {
            this.requestStatusManager.cancelRequestOnTimeout(this.requestUUID);
        }
    }
}

