/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.request;

import crazydev.iccube.cluster.master.request.M_CancellingRequestManager;
import crazydev.iccube.common.executor.OlapThreadFactory;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.request.IcCubeRequest;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class M_DefaultCancellingRequestManager
extends M_CancellingRequestManager {
    private final ScheduledExecutorService executor;
    private final ConcurrentHashMap<String, RequestInfo> activeRequests = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RequestInfo> cancellingRequests = new ConcurrentHashMap();
    private volatile boolean shutdown;

    public M_DefaultCancellingRequestManager(int periodS, int timeoutS) {
        OlapLoggers.REQUEST_CANCELLING_MANAGER.info((Object)("[cancelling-request-manager] manager initialized [periodS:" + periodS + "] [timeoutS:" + timeoutS + "]"));
        this.shutdown = false;
        this.executor = Executors.newScheduledThreadPool(1, new OlapThreadFactory("cancelling-request"));
        this.executor.scheduleAtFixedRate(new CancelRequestLogic(this, timeoutS), 0L, periodS, TimeUnit.SECONDS);
    }

    @Override
    public void shutdownNow() {
        this.shutdown = true;
        OlapLoggers.REQUEST_CANCELLING_MANAGER.info((Object)"[cancelling-request-manager] shutdown requested");
        this.executor.shutdownNow();
        OlapLoggers.REQUEST_CANCELLING_MANAGER.info((Object)"[cancelling-request-manager] shutdown completed");
    }

    @Override
    public void addRequest(IcCubeRequest request) {
        if (this.shutdown) {
            return;
        }
        try {
            String mdx = request.getMdxForCancelReport();
            if (mdx == null) {
                return;
            }
            this.activeRequests.put(request.getClientUUID(), new RequestInfo(request.getClientUUID(), mdx));
        }
        catch (RuntimeException ex) {
            OlapRequestId requestId = request.getRequestId();
            OlapLoggers.REQUEST_CANCELLING_MANAGER.error((Object)("[cancelling-request-manager] unexpected error while adding the request [" + request.getInternalTypeName() + "] [" + requestId.getId() + "] [" + request.getClientUUID() + "]"), (Throwable)ex);
        }
    }

    @Override
    public void cancelRequest(String requestUuid) {
        if (this.shutdown) {
            return;
        }
        try {
            RequestInfo request = this.activeRequests.remove(requestUuid);
            if (request != null) {
                request.cancelTimestamp.set(System.currentTimeMillis());
                this.cancellingRequests.put(requestUuid, request);
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.REQUEST_CANCELLING_MANAGER.error((Object)("[cancelling-request-manager] unexpected error while cancelling the request [" + requestUuid + "]"), (Throwable)ex);
        }
    }

    @Override
    public void removeRequest(String requestUuid) {
        if (this.shutdown) {
            return;
        }
        try {
            this.activeRequests.remove(requestUuid);
            this.cancellingRequests.remove(requestUuid);
        }
        catch (RuntimeException ex) {
            OlapLoggers.REQUEST_CANCELLING_MANAGER.error((Object)("[cancelling-request-manager] unexpected error while removing the request [" + requestUuid + "]"), (Throwable)ex);
        }
    }

    private class CancelRequestLogic
    implements Runnable {
        final int timeoutMS;
        final /* synthetic */ M_DefaultCancellingRequestManager this$0;

        CancelRequestLogic(M_DefaultCancellingRequestManager m_DefaultCancellingRequestManager, int timeoutS) {
            M_DefaultCancellingRequestManager m_DefaultCancellingRequestManager2 = m_DefaultCancellingRequestManager;
            Objects.requireNonNull(m_DefaultCancellingRequestManager2);
            this.this$0 = m_DefaultCancellingRequestManager2;
            this.timeoutMS = timeoutS * 1000;
        }

        @Override
        public void run() {
            try {
                if (OlapLoggers.REQUEST_CANCELLING_MANAGER.isDebugEnabled()) {
                    int activeCount = this.this$0.activeRequests.size();
                    int cancellingCount = this.this$0.cancellingRequests.size();
                    OlapLoggers.REQUEST_CANCELLING_MANAGER.debug((Object)("[cancelling-request-manager] monitoring MDX requests [running:" + activeCount + "] [cancelling:" + cancellingCount + "]"));
                } else if (OlapLoggers.REQUEST_CANCELLING_MANAGER.isInfoEnabled()) {
                    int activeCount = this.this$0.activeRequests.size();
                    int cancellingCount = this.this$0.cancellingRequests.size();
                    if (activeCount > 0 || cancellingCount > 0) {
                        OlapLoggers.REQUEST_CANCELLING_MANAGER.info((Object)("[cancelling-request-manager] monitoring MDX requests [running:" + activeCount + "] [cancelling:" + cancellingCount + "]"));
                    }
                }
                if (this.this$0.shutdown || this.this$0.cancellingRequests.isEmpty()) {
                    return;
                }
                this.this$0.cancellingRequests.forEachValue(Long.MAX_VALUE, request -> {
                    if (request.isTimeout(this.timeoutMS)) {
                        if (OlapLoggers.REQUEST_CANCELLED.isInfoEnabled()) {
                            OlapLoggers.REQUEST_CANCELLED.info((Object)("request [" + request.requestUUID + "]\n" + request.mdx));
                        }
                        this.this$0.cancellingRequests.remove(request.requestUUID);
                    }
                });
            }
            catch (RuntimeException ex) {
                OlapLoggers.REQUEST_CANCELLING_MANAGER.error((Object)"[cancelling-request-manager] unexpected error while monitoring MDX requests", (Throwable)ex);
            }
        }
    }

    private static class RequestInfo {
        final String requestUUID;
        final String mdx;
        final AtomicLong cancelTimestamp = new AtomicLong(-1L);

        RequestInfo(String requestUUID, String mdx) {
            this.requestUUID = requestUUID;
            this.mdx = mdx;
        }

        boolean isTimeout(int timeoutMS) {
            long startMS = this.cancelTimestamp.get();
            if (startMS == -1L) {
                return false;
            }
            long elapsedMS = System.currentTimeMillis() - startMS;
            return elapsedMS > (long)timeoutMS;
        }
    }
}

