/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.local.facts;

import crazydev.iccube.cluster.master.facts.M_ClusterRegularTupleAggregator;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;

public class M_LocalClusterRegularTupleAggregator
extends M_ClusterRegularTupleAggregator {
    private final M_LocalCluster cluster;
    private final N_OlapEngine engine;
    private final S_MeasureGroupRef measureGroupRef;

    public M_LocalClusterRegularTupleAggregator(M_LocalCluster cluster, S_MeasureGroupRef measureGroupRef, GFContext context, GFFactsEvalTuple tuple) {
        super(context, tuple);
        this.cluster = cluster;
        this.engine = cluster.getEngine();
        this.measureGroupRef = measureGroupRef;
    }

    public IOlapIteratorFilter<OlapMember> getFastNonEmptyFilter(GFContext context) {
        return this.engine.getFastNonEmptyFilter(this.sessionContextRef, this.mdxStatementContextRef, this.mdxRequestContextRef, context, this.measureGroupRef, this.measure, this.tuple, this.overwrittenHierarchies, this.visualTotals, this.subCubes);
    }

    @Override
    public OlapScalarEntity aggregateTuple(GFContext context) {
        OlapInstrExecListener listener = context.getInstrExecListener();
        boolean instrExecListening = context.isInstrExecListening();
        OlapScalarEntity res = listener != null && instrExecListening ? this.doAggregateTupleAndListen(context, listener) : this.doAggregateTuple(context);
        if (!context.isStatsFrozen()) {
            this.onTupleAggregate(this.tuple, this.measure);
        }
        return res;
    }

    private OlapScalarEntity doAggregateTupleAndListen(GFContext context, OlapInstrExecListener listener) {
        listener.beginFactTupleAggregation(this.tuple);
        try {
            OlapScalarEntity res = this.doAggregateTuple(context);
            listener.endFactTupleAggregation(this.tuple, res);
            return res;
        }
        catch (RuntimeException ex) {
            listener.endFactTupleAggregationOnError(this.tuple, ex);
            throw ex;
        }
    }

    private OlapScalarEntity doAggregateTuple(GFContext context) {
        if (context.isDrillthroughActive()) {
            context.pushCurrentTupleForDrillthrough(this.tuple);
        }
        OlapScalarEntity res = this.engine.evalTuple(this.sessionContextRef, this.mdxStatementContextRef, this.mdxRequestContextRef, context, this.measureGroupRef, this.measure, this.tuple, this.overwrittenHierarchies, this.visualTotals, this.subCubes);
        if (context.isDrillthroughActive()) {
            context.popCurrentTupleForDrillthrough();
        }
        return res;
    }
}

